/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.debugger;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.php.debug.core.debugger.IDebugHandler;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;

public class DebugHandlersRegistry {
    private static final String EXTENSION_POINT_NAME = "phpDebugHandlers";
    private static final String HANDLER_TAG = "handler";
    private static final String ID_ATTRIBUTE = "id";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String REMOTE_DEBUGGER_ATTRIBUTE = "debugger";
    private Dictionary actions = new Hashtable();
    private Dictionary debuggers = new Hashtable();
    private static DebugHandlersRegistry instance = null;

    private DebugHandlersRegistry() {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor(PHPDebugPlugin.getID(), EXTENSION_POINT_NAME);
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            if (HANDLER_TAG.equals(iConfigurationElement.getName())) {
                this.actions.put(iConfigurationElement.getAttribute(ID_ATTRIBUTE), new DebugHandlerFactory(iConfigurationElement));
                String string = iConfigurationElement.getAttribute(REMOTE_DEBUGGER_ATTRIBUTE);
                if (string != null) {
                    this.debuggers.put(iConfigurationElement.getAttribute(ID_ATTRIBUTE), string);
                }
            }
            ++n;
        }
    }

    private static DebugHandlersRegistry getInstance() {
        if (instance == null) {
            instance = new DebugHandlersRegistry();
        }
        return instance;
    }

    private Dictionary getHandlers() {
        return this.actions;
    }

    public static IDebugHandler getHandler(String string) throws Exception {
        return ((DebugHandlerFactory)DebugHandlersRegistry.getInstance().getHandlers().get(string)).createHandler();
    }

    public static String getRemoteDebuggerID(String string) {
        return (String)DebugHandlersRegistry.getInstance().debuggers.get(string);
    }

    class DebugHandlerFactory {
        IDebugHandler handler;
        IConfigurationElement element;

        public DebugHandlerFactory(IConfigurationElement iConfigurationElement) {
            this.element = iConfigurationElement;
        }

        public IDebugHandler createHandler() {
            Platform.run((ISafeRunnable)new SafeRunnable("Error creation extension for extension-point org.eclipse.php.internal.debug.core.phpDebugHandlers"){

                public void run() throws Exception {
                    DebugHandlerFactory.this.handler = (IDebugHandler)DebugHandlerFactory.this.element.createExecutableExtension(DebugHandlersRegistry.CLASS_ATTRIBUTE);
                }
            });
            return this.handler;
        }
    }
}

