/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.php.internal.core.project.IIncludePathEntry;
import org.eclipse.php.internal.core.project.options.PHPProjectOptions;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.debugger.DefaultExpression;
import org.eclipse.php.internal.debug.core.debugger.DefaultExpressionsManager;
import org.eclipse.php.internal.debug.core.debugger.Expression;
import org.eclipse.php.internal.debug.core.debugger.ExpressionValue;
import org.eclipse.php.internal.debug.core.debugger.IRemoteDebugger;
import org.eclipse.php.internal.debug.core.debugger.PHPstack;
import org.eclipse.php.internal.debug.core.debugger.RemoteDebugger;
import org.eclipse.php.internal.debug.core.debugger.StackLayer;
import org.eclipse.php.internal.debug.core.model.PHPDebugTarget;
import org.eclipse.php.internal.debug.core.model.PHPStackFrame;
import org.eclipse.php.internal.debug.core.model.PHPThread;
import org.eclipse.php.internal.debug.core.model.PHPVariable;

public class ContextManager {
    private PHPDebugTarget fTarget;
    private IRemoteDebugger fDebugger;
    private StackLayer[] fPreviousLayers;
    private IStackFrame[] fPreviousFrames = null;
    private Map fStackVariables;
    private int fSuspendCount;
    private IVariable[] fVariables;

    public ContextManager(PHPDebugTarget pHPDebugTarget, IRemoteDebugger iRemoteDebugger) {
        this.fTarget = pHPDebugTarget;
        this.fSuspendCount = pHPDebugTarget.getSuspendCount();
        this.fDebugger = iRemoteDebugger;
        this.fStackVariables = new HashMap();
    }

    public IStackFrame[] getStackFrames(int n, String string, boolean bl) throws DebugException {
        PHPstack pHPstack = this.fDebugger.getCallStack();
        PHPThread pHPThread = (PHPThread)this.fTarget.getThreads()[0];
        StackLayer[] stackLayerArray = pHPstack.getLayers();
        boolean bl2 = false;
        if (stackLayerArray.length == 1) {
            bl2 = true;
        }
        if (this.fPreviousFrames == null) {
            this.fPreviousFrames = this.createNewFrames(stackLayerArray, pHPThread, n, string, bl);
            this.fVariables = this.createVariables(bl2, false, true);
            this.createStackVariables(stackLayerArray);
            this.fSuspendCount = this.fTarget.getSuspendCount();
            return this.fPreviousFrames;
        }
        if (this.fSuspendCount == this.fTarget.getSuspendCount()) {
            return this.fPreviousFrames;
        }
        this.fSuspendCount = this.fTarget.getSuspendCount();
        boolean bl3 = this.compareLayers(stackLayerArray, this.fPreviousLayers);
        if (bl3) {
            this.fVariables = this.createVariables(bl2, false, false);
        } else {
            this.fPreviousFrames = this.createNewFrames(stackLayerArray, pHPThread, n, string, bl);
            this.fVariables = this.createVariables(bl2, false, true);
        }
        int n2 = this.fPreviousFrames[0] instanceof PHPStackFrame ? ((PHPStackFrame)this.fPreviousFrames[0]).getIdentifier() : 0;
        this.fPreviousFrames[0] = new PHPStackFrame(pHPThread, this.fTarget.getLastFileName(), bl2 ? "" : this.fPreviousFrames[1].getName(), this.fTarget.getLastStop(), n2, this.getLocalFileName(this.fTarget.getLastFileName(), string, n, bl));
        this.createStackVariables(stackLayerArray);
        return this.fPreviousFrames;
    }

    public IVariable[] getVariables() {
        return this.fVariables;
    }

    public Expression[] getStackVariables(PHPStackFrame pHPStackFrame) {
        String string = "";
        try {
            string = pHPStackFrame.getName();
        }
        catch (DebugException debugException) {
            Logger.logException("PHP Problem getting name from stack", debugException);
        }
        Expression[] expressionArray = new Expression[]{};
        if (!string.equals("")) {
            String string2 = String.valueOf(string) + pHPStackFrame.getAbsoluteFileName();
            expressionArray = (Expression[])this.fStackVariables.get(string2);
        }
        return expressionArray;
    }

    private boolean compareLayers(StackLayer[] stackLayerArray, StackLayer[] stackLayerArray2) {
        if (stackLayerArray.length != stackLayerArray2.length) {
            return false;
        }
        int n = 1;
        while (n < stackLayerArray.length) {
            if (!this.compareLayer(stackLayerArray[n], stackLayerArray2[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean compareLayer(StackLayer stackLayer, StackLayer stackLayer2) {
        return stackLayer.getCallerFileName().equals(stackLayer2.getCallerFileName()) && stackLayer.getCallerFunctionName().equals(stackLayer2.getCallerFunctionName()) && stackLayer.getCallerLineNumber() == stackLayer2.getCallerLineNumber() && stackLayer.getCalledFileName().equals(stackLayer2.getCalledFileName()) && stackLayer.getCalledFunctionName().equals(stackLayer2.getCalledFunctionName()) && stackLayer.getCalledLineNumber() == stackLayer2.getCalledLineNumber();
    }

    private IStackFrame[] createNewFrames(StackLayer[] stackLayerArray, PHPThread pHPThread, int n, String string, boolean bl) throws DebugException {
        IStackFrame[] iStackFrameArray = new IStackFrame[(stackLayerArray.length - 1) * 2 + 1];
        int n2 = (stackLayerArray.length - 1) * 2 + 1;
        int n3 = 1;
        while (n3 < stackLayerArray.length) {
            String string2 = RemoteDebugger.convertToSystemIndependentFileName(stackLayerArray[n3].getCallerFileName());
            String string3 = this.getLocalFileName(string2, string, n, bl);
            iStackFrameArray[n2 - 1] = new PHPStackFrame(pHPThread, string2, stackLayerArray[n3].getCallerFunctionName(), stackLayerArray[n3].getCallerLineNumber() + 1, n2, string3);
            string2 = RemoteDebugger.convertToSystemIndependentFileName(stackLayerArray[n3].getCalledFileName());
            string3 = this.getLocalFileName(string2, string, n, bl);
            iStackFrameArray[--n2 - 1] = new PHPStackFrame(pHPThread, string2, stackLayerArray[n3].getCalledFunctionName(), stackLayerArray[n3].getCalledLineNumber() + 1, n2, stackLayerArray[n3], string3);
            --n2;
            ++n3;
        }
        iStackFrameArray[0] = new PHPStackFrame(pHPThread, this.fTarget.getLastFileName(), stackLayerArray.length == 1 ? "" : iStackFrameArray[1].getName(), this.fTarget.getLastStop(), n2, this.getLocalFileName(this.fTarget.getLastFileName(), string, n, bl));
        this.fPreviousLayers = stackLayerArray;
        return iStackFrameArray;
    }

    private void createStackVariables(StackLayer[] stackLayerArray) {
        this.fStackVariables.clear();
        int n = 0;
        while (n < stackLayerArray.length) {
            Expression[] expressionArray = stackLayerArray[n].getVariables();
            if (expressionArray.length != 0) {
                String string = String.valueOf(stackLayerArray[n].getCalledFunctionName()) + RemoteDebugger.convertToSystemIndependentFileName(stackLayerArray[n].getCalledFileName());
                this.fStackVariables.put(string, expressionArray);
            }
            ++n;
        }
    }

    private IVariable[] createVariables(boolean bl, boolean bl2, boolean bl3) {
        IVariable[] iVariableArray;
        DefaultExpressionsManager defaultExpressionsManager = this.fTarget.getExpressionManager();
        if (bl3) {
            defaultExpressionsManager.clear();
        }
        Expression[] expressionArray = defaultExpressionsManager.getLocalVariables(1);
        Expression[] expressionArray2 = defaultExpressionsManager.getGlobalVariables(1);
        if (bl) {
            iVariableArray = new PHPVariable[expressionArray.length];
            int n = 0;
            while (n < expressionArray.length) {
                iVariableArray[n] = new PHPVariable(this.fTarget, expressionArray[n]);
                ++n;
            }
        } else {
            iVariableArray = new PHPVariable[expressionArray.length + 1];
            int n = 0;
            while (n < expressionArray.length) {
                iVariableArray[n + 1] = new PHPVariable(this.fTarget, expressionArray[n]);
                ++n;
            }
            String string = "$GLOBALS";
            DefaultExpression defaultExpression = new DefaultExpression(string);
            String string2 = "Array";
            String string3 = String.valueOf(string2) + " [" + new Integer(expressionArray2.length).toString() + "]";
            ExpressionValue expressionValue = new ExpressionValue(5, string2, string3, expressionArray2);
            defaultExpression.setValue(expressionValue);
            iVariableArray[0] = new PHPVariable(this.fTarget, defaultExpression, true);
        }
        return iVariableArray;
    }

    private String getLocalFileName(String string, String string2, int n, boolean bl) {
        Object object;
        IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.fTarget.getProjectName());
        if (iProject != null && (object = PHPProjectOptions.forProject((IProject)iProject)) != null) {
            IIncludePathEntry[] iIncludePathEntryArray = object.readRawIncludePath();
            int n2 = 0;
            while (n2 < iIncludePathEntryArray.length) {
                String string3 = iIncludePathEntryArray[n2].getPath().toString();
                if (string.startsWith(string3)) {
                    return string.substring(string3.length());
                }
                ++n2;
            }
        }
        String string4 = object = string.length() > n ? string.substring(n) : String.valueOf('/') + string;
        if (string2 == null) {
            if (((String)object).startsWith("/")) {
                object = ((String)object).substring(1);
            }
            return object;
        }
        if (bl) {
            object = ((String)object).toLowerCase().startsWith(string2.toLowerCase()) ? ((String)object).substring(string2.length()) : ((String)object).substring(1);
        } else if (((String)object).startsWith(string2)) {
            object = ((String)object).substring(string2.length());
        }
        return object;
    }
}

