/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.sourcelookup.containers;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.containers.DirectorySourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.ZipEntryStorage;
import org.eclipse.php.internal.core.containers.LocalFileStorage;
import org.eclipse.php.internal.debug.core.Logger;

public class PHPDirectorySourceContainer
extends DirectorySourceContainer {
    private IProject project;

    public PHPDirectorySourceContainer(File file, boolean bl, IProject iProject) {
        super(file, bl);
        this.project = iProject;
    }

    public PHPDirectorySourceContainer(IPath iPath, boolean bl) {
        super(iPath.toFile(), bl);
    }

    public Object[] findSourceElements(String string) throws CoreException {
        Object[] objectArray = super.findSourceElements(string);
        return this.processObjects(objectArray);
    }

    protected Object[] findSourceElements(String string, ISourceContainer[] iSourceContainerArray) throws CoreException {
        Object[] objectArray = super.findSourceElements(string, iSourceContainerArray);
        return this.processObjects(objectArray);
    }

    public String getName() {
        return super.getName();
    }

    public ISourceContainerType getType() {
        return null;
    }

    private Object[] processObjects(Object[] objectArray) {
        Object[] objectArray2 = new Object[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            LocalFileStorage localFileStorage;
            if (objectArray[n] instanceof org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage) {
                org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage localFileStorage2 = (org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage)objectArray[n];
                localFileStorage = new LocalFileStorage(localFileStorage2.getFile());
                localFileStorage.setProject(this.project);
                try {
                    localFileStorage.setIncBaseDirName(this.getDirectory().getCanonicalPath());
                }
                catch (IOException iOException) {
                    Logger.logException("Unexpected error in PHPDirectorySourceContainer", iOException);
                }
                objectArray2[n] = localFileStorage;
            } else if (objectArray[n] instanceof ZipEntryStorage) {
                ZipEntryStorage zipEntryStorage = (ZipEntryStorage)objectArray[n];
                localFileStorage = new org.eclipse.php.internal.core.containers.ZipEntryStorage(zipEntryStorage.getArchive(), zipEntryStorage.getZipEntry());
                localFileStorage.setProject(this.project);
                objectArray2[n] = localFileStorage;
            } else {
                objectArray2[n] = objectArray[n];
            }
            ++n;
        }
        return objectArray2;
    }
}

