/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.preferences.PreferenceConstants;
import org.eclipse.php.internal.ui.util.IStringValidator;
import org.eclipse.php.internal.ui.util.ValidationStatus;
import org.eclipse.php.internal.ui.util.ValuedCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class AbstractPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    protected ArrayList buttons = new ArrayList();
    protected ArrayList textBoxes = new ArrayList();
    protected ArrayList labels = new ArrayList();
    protected ArrayList combos = new ArrayList();

    protected void add(Button button) {
        this.buttons.add(button);
    }

    protected void add(Text text) {
        this.textBoxes.add(text);
    }

    protected void add(Label label) {
        this.labels.add(label);
    }

    protected void add(ValuedCombo valuedCombo) {
        this.combos.add(valuedCombo);
    }

    protected void restoreDefaultValues() {
        this.restoreDefaultButtonValues();
        this.restoreDefaultTextValues();
        this.restoreDefaultComboTextValues();
    }

    protected void restoreDefaultComboTextValues() {
        for (ValuedCombo valuedCombo : this.combos) {
            Object object = valuedCombo.getData();
            if (object == null) continue;
            valuedCombo.selectValue(this.getPreferenceStore().getDefaultString((String)object));
        }
    }

    protected void restoreDefaultTextValues() {
        Object[] objectArray = this.textBoxes.toArray();
        int n = 0;
        while (n < objectArray.length) {
            Text text = (Text)objectArray[n];
            Object object = text.getData();
            if (object != null) {
                text.setText(this.getPreferenceStore().getDefaultString((String)object));
            }
            ++n;
        }
    }

    protected void restoreDefaultButtonValues() {
        Object[] objectArray = this.buttons.toArray();
        int n = 0;
        while (n < objectArray.length) {
            Button button = (Button)objectArray[n];
            Object object = button.getData();
            if (object != null) {
                button.setSelection(this.getPreferenceStore().getDefaultBoolean((String)object));
            }
            ++n;
        }
    }

    protected void initializeValues() {
        this.initializeButtonsValues();
        this.initializeTextValues();
        this.initializeComboValues();
    }

    protected void initializeComboValues() {
        for (ValuedCombo valuedCombo : this.combos) {
            Object object = valuedCombo.getData();
            if (object == null) continue;
            valuedCombo.selectValue(this.getPreferenceStore().getString((String)object));
        }
    }

    protected void initializeTextValues() {
        Object[] objectArray = this.textBoxes.toArray();
        int n = 0;
        while (n < objectArray.length) {
            Text text = (Text)objectArray[n];
            Object object = text.getData();
            if (object != null) {
                text.setText(this.getPreferenceStore().getString((String)object));
            }
            ++n;
        }
    }

    protected void initializeButtonsValues() {
        Object[] objectArray = this.buttons.toArray();
        int n = 0;
        while (n < objectArray.length) {
            Button button = (Button)objectArray[n];
            Object object = button.getData();
            if (object != null) {
                button.setSelection(this.getPreferenceStore().getBoolean((String)object));
            }
            ++n;
        }
    }

    protected void storeValues() {
        this.storeButtonsValues();
        this.storeTextValues();
        this.storeCombosValues();
    }

    protected void storeCombosValues() {
        for (ValuedCombo valuedCombo : this.combos) {
            Object object = valuedCombo.getData();
            if (object == null) continue;
            this.getPreferenceStore().setValue((String)object, valuedCombo.getSelectionValue());
        }
    }

    protected void storeTextValues() {
        Object[] objectArray = this.textBoxes.toArray();
        int n = 0;
        while (n < objectArray.length) {
            Text text = (Text)objectArray[n];
            Object object = text.getData();
            if (object != null) {
                this.getPreferenceStore().setValue((String)object, text.getText());
            }
            ++n;
        }
    }

    protected void storeButtonsValues() {
        Object[] objectArray = this.buttons.toArray();
        int n = 0;
        while (n < objectArray.length) {
            Button button = (Button)objectArray[n];
            Object object = button.getData();
            if (object != null) {
                this.getPreferenceStore().setValue((String)object, button.getSelection());
            }
            ++n;
        }
    }

    protected void setControlsEnabled(String string, boolean bl) {
        this.setControlsEnabled(this.buttons, string, bl);
        this.setControlsEnabled(this.textBoxes, string, bl);
        this.setControlsEnabled(this.labels, string, bl);
        this.setControlsEnabled(this.combos, string, bl);
    }

    private void setControlsEnabled(ArrayList arrayList, String string, boolean bl) {
        for (Control control : arrayList) {
            Object object = control.getData();
            if (object == null || !((String)object).equals(string)) continue;
            control.setEnabled(bl);
        }
    }

    protected FontMetrics getFontMetrics(Control control) {
        GC gC = new GC((Drawable)control);
        gC.setFont(control.getFont());
        FontMetrics fontMetrics = gC.getFontMetrics();
        gC.dispose();
        return fontMetrics;
    }

    protected Composite createSubsection(Composite composite, String string) {
        Group group = new Group(composite, 32);
        group.setText(string);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        group.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        group.setLayout((Layout)gridLayout);
        return group;
    }

    protected Button addCheckBox(Composite composite, String string, String string2, int n) {
        Button button = new Button(composite, 32);
        button.setText(string);
        GridData gridData = new GridData(256);
        gridData.horizontalIndent = n;
        gridData.horizontalSpan = 3;
        button.setLayoutData((Object)gridData);
        button.setData((Object)string2);
        this.add(button);
        return button;
    }

    protected Text addLabelledTextField(Composite composite, String string, String string2, int n, int n2, IStringValidator iStringValidator) {
        Label label = new Label(composite, 64);
        label.setText(string);
        label.setData((Object)string2);
        GridData gridData = new GridData();
        gridData.horizontalIndent = n2;
        label.setLayoutData((Object)gridData);
        this.add(label);
        Text text = new Text(composite, 2052);
        text.setData((Object)string2);
        gridData = new GridData();
        if (n != 0) {
            text.setTextLimit(n);
            gridData.widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)this.getFontMetrics((Control)composite), (int)(n + 1));
        }
        gridData.horizontalSpan = 2;
        text.setLayoutData((Object)gridData);
        if (iStringValidator != null) {
            text.addModifyListener((ModifyListener)new TextFieldValidateListener(iStringValidator));
        }
        this.add(text);
        return text;
    }

    protected Text addLabelledTextField(Composite composite, String string, String string2, int n, int n2) {
        return this.addLabelledTextField(composite, string, string2, n, n2, null);
    }

    protected Control createContents(Composite composite) {
        return new Composite(composite, 0);
    }

    public void init(IWorkbench iWorkbench) {
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return PreferenceConstants.getPreferenceStore();
    }

    protected void performDefaults() {
        super.performDefaults();
        this.restoreDefaultValues();
    }

    public boolean performOk() {
        this.storeValues();
        PHPUiPlugin.getDefault().savePluginPreferences();
        return super.performOk();
    }

    class TextFieldValidateListener
    implements ModifyListener {
        private IStringValidator stringValidator;

        public TextFieldValidateListener(IStringValidator iStringValidator) {
            this.stringValidator = iStringValidator;
        }

        public void modifyText(ModifyEvent modifyEvent) {
            ValidationStatus validationStatus = this.stringValidator.validate(((Text)modifyEvent.widget).getText());
            if (!validationStatus.isOK()) {
                AbstractPreferencePage.this.setErrorMessage(validationStatus.getError());
                AbstractPreferencePage.this.setValid(false);
            } else {
                AbstractPreferencePage.this.setErrorMessage(null);
                AbstractPreferencePage.this.setValid(true);
            }
        }
    }
}

