/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.php.internal.core.documentModel.parser.regions.PhpScriptRegion;
import org.eclipse.php.internal.core.documentModel.provisional.contenttype.ContentTypeIdForPHP;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.highlighter.LineStyleProviderForPhp;
import org.eclipse.php.internal.ui.preferences.PreferenceConstants;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.preferences.OverlayPreferenceStore;
import org.eclipse.wst.sse.ui.internal.preferences.ui.ColorHelper;
import org.eclipse.wst.sse.ui.internal.util.EditorUtility;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;

public final class PHPSyntaxColoringPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button fBold;
    private Label fForegroundLabel;
    private Label fBackgroundLabel;
    private Button fClearStyle;
    private Map fContextToStyleMap;
    private Color fDefaultForeground = null;
    private Color fDefaultBackground = null;
    private IStructuredDocument fDocument;
    private ColorSelector fForegroundColorEditor;
    private ColorSelector fBackgroundColorEditor;
    private Button fItalic;
    private OverlayPreferenceStore fOverlayStore;
    private Button fStrike;
    private Collection fStylePreferenceKeys;
    private StructuredViewer fStylesViewer = null;
    private Map fStyleToDescriptionMap;
    private StyledText fText;
    private Button fUnderline;
    private LineStyleProviderForPhp fStyleProvider = new LineStyleProviderForPhp();

    private void activate(String string) {
        Color color = this.fDefaultForeground;
        Color color2 = this.fDefaultBackground;
        if (string == null) {
            this.fClearStyle.setEnabled(false);
            this.fBold.setEnabled(false);
            this.fItalic.setEnabled(false);
            this.fStrike.setEnabled(false);
            this.fUnderline.setEnabled(false);
            this.fForegroundLabel.setEnabled(false);
            this.fBackgroundLabel.setEnabled(false);
            this.fForegroundColorEditor.setEnabled(false);
            this.fBackgroundColorEditor.setEnabled(false);
            this.fBold.setSelection(false);
            this.fItalic.setSelection(false);
            this.fStrike.setSelection(false);
            this.fUnderline.setSelection(false);
        } else {
            TextAttribute textAttribute = this.getAttributeFor(string);
            this.fClearStyle.setEnabled(true);
            this.fBold.setEnabled(true);
            this.fItalic.setEnabled(true);
            this.fStrike.setEnabled(true);
            this.fUnderline.setEnabled(true);
            this.fForegroundLabel.setEnabled(true);
            this.fBackgroundLabel.setEnabled(true);
            this.fForegroundColorEditor.setEnabled(true);
            this.fBackgroundColorEditor.setEnabled(true);
            this.fBold.setSelection((textAttribute.getStyle() & 1) != 0);
            this.fItalic.setSelection((textAttribute.getStyle() & 2) != 0);
            this.fStrike.setSelection((textAttribute.getStyle() & 0x20000000) != 0);
            this.fUnderline.setSelection((textAttribute.getStyle() & 0x40000000) != 0);
            if (textAttribute.getForeground() != null) {
                color = textAttribute.getForeground();
            }
            if (textAttribute.getBackground() != null) {
                color2 = textAttribute.getBackground();
            }
        }
        this.fForegroundColorEditor.setColorValue(color.getRGB());
        this.fBackgroundColorEditor.setColorValue(color2.getRGB());
    }

    void applyStyles() {
        if (this.fText == null || this.fText.isDisposed()) {
            return;
        }
        this.fStyleProvider.loadColors();
        IStructuredDocumentRegion iStructuredDocumentRegion = this.fDocument.getFirstStructuredDocumentRegion();
        while (iStructuredDocumentRegion != null) {
            ArrayList arrayList = new ArrayList();
            this.fStyleProvider.prepareTextRegions(iStructuredDocumentRegion, 0, iStructuredDocumentRegion.getEnd(), arrayList);
            for (StyleRange styleRange : arrayList) {
                this.fText.setStyleRange(styleRange);
            }
            iStructuredDocumentRegion = iStructuredDocumentRegion.getNext();
        }
    }

    Button createCheckbox(Composite composite, String string) {
        Button button = new Button(composite, 32);
        button.setText(string);
        button.setLayoutData((Object)new GridData(4, 4, true, false));
        return button;
    }

    private Composite createComposite(Composite composite, int n) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = n;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 4, true, false);
        composite2.setLayoutData((Object)gridData);
        return composite2;
    }

    protected Control createContents(final Composite composite) {
        this.initializeDialogUnits((Control)composite);
        this.fDefaultForeground = composite.getDisplay().getSystemColor(24);
        this.fDefaultBackground = composite.getDisplay().getSystemColor(25);
        Composite composite2 = this.createComposite(composite, 2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite2, "org.eclipse.php.ui.php_syntax_coloring_preference_page");
        Link link = new Link(composite2, 64);
        link.setText(SSEUIMessages.SyntaxColoring_Link);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PreferencesUtil.createPreferenceDialogOn((Shell)composite.getShell(), (String)selectionEvent.text, null, null);
            }
        });
        GridData gridData = new GridData(4, 1, true, false, 2, 1);
        gridData.widthHint = 150;
        link.setLayoutData((Object)gridData);
        new Label(composite2, 0).setLayoutData((Object)new GridData());
        new Label(composite2, 0).setLayoutData((Object)new GridData());
        SashForm sashForm = new SashForm(composite2, 512);
        GridData gridData2 = new GridData(4, 4, true, true);
        gridData2.horizontalSpan = 2;
        sashForm.setLayoutData((Object)gridData2);
        SashForm sashForm2 = new SashForm((Composite)sashForm, 256);
        Composite composite3 = this.createComposite((Composite)sashForm2, 1);
        ((GridLayout)composite3.getLayout()).marginRight = 5;
        ((GridLayout)composite3.getLayout()).marginLeft = 0;
        this.createLabel(composite3, XMLUIMessages.SyntaxColoringPage_0);
        this.fStylesViewer = this.createStylesViewer(composite3);
        GridData gridData3 = new GridData(4, 4, true, true);
        gridData3.horizontalIndent = 0;
        Iterator iterator = this.fStyleToDescriptionMap.values().iterator();
        while (iterator.hasNext()) {
            gridData3.widthHint = Math.max(gridData3.widthHint, this.convertWidthInCharsToPixels(iterator.next().toString().length()));
        }
        gridData3.heightHint = this.convertHeightInCharsToPixels(5);
        this.fStylesViewer.getControl().setLayoutData((Object)gridData3);
        Composite composite4 = this.createComposite((Composite)sashForm2, 1);
        ((GridLayout)composite3.getLayout()).marginLeft = 5;
        this.createLabel(composite4, "");
        Button button = this.createCheckbox(composite4, XMLUIMessages.SyntaxColoringPage_2);
        button.setEnabled(false);
        button.setSelection(true);
        Composite composite5 = this.createComposite(composite4, 2);
        ((GridLayout)composite5.getLayout()).marginLeft = 20;
        this.fForegroundLabel = this.createLabel(composite5, SSEUIMessages.Foreground_UI_);
        ((GridData)this.fForegroundLabel.getLayoutData()).verticalAlignment = 0x1000000;
        this.fForegroundLabel.setEnabled(false);
        this.fForegroundColorEditor = new ColorSelector(composite5);
        Button button2 = this.fForegroundColorEditor.getButton();
        GridData gridData4 = new GridData(1, 4, false, false);
        button2.setLayoutData((Object)gridData4);
        this.fForegroundColorEditor.setEnabled(false);
        this.fBackgroundLabel = this.createLabel(composite5, SSEUIMessages.Background_UI_);
        ((GridData)this.fBackgroundLabel.getLayoutData()).verticalAlignment = 0x1000000;
        this.fBackgroundLabel.setEnabled(false);
        this.fBackgroundColorEditor = new ColorSelector(composite5);
        Button button3 = this.fBackgroundColorEditor.getButton();
        gridData4 = new GridData(1, 4, false, false);
        button3.setLayoutData((Object)gridData4);
        this.fBackgroundColorEditor.setEnabled(false);
        this.fBold = this.createCheckbox(composite5, XMLUIMessages.SyntaxColoringPage_3);
        this.fBold.setEnabled(false);
        ((GridData)this.fBold.getLayoutData()).horizontalSpan = 2;
        this.fItalic = this.createCheckbox(composite5, XMLUIMessages.SyntaxColoringPage_4);
        this.fItalic.setEnabled(false);
        ((GridData)this.fItalic.getLayoutData()).horizontalSpan = 2;
        this.fStrike = this.createCheckbox(composite5, XMLUIMessages.SyntaxColoringPage_5);
        this.fStrike.setEnabled(false);
        ((GridData)this.fStrike.getLayoutData()).horizontalSpan = 2;
        this.fUnderline = this.createCheckbox(composite5, XMLUIMessages.SyntaxColoringPage_6);
        this.fUnderline.setEnabled(false);
        ((GridData)this.fUnderline.getLayoutData()).horizontalSpan = 2;
        this.fClearStyle = new Button(composite4, 8);
        this.fClearStyle.setText(SSEUIMessages.Restore_Default_UI_);
        this.fClearStyle.setLayoutData((Object)new GridData(1));
        ((GridData)this.fClearStyle.getLayoutData()).horizontalIndent = 20;
        this.fClearStyle.setEnabled(false);
        Composite composite6 = this.createComposite((Composite)sashForm, 1);
        ((GridLayout)composite6.getLayout()).marginLeft = 5;
        ((GridLayout)composite6.getLayout()).marginTop = 5;
        this.createLabel(composite6, SSEUIMessages.Sample_text__UI_);
        SourceViewer sourceViewer = new SourceViewer(composite6, null, 33557258);
        this.fText = sourceViewer.getTextWidget();
        GridData gridData5 = new GridData(4, 4, true, true);
        gridData5.widthHint = this.convertWidthInCharsToPixels(20);
        gridData5.heightHint = this.convertHeightInCharsToPixels(5);
        gridData5.horizontalSpan = 2;
        this.fText.setLayoutData((Object)gridData5);
        this.fText.setEditable(false);
        this.fText.setFont(JFaceResources.getFont((String)"org.eclipse.wst.sse.ui.textfont"));
        this.fText.addKeyListener(this.getTextKeyListener());
        this.fText.addSelectionListener(this.getTextSelectionListener());
        this.fText.addMouseListener(this.getTextMouseListener());
        this.fText.addTraverseListener(this.getTraverseListener());
        this.setAccessible((Control)this.fText, SSEUIMessages.Sample_text__UI_);
        this.fDocument = StructuredModelManager.getModelManager().createStructuredDocumentFor(ContentTypeIdForPHP.ContentTypeID_PHP);
        this.fDocument.set(this.getExampleText());
        sourceViewer.setDocument((IDocument)this.fDocument);
        sashForm2.setWeights(new int[]{2, 1});
        sashForm.setWeights(new int[]{1, 1});
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite2, "org.eclipse.php.ui.php_syntax_coloring_preference_page");
        this.fStylesViewer.setInput((Object)this.getStylePreferenceKeys());
        this.applyStyles();
        this.fStylesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                if (!selectionChangedEvent.getSelection().isEmpty()) {
                    Object object = ((IStructuredSelection)selectionChangedEvent.getSelection()).getFirstElement();
                    String string = object.toString();
                    PHPSyntaxColoringPage.this.activate(string);
                    if (string == null) {
                        return;
                    }
                }
            }
        });
        this.fForegroundColorEditor.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getProperty().equals("colorValue")) {
                    Object object = ((IStructuredSelection)PHPSyntaxColoringPage.this.fStylesViewer.getSelection()).getFirstElement();
                    String string = object.toString();
                    String string2 = PHPSyntaxColoringPage.this.getOverlayStore().getString(string);
                    String[] stringArray = ColorHelper.unpackStylePreferences((String)string2);
                    if (stringArray != null) {
                        String string3 = stringArray[0];
                        String string4 = ColorHelper.toRGBString((RGB)PHPSyntaxColoringPage.this.fForegroundColorEditor.getColorValue());
                        if (!string4.equals(string3)) {
                            stringArray[0] = string4;
                            String string5 = ColorHelper.packStylePreferences((String[])stringArray);
                            PHPSyntaxColoringPage.this.getOverlayStore().setValue(string, string5);
                            PHPSyntaxColoringPage.this.applyStyles();
                            PHPSyntaxColoringPage.this.fText.redraw();
                        }
                    }
                }
            }
        });
        this.fBackgroundColorEditor.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getProperty().equals("colorValue")) {
                    Object object = ((IStructuredSelection)PHPSyntaxColoringPage.this.fStylesViewer.getSelection()).getFirstElement();
                    String string = object.toString();
                    String string2 = PHPSyntaxColoringPage.this.getOverlayStore().getString(string);
                    String[] stringArray = ColorHelper.unpackStylePreferences((String)string2);
                    if (stringArray != null) {
                        String string3 = stringArray[1];
                        String string4 = ColorHelper.toRGBString((RGB)PHPSyntaxColoringPage.this.fBackgroundColorEditor.getColorValue());
                        if (!string4.equals(string3)) {
                            stringArray[1] = string4;
                            String string5 = ColorHelper.packStylePreferences((String[])stringArray);
                            PHPSyntaxColoringPage.this.getOverlayStore().setValue(string, string5);
                            PHPSyntaxColoringPage.this.applyStyles();
                            PHPSyntaxColoringPage.this.fText.redraw();
                            PHPSyntaxColoringPage.this.activate(string);
                        }
                    }
                }
            }
        });
        this.fBold.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                super.widgetSelected(selectionEvent);
                Object object = ((IStructuredSelection)PHPSyntaxColoringPage.this.fStylesViewer.getSelection()).getFirstElement();
                String string = object.toString();
                String string2 = PHPSyntaxColoringPage.this.getOverlayStore().getString(string);
                String[] stringArray = ColorHelper.unpackStylePreferences((String)string2);
                if (stringArray != null) {
                    String string3 = stringArray[2];
                    String string4 = String.valueOf(PHPSyntaxColoringPage.this.fBold.getSelection());
                    if (!string4.equals(string3)) {
                        stringArray[2] = string4;
                        String string5 = ColorHelper.packStylePreferences((String[])stringArray);
                        PHPSyntaxColoringPage.this.getOverlayStore().setValue(string, string5);
                        PHPSyntaxColoringPage.this.applyStyles();
                        PHPSyntaxColoringPage.this.fText.redraw();
                    }
                }
            }
        });
        this.fItalic.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                super.widgetSelected(selectionEvent);
                Object object = ((IStructuredSelection)PHPSyntaxColoringPage.this.fStylesViewer.getSelection()).getFirstElement();
                String string = object.toString();
                String string2 = PHPSyntaxColoringPage.this.getOverlayStore().getString(string);
                String[] stringArray = ColorHelper.unpackStylePreferences((String)string2);
                if (stringArray != null) {
                    String string3 = stringArray[3];
                    String string4 = String.valueOf(PHPSyntaxColoringPage.this.fItalic.getSelection());
                    if (!string4.equals(string3)) {
                        stringArray[3] = string4;
                        String string5 = ColorHelper.packStylePreferences((String[])stringArray);
                        PHPSyntaxColoringPage.this.getOverlayStore().setValue(string, string5);
                        PHPSyntaxColoringPage.this.applyStyles();
                        PHPSyntaxColoringPage.this.fText.redraw();
                    }
                }
            }
        });
        this.fStrike.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                super.widgetSelected(selectionEvent);
                Object object = ((IStructuredSelection)PHPSyntaxColoringPage.this.fStylesViewer.getSelection()).getFirstElement();
                String string = object.toString();
                String string2 = PHPSyntaxColoringPage.this.getOverlayStore().getString(string);
                String[] stringArray = ColorHelper.unpackStylePreferences((String)string2);
                if (stringArray != null) {
                    String string3 = stringArray[4];
                    String string4 = String.valueOf(PHPSyntaxColoringPage.this.fStrike.getSelection());
                    if (!string4.equals(string3)) {
                        stringArray[4] = string4;
                        String string5 = ColorHelper.packStylePreferences((String[])stringArray);
                        PHPSyntaxColoringPage.this.getOverlayStore().setValue(string, string5);
                        PHPSyntaxColoringPage.this.applyStyles();
                        PHPSyntaxColoringPage.this.fText.redraw();
                    }
                }
            }
        });
        this.fUnderline.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                super.widgetSelected(selectionEvent);
                Object object = ((IStructuredSelection)PHPSyntaxColoringPage.this.fStylesViewer.getSelection()).getFirstElement();
                String string = object.toString();
                String string2 = PHPSyntaxColoringPage.this.getOverlayStore().getString(string);
                String[] stringArray = ColorHelper.unpackStylePreferences((String)string2);
                if (stringArray != null) {
                    String string3 = stringArray[5];
                    String string4 = String.valueOf(PHPSyntaxColoringPage.this.fUnderline.getSelection());
                    if (!string4.equals(string3)) {
                        stringArray[5] = string4;
                        String string5 = ColorHelper.packStylePreferences((String[])stringArray);
                        PHPSyntaxColoringPage.this.getOverlayStore().setValue(string, string5);
                        PHPSyntaxColoringPage.this.applyStyles();
                        PHPSyntaxColoringPage.this.fText.redraw();
                    }
                }
            }
        });
        this.fClearStyle.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (PHPSyntaxColoringPage.this.fStylesViewer.getSelection().isEmpty()) {
                    return;
                }
                String string = ((IStructuredSelection)PHPSyntaxColoringPage.this.fStylesViewer.getSelection()).getFirstElement().toString();
                PHPSyntaxColoringPage.this.getOverlayStore().setToDefault(string);
                PHPSyntaxColoringPage.this.applyStyles();
                PHPSyntaxColoringPage.this.fText.redraw();
                PHPSyntaxColoringPage.this.activate(string);
            }
        });
        return composite2;
    }

    private Label createLabel(Composite composite, String string) {
        Label label = new Label(composite, 64);
        label.setText(string);
        GridData gridData = new GridData(4, 4, false, false);
        label.setLayoutData((Object)gridData);
        label.setBackground(composite.getBackground());
        return label;
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> arrayList = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        Iterator iterator = this.getStylePreferenceKeys().iterator();
        while (iterator.hasNext()) {
            arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, (String)iterator.next()));
        }
        OverlayPreferenceStore.OverlayKey[] overlayKeyArray = new OverlayPreferenceStore.OverlayKey[arrayList.size()];
        arrayList.toArray(overlayKeyArray);
        return overlayKeyArray;
    }

    private StructuredViewer createStylesViewer(Composite composite) {
        ListViewer listViewer = new ListViewer(composite, 2820);
        listViewer.setComparator(new ViewerComparator((Comparator)Collator.getInstance()));
        listViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object object) {
                Object v = PHPSyntaxColoringPage.this.fStyleToDescriptionMap.get(object);
                if (v != null) {
                    return v.toString();
                }
                return super.getText(object);
            }
        });
        listViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void dispose() {
            }

            public Object[] getChildren(Object object) {
                return PHPSyntaxColoringPage.this.getStylePreferenceKeys().toArray();
            }

            public Object[] getElements(Object object) {
                return this.getChildren(object);
            }

            public Object getParent(Object object) {
                return PHPSyntaxColoringPage.this.getStylePreferenceKeys();
            }

            public boolean hasChildren(Object object) {
                return false;
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }
        });
        return listViewer;
    }

    public void dispose() {
        if (this.fOverlayStore != null) {
            this.fOverlayStore.stop();
        }
        super.dispose();
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return PreferenceConstants.getPreferenceStore();
    }

    private TextAttribute getAttributeFor(String string) {
        String string2;
        String[] stringArray;
        TextAttribute textAttribute = new TextAttribute(this.fDefaultForeground, this.fDefaultBackground, 0);
        if (string != null && this.fOverlayStore != null && (stringArray = ColorHelper.unpackStylePreferences((String)(string2 = this.getOverlayStore().getString(string)))) != null) {
            boolean bl;
            RGB rGB = ColorHelper.toRGB((String)stringArray[0]);
            RGB rGB2 = ColorHelper.toRGB((String)stringArray[1]);
            int n = 0;
            if (stringArray.length > 2 && (bl = Boolean.valueOf(stringArray[2]).booleanValue())) {
                n |= 1;
            }
            if (stringArray.length > 3 && (bl = Boolean.valueOf(stringArray[3]).booleanValue())) {
                n |= 2;
            }
            if (stringArray.length > 4 && (bl = Boolean.valueOf(stringArray[4]).booleanValue())) {
                n |= 0x20000000;
            }
            if (stringArray.length > 5 && (bl = Boolean.valueOf(stringArray[5]).booleanValue())) {
                n |= 0x40000000;
            }
            textAttribute = new TextAttribute(rGB != null ? EditorUtility.getColor((RGB)rGB) : null, rGB2 != null ? EditorUtility.getColor((RGB)rGB2) : null, n);
        }
        return textAttribute;
    }

    private String getExampleText() {
        return PHPUIMessages.ColorPage_CodeExample_0;
    }

    private String getNamedStyleAtOffset(int n) {
        if (n >= this.fDocument.getLength()) {
            return this.getNamedStyleAtOffset(this.fDocument.getLength() - 1);
        }
        if (n < 0) {
            return this.getNamedStyleAtOffset(0);
        }
        IStructuredDocumentRegion iStructuredDocumentRegion = this.fDocument.getFirstStructuredDocumentRegion();
        while (iStructuredDocumentRegion != null && !iStructuredDocumentRegion.containsOffset(n)) {
            iStructuredDocumentRegion = iStructuredDocumentRegion.getNext();
        }
        if (iStructuredDocumentRegion != null) {
            String string;
            Object object;
            ITextRegion iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(n);
            IStructuredDocumentRegion iStructuredDocumentRegion2 = iStructuredDocumentRegion;
            if (iTextRegion instanceof ITextRegionContainer) {
                iStructuredDocumentRegion2 = (ITextRegionContainer)iTextRegion;
                iTextRegion = iStructuredDocumentRegion2.getRegionAtCharacterOffset(n);
            }
            if (iTextRegion.getType() == "PHP_CONTENT") {
                object = (PhpScriptRegion)iTextRegion;
                try {
                    string = object.getPhpTokenType(n - iStructuredDocumentRegion2.getStartOffset() - object.getStart());
                }
                catch (BadLocationException badLocationException) {
                    assert (false);
                    return null;
                }
            } else {
                string = iTextRegion.getType() == "PHP_OPEN" ? "PHP_OPENTAG" : (iTextRegion.getType() == "PHP_CLOSE" ? "PHP_CLOSETAG" : iTextRegion.getType());
            }
            object = (String)this.fContextToStyleMap.get(string);
            return object;
        }
        return null;
    }

    private OverlayPreferenceStore getOverlayStore() {
        return this.fOverlayStore;
    }

    private Collection getStylePreferenceKeys() {
        if (this.fStylePreferenceKeys == null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("codeStyleNormal");
            arrayList.add("editorColorBoundarymaker");
            arrayList.add("editorColorKeyword");
            arrayList.add("editorColorVariable");
            arrayList.add("editorColorString");
            arrayList.add("editorColorNumber");
            arrayList.add("editorColorHeredoc");
            arrayList.add("editorColorComment");
            arrayList.add("editorColorPhpdoc");
            arrayList.add("editorColorTask");
            this.fStylePreferenceKeys = arrayList;
        }
        return this.fStylePreferenceKeys;
    }

    private KeyListener getTextKeyListener() {
        return new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.widget instanceof StyledText) {
                    int n = ((StyledText)keyEvent.widget).getCaretOffset();
                    PHPSyntaxColoringPage.this.selectColorAtOffset(n);
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.widget instanceof StyledText) {
                    int n = ((StyledText)keyEvent.widget).getCaretOffset();
                    PHPSyntaxColoringPage.this.selectColorAtOffset(n);
                }
            }
        };
    }

    private MouseListener getTextMouseListener() {
        return new MouseListener(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
            }

            public void mouseDown(MouseEvent mouseEvent) {
            }

            public void mouseUp(MouseEvent mouseEvent) {
                if (mouseEvent.widget instanceof StyledText) {
                    int n = ((StyledText)mouseEvent.widget).getCaretOffset();
                    PHPSyntaxColoringPage.this.selectColorAtOffset(n);
                }
            }
        };
    }

    private SelectionListener getTextSelectionListener() {
        return new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                PHPSyntaxColoringPage.this.selectColorAtOffset(selectionEvent.x);
                if (selectionEvent.widget instanceof StyledText) {
                    ((StyledText)selectionEvent.widget).setSelection(selectionEvent.x);
                }
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                PHPSyntaxColoringPage.this.selectColorAtOffset(selectionEvent.x);
                if (selectionEvent.widget instanceof StyledText) {
                    ((StyledText)selectionEvent.widget).setSelection(selectionEvent.x);
                }
            }
        };
    }

    private TraverseListener getTraverseListener() {
        return new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                if (traverseEvent.widget instanceof StyledText && (traverseEvent.detail == 16 || traverseEvent.detail == 8)) {
                    traverseEvent.doit = true;
                }
            }
        };
    }

    public void init(IWorkbench iWorkbench) {
        this.setDescription(SSEUIMessages.SyntaxColoring_Description);
        this.fStyleToDescriptionMap = new HashMap();
        this.fContextToStyleMap = new HashMap();
        this.initStyleToDescriptionMap();
        this.initRegionContextToStyleMap();
        this.fOverlayStore = new OverlayPreferenceStore(this.getPreferenceStore(), this.createOverlayStoreKeys());
        this.fOverlayStore.load();
        this.fOverlayStore.start();
        this.fStyleProvider.setColorPreferences((IPreferenceStore)this.fOverlayStore);
    }

    private void initRegionContextToStyleMap() {
        this.fContextToStyleMap = this.fStyleProvider.getColorTypesMap();
    }

    private void initStyleToDescriptionMap() {
        this.fStyleToDescriptionMap.put("codeStyleNormal", PHPUIMessages.ColorPage_Normal);
        this.fStyleToDescriptionMap.put("editorColorBoundarymaker", PHPUIMessages.ColorPage_BoundryMaker);
        this.fStyleToDescriptionMap.put("editorColorKeyword", PHPUIMessages.ColorPage_Keyword);
        this.fStyleToDescriptionMap.put("editorColorVariable", PHPUIMessages.ColorPage_Variable);
        this.fStyleToDescriptionMap.put("editorColorString", PHPUIMessages.ColorPage_String);
        this.fStyleToDescriptionMap.put("editorColorNumber", PHPUIMessages.ColorPage_Number);
        this.fStyleToDescriptionMap.put("editorColorHeredoc", PHPUIMessages.ColorPage_Heredoc);
        this.fStyleToDescriptionMap.put("editorColorComment", PHPUIMessages.ColorPage_Comment);
        this.fStyleToDescriptionMap.put("editorColorPhpdoc", PHPUIMessages.ColorPage_Phpdoc);
        this.fStyleToDescriptionMap.put("editorColorTask", PHPUIMessages.ColorPage_TaskTag);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.getOverlayStore().loadDefaults();
        this.applyStyles();
        this.fStylesViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        this.activate(null);
        this.fText.redraw();
    }

    public boolean performOk() {
        this.getOverlayStore().propagate();
        PHPUiPlugin.getDefault().savePluginPreferences();
        return true;
    }

    private void selectColorAtOffset(int n) {
        String string = this.getNamedStyleAtOffset(n);
        if (string != null) {
            this.fStylesViewer.setSelection((ISelection)new StructuredSelection((Object)string));
            this.fStylesViewer.reveal((Object)string);
        } else {
            this.fStylesViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        }
        this.activate(string);
    }

    private void setAccessible(Control control, String string) {
        if (control == null) {
            return;
        }
        final String string2 = string;
        control.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent accessibleEvent) {
                if (accessibleEvent.childID == -1) {
                    accessibleEvent.result = string2;
                }
            }
        });
    }
}

