/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.model.elements;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.model.elements.ElementMementoProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.ui.IMemento;

public class VariablesViewElementMementoProvider
extends ElementMementoProvider {
    private static final String ELEMENT_NAME = "ELEMENT_NAME";

    protected boolean encodeElement(Object element, IMemento memento, IPresentationContext context) throws CoreException {
        if (element instanceof IStackFrame) {
            IStackFrame frame = (IStackFrame)element;
            if ("org.eclipse.debug.ui.RegisterView".equals(context.getId())) {
                memento.putString(ELEMENT_NAME, frame.getModelIdentifier());
            } else {
                memento.putString(ELEMENT_NAME, frame.getName());
            }
        } else if (element instanceof IVariable) {
            memento.putString(ELEMENT_NAME, ((IVariable)element).getName());
        } else if (element instanceof IRegisterGroup) {
            memento.putString(ELEMENT_NAME, ((IRegisterGroup)element).getName());
        } else {
            return false;
        }
        return true;
    }

    protected boolean isEqual(Object element, IMemento memento, IPresentationContext context) throws CoreException {
        String mementoName = memento.getString(ELEMENT_NAME);
        if (mementoName != null) {
            String elementName = null;
            if (element instanceof IStackFrame) {
                IStackFrame frame = (IStackFrame)element;
                elementName = "org.eclipse.debug.ui.RegisterView".equals(context.getId()) ? frame.getModelIdentifier() : frame.getName();
            } else if (element instanceof IVariable) {
                elementName = ((IVariable)element).getName();
            } else if (element instanceof IRegisterGroup) {
                elementName = ((IRegisterGroup)element).getName();
            }
            if (elementName != null) {
                return elementName.equals(mementoName);
            }
        }
        return false;
    }
}

