/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import org.eclipse.php.internal.core.ast.nodes.Block;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.nodes.Variable;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class CatchClause
extends Statement {
    private final Identifier className;
    private final Variable variable;
    private final Block statement;

    public CatchClause(int n, int n2, Identifier identifier, Variable variable, Block block) {
        super(n, n2);
        assert (identifier != null && variable != null && block != null);
        this.className = identifier;
        this.variable = variable;
        this.statement = block;
        identifier.setParent(this);
        variable.setParent(this);
        block.setParent(this);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        this.className.accept(visitor);
        this.variable.accept(visitor);
        this.statement.accept(visitor);
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.className.traverseTopDown(visitor);
        this.variable.traverseTopDown(visitor);
        this.statement.traverseTopDown(visitor);
    }

    public void traverseBottomUp(Visitor visitor) {
        this.className.traverseBottomUp(visitor);
        this.variable.traverseBottomUp(visitor);
        this.statement.traverseBottomUp(visitor);
        this.accept(visitor);
    }

    public void toString(StringBuffer stringBuffer, String string) {
        stringBuffer.append(string).append("<CatchClause");
        this.appendInterval(stringBuffer);
        stringBuffer.append(">\n");
        stringBuffer.append("\t").append(string).append("<ClassName>\n");
        this.className.toString(stringBuffer, "\t\t" + string);
        stringBuffer.append("\n");
        stringBuffer.append("\t").append(string).append("</ClassName>\n");
        this.variable.toString(stringBuffer, "\t" + string);
        stringBuffer.append("\n");
        this.statement.toString(stringBuffer, "\t" + string);
        stringBuffer.append("\n");
        stringBuffer.append(string).append("</CatchClause>");
    }

    public int getType() {
        return 9;
    }

    public Identifier getClassName() {
        return this.className;
    }

    public Block getStatement() {
        return this.statement;
    }

    public Variable getVariable() {
        return this.variable;
    }
}

