/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class DoStatement
extends Statement {
    private final Expression condition;
    private final Statement action;

    public DoStatement(int n, int n2, Expression expression, Statement statement) {
        super(n, n2);
        assert (expression != null && statement != null);
        this.condition = expression;
        this.action = statement;
        expression.setParent(this);
        statement.setParent(this);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        this.condition.accept(visitor);
        this.action.accept(visitor);
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.condition.traverseTopDown(visitor);
        this.action.traverseTopDown(visitor);
    }

    public void traverseBottomUp(Visitor visitor) {
        this.condition.traverseBottomUp(visitor);
        this.action.traverseBottomUp(visitor);
        this.accept(visitor);
    }

    public void toString(StringBuffer stringBuffer, String string) {
        stringBuffer.append(string).append("<DoStatement");
        this.appendInterval(stringBuffer);
        stringBuffer.append(">\n");
        this.action.toString(stringBuffer, "\t" + string);
        stringBuffer.append("\n");
        stringBuffer.append("\t").append(string).append("<Condition>\n");
        this.condition.toString(stringBuffer, "\t\t" + string);
        stringBuffer.append("\n");
        stringBuffer.append("\t").append(string).append("</Condition>\n");
        stringBuffer.append(string).append("</DoStatement>");
    }

    public int getType() {
        return 20;
    }

    public Statement getAction() {
        return this.action;
    }

    public Expression getCondition() {
        return this.condition;
    }
}

