/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.documentModel;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.php.internal.core.documentModel.dom.DOMDocumentForPHP;
import org.eclipse.php.internal.core.documentModel.dom.PHPDOMModelParser;
import org.eclipse.php.internal.core.documentModel.dom.PHPDOMModelUpdater;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.resources.ExternalFilesRegistry;
import org.eclipse.wst.html.core.internal.document.DOMStyleModelImpl;
import org.eclipse.wst.xml.core.internal.document.DOMModelImpl;
import org.eclipse.wst.xml.core.internal.document.XMLModelParser;
import org.eclipse.wst.xml.core.internal.document.XMLModelUpdater;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;

public class DOMModelForPHP
extends DOMStyleModelImpl {
    public static final boolean FREQUENT_MODEL_UPDATE = true;
    PHPProjectModel projectModel;

    protected Document internalCreateDocument() {
        DOMDocumentForPHP dOMDocumentForPHP = new DOMDocumentForPHP();
        dOMDocumentForPHP.setModel((IDOMModel)this);
        return dOMDocumentForPHP;
    }

    protected XMLModelParser createModelParser() {
        return new PHPDOMModelParser((DOMModelImpl)this);
    }

    protected XMLModelUpdater createModelUpdater() {
        return new PHPDOMModelUpdater((DOMModelImpl)this);
    }

    public PHPFileData getFileData() {
        return this.getFileData(false);
    }

    public PHPFileData getFileData(boolean bl) {
        PHPFileData pHPFileData = null;
        IFile iFile = this.getIFile();
        if (iFile != null && this.projectModel != null) {
            pHPFileData = this.projectModel.getFileData(iFile.getFullPath().toString());
        }
        if (pHPFileData == null && (pHPFileData = PHPWorkspaceModelManager.getInstance().getModelForFile(this.getBaseLocation(), bl)) != null) {
            return pHPFileData;
        }
        if (ExternalFilesRegistry.getInstance().isEntryExist(iFile.getFullPath().toString())) {
            pHPFileData = PHPWorkspaceModelManager.getInstance().getModelForFile(this.getBaseLocation());
            return pHPFileData;
        }
        return pHPFileData;
    }

    public PHPProjectModel getProjectModel() {
        if (this.projectModel != null) {
            return this.projectModel;
        }
        IFile iFile = this.getIFile();
        if (ExternalFilesRegistry.getInstance().isEntryExist(iFile.getFullPath().toString())) {
            return PHPWorkspaceModelManager.getDefaultPHPProjectModel();
        }
        PHPFileData pHPFileData = this.getFileData();
        this.projectModel = pHPFileData != null ? PHPModelUtil.getProjectModelForFile(pHPFileData) : null;
        return this.projectModel;
    }

    public void updateFileData() {
        IFile iFile = this.getIFile();
        if (iFile != null) {
            PHPProjectModel pHPProjectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(iFile.getProject());
            if (pHPProjectModel != null && iFile.exists()) {
                pHPProjectModel.fileWasChanged(iFile, this.getStructuredDocument());
            } else if (ExternalFilesRegistry.getInstance().isEntryExist(iFile.getFullPath().toString())) {
                pHPProjectModel = PHPWorkspaceModelManager.getDefaultPHPProjectModel();
                pHPProjectModel.fileWasChanged(iFile, this.getStructuredDocument());
            }
        }
    }

    public void changedModel() {
        this.updateFileData();
        super.changedModel();
    }

    public IFile getIFile() {
        IWorkspaceRoot iWorkspaceRoot;
        IFile iFile;
        String string = this.getId();
        if ("org.eclipse.wst.sse.core.IModelManager.UNMANAGED_MODEL".equals(string)) {
            return null;
        }
        String string2 = this.getBaseLocation();
        if (string2 == null || string2.length() == 0) {
            if (string == null) {
                return null;
            }
            string2 = string.toString();
        }
        if ((iFile = (IFile)(iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot()).findMember((IPath)new Path(string2))) != null) {
            return iFile;
        }
        if (ExternalFilesRegistry.getInstance().isEntryExist(string2)) {
            iFile = ExternalFilesRegistry.getInstance().getFileEntry(string2);
        }
        if (iFile == null) {
            if (Platform.getOS() != "win32") {
                string2 = string2.replace('\\', '/');
            }
            iFile = ResourcesPlugin.getWorkspace().getRoot().getFile(Path.fromOSString((String)string2));
        }
        return iFile;
    }
}

