/*
 * Decompiled with CFR 0.152.
 */
package org.ini4j;

import java.io.File;
import java.io.FileWriter;
import java.util.prefs.BackingStoreException;
import org.ini4j.Ini;
import org.ini4j.IniPreferences;

public class IniFile
extends IniPreferences {
    private static final int MODE_RO = 1;
    private static final int MODE_WO = 2;
    private File _file;
    private int _mode;

    public IniFile(File file) throws BackingStoreException {
        this(file, 1);
    }

    public IniFile(File file, int n) throws BackingStoreException {
        super(new Ini());
        this._file = file;
        this._mode = n;
        if (this._mode == 1 || this._mode != 2 && this._file.exists()) {
            this.sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws BackingStoreException {
        if (this._mode == 1) {
            throw new BackingStoreException("read only instance");
        }
        try {
            Object object = this.lock;
            synchronized (object) {
                this.getIni().store(new FileWriter(this._file), this._mode);
            }
        }
        catch (Exception exception) {
            throw new BackingStoreException(exception);
        }
    }

    public File getFile() {
        return this._file;
    }

    public int getMode() {
        return this._mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() throws BackingStoreException {
        if (this._mode == 2) {
            throw new BackingStoreException("write only instance");
        }
        try {
            Object object = this.lock;
            synchronized (object) {
                this.getIni().load(this._file.toURL(), this._mode);
            }
        }
        catch (Exception exception) {
            throw new BackingStoreException(exception);
        }
    }
}

