/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentAdapter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.FormattingContext;
import org.eclipse.jface.text.formatter.IContentFormatterExtension;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.php.internal.core.documentModel.parser.regions.PhpScriptRegion;
import org.eclipse.php.internal.ui.editor.PHPStructuredTextAnnotationHover;
import org.eclipse.php.internal.ui.editor.configuration.PHPStructuredTextViewerConfiguration;
import org.eclipse.php.ui.editor.contentassist.IContentAssistProcessorForPHP;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionChangedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionsReplacedEvent;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.internal.text.TextRegionListImpl;
import org.eclipse.wst.sse.core.internal.undo.IStructuredTextUndoManager;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.StructuredDocumentToTextAdapter;
import org.eclipse.wst.sse.ui.internal.StructuredTextAnnotationHover;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;

public class PHPStructuredTextViewer
extends StructuredTextViewer {
    private static final String FORMAT_DOCUMENT_TEXT = SSEUIMessages.Format_Document_UI_;
    private SourceViewerConfiguration config;

    public PHPStructuredTextViewer(Composite composite, IVerticalRuler iVerticalRuler, IOverviewRuler iOverviewRuler, boolean bl, int n) {
        super(composite, iVerticalRuler, iOverviewRuler, bl, n);
    }

    public void doOperation(int n) {
        Point point = this.getTextWidget().getSelection();
        int n2 = point.x;
        int n3 = point.y - point.x;
        int n4 = this.getTextWidget().getTopIndex();
        if (n == 23) {
            try {
                this.setRedraw(false);
                this.beginRecording(FORMAT_DOCUMENT_TEXT, FORMAT_DOCUMENT_TEXT, n2, n3);
                Region region = new Region(0, this.getDocument().getLength());
                if (this.fContentFormatter instanceof IContentFormatterExtension) {
                    IContentFormatterExtension iContentFormatterExtension = (IContentFormatterExtension)this.fContentFormatter;
                    FormattingContext formattingContext = new FormattingContext();
                    formattingContext.setProperty((Object)"formatting.context.document", (Object)Boolean.TRUE);
                    formattingContext.setProperty((Object)"formatting.context.region", (Object)region);
                    iContentFormatterExtension.format(this.getDocument(), (IFormattingContext)formattingContext);
                }
                this.fContentFormatter.format(this.getDocument(), (IRegion)region);
            }
            finally {
                point = this.getTextWidget().getSelection();
                n3 = point.y - point.x;
                this.endRecording(n2, n3);
                this.getTextWidget().setSelection(n2);
                this.getTextWidget().setTopIndex(n4);
                this.setRedraw(true);
            }
        } else if (n == 5) {
            super.doOperation(n);
        } else if (n == 13) {
            if (this.config != null) {
                PHPStructuredTextViewerConfiguration pHPStructuredTextViewerConfiguration = (PHPStructuredTextViewerConfiguration)this.config;
                IContentAssistProcessor[] iContentAssistProcessorArray = pHPStructuredTextViewerConfiguration.getContentAssistProcessors((ISourceViewer)this, "org.eclipse.php.PHP_DEFAULT");
                int n5 = 0;
                while (n5 < iContentAssistProcessorArray.length) {
                    if (iContentAssistProcessorArray[n5] instanceof IContentAssistProcessorForPHP) {
                        ((IContentAssistProcessorForPHP)iContentAssistProcessorArray[n5]).explicitActivationRequest();
                    }
                    ++n5;
                }
            }
            super.doOperation(n);
        } else {
            super.doOperation(n);
        }
    }

    private void beginRecording(String string, String string2, int n, int n2) {
        IDocument iDocument = this.getDocument();
        if (iDocument instanceof IStructuredDocument) {
            IStructuredDocument iStructuredDocument = (IStructuredDocument)iDocument;
            IStructuredTextUndoManager iStructuredTextUndoManager = iStructuredDocument.getUndoManager();
            iStructuredTextUndoManager.beginRecording((Object)this, string, string2, n, n2);
        }
    }

    private void endRecording(int n, int n2) {
        IDocument iDocument = this.getDocument();
        if (iDocument instanceof IStructuredDocument) {
            IStructuredDocument iStructuredDocument = (IStructuredDocument)iDocument;
            IStructuredTextUndoManager iStructuredTextUndoManager = iStructuredDocument.getUndoManager();
            iStructuredTextUndoManager.endRecording((Object)this, n, n2);
        }
    }

    protected IDocumentAdapter createDocumentAdapter() {
        return new StructuredDocumentToTextAdapterForPhp(this.getTextWidget());
    }

    public void configure(SourceViewerConfiguration sourceViewerConfiguration) {
        super.configure(sourceViewerConfiguration);
        if (this.fAnnotationHover instanceof StructuredTextAnnotationHover) {
            ((StructuredTextAnnotationHover)this.fAnnotationHover).release();
        }
        this.setAnnotationHover((IAnnotationHover)new PHPStructuredTextAnnotationHover());
        this.ensureAnnotationHoverManagerInstalled();
        if (!(sourceViewerConfiguration instanceof PHPStructuredTextViewerConfiguration)) {
            return;
        }
        this.config = sourceViewerConfiguration;
        PHPStructuredTextViewerConfiguration pHPStructuredTextViewerConfiguration = (PHPStructuredTextViewerConfiguration)sourceViewerConfiguration;
        IContentAssistant iContentAssistant = pHPStructuredTextViewerConfiguration.getPHPContentAssistant((ISourceViewer)this, true);
        if (this.fContentAssistant != null) {
            this.fContentAssistant.uninstall();
        }
        this.fContentAssistant = iContentAssistant;
        if (this.fContentAssistant != null) {
            this.fContentAssistant.install((ITextViewer)this);
            this.fContentAssistantInstalled = true;
        } else {
            this.enableOperation(13, false);
        }
    }

    protected void ensureAnnotationHoverManagerInstalled() {
        if (this.fAnnotationHover instanceof PHPStructuredTextAnnotationHover) {
            super.ensureAnnotationHoverManagerInstalled();
        }
    }

    public int modelLine2WidgetLine(int n) {
        try {
            return super.modelLine2WidgetLine(n);
        }
        catch (IllegalStateException illegalStateException) {
            return -1;
        }
    }

    public class StructuredDocumentToTextAdapterForPhp
    extends StructuredDocumentToTextAdapter {
        public StructuredDocumentToTextAdapterForPhp() {
        }

        public StructuredDocumentToTextAdapterForPhp(StyledText styledText) {
            super(styledText);
        }

        protected void redrawRegionChanged(RegionChangedEvent regionChangedEvent) {
            if (regionChangedEvent != null && regionChangedEvent.getRegion() != null && regionChangedEvent.getRegion().getType() == "PHP_CONTENT") {
                PhpScriptRegion phpScriptRegion = (PhpScriptRegion)regionChangedEvent.getRegion();
                if (phpScriptRegion.isFullReparsed) {
                    TextRegionListImpl textRegionListImpl = new TextRegionListImpl();
                    textRegionListImpl.add((ITextRegion)phpScriptRegion);
                    IStructuredDocumentRegion iStructuredDocumentRegion = regionChangedEvent.getStructuredDocumentRegion();
                    IStructuredDocument iStructuredDocument = regionChangedEvent.getStructuredDocument();
                    RegionsReplacedEvent regionsReplacedEvent = new RegionsReplacedEvent(iStructuredDocument, (Object)iStructuredDocumentRegion, iStructuredDocumentRegion, null, (ITextRegionList)textRegionListImpl, null, 0, 0);
                    this.redrawRegionsReplaced(regionsReplacedEvent);
                } else {
                    phpScriptRegion.isFullReparsed = true;
                }
            }
            super.redrawRegionChanged(regionChangedEvent);
        }
    }
}

