/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.projection;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.projection.ProjectionAnnotationModelChanges;

class ProjectionViewerInformation {
    private ProjectionAnnotationModel fProjectionAnnotationModel;
    private IDocument fDocument;
    private IDocumentListener fDocumentListener;
    private boolean fIsDocumentChanging = false;
    private List fQueuedAnnotationChanges;

    public ProjectionViewerInformation(ProjectionViewer projectionViewer) {
        this.fDocument = projectionViewer.getDocument();
        this.fProjectionAnnotationModel = projectionViewer.getProjectionAnnotationModel();
    }

    IDocument getDocument() {
        return this.fDocument;
    }

    private List getQueuedAnnotationChanges() {
        if (this.fQueuedAnnotationChanges == null) {
            this.fQueuedAnnotationChanges = new ArrayList();
        }
        return this.fQueuedAnnotationChanges;
    }

    void setIsDocumentChanging(boolean bl) {
        this.fIsDocumentChanging = bl;
    }

    private boolean isDocumentChanging() {
        return this.fIsDocumentChanging;
    }

    void applyAnnotationModelChanges() {
        List list = this.getQueuedAnnotationChanges();
        while (!list.isEmpty()) {
            ProjectionAnnotationModelChanges projectionAnnotationModelChanges = (ProjectionAnnotationModelChanges)list.remove(0);
            try {
                this.fProjectionAnnotationModel.modifyAnnotations(projectionAnnotationModelChanges.getDeletions(), projectionAnnotationModelChanges.getAdditions(), projectionAnnotationModelChanges.getModifications());
            }
            catch (Exception exception) {
                Logger.log(202, exception.getMessage(), exception);
            }
        }
    }

    boolean hasChangesQueued() {
        return !this.getQueuedAnnotationChanges().isEmpty();
    }

    public void queueAnnotationModelChanges(ProjectionAnnotationModelChanges projectionAnnotationModelChanges) {
        this.getQueuedAnnotationChanges().add(projectionAnnotationModelChanges);
        if (!this.isDocumentChanging()) {
            this.applyAnnotationModelChanges();
        }
    }

    public void initialize() {
        if (this.fDocumentListener == null) {
            this.fDocumentListener = new DocumentListener(this);
        }
        this.getDocument().addDocumentListener(this.fDocumentListener);
    }

    public void dispose() {
        if (this.fDocumentListener != null) {
            this.getDocument().removeDocumentListener(this.fDocumentListener);
        }
        if (this.fQueuedAnnotationChanges != null) {
            this.fQueuedAnnotationChanges.clear();
            this.fQueuedAnnotationChanges = null;
        }
    }

    private class DocumentListener
    implements IDocumentListener {
        private ProjectionViewerInformation fInfo;

        public DocumentListener(ProjectionViewerInformation projectionViewerInformation2) {
            this.fInfo = projectionViewerInformation2;
        }

        public void documentAboutToBeChanged(DocumentEvent documentEvent) {
            IDocument iDocument = documentEvent.getDocument();
            if (this.fInfo.getDocument() == iDocument) {
                this.fInfo.setIsDocumentChanging(true);
            }
        }

        public void documentChanged(DocumentEvent documentEvent) {
            IDocument iDocument = documentEvent.getDocument();
            if (iDocument instanceof IDocumentExtension && this.fInfo.getDocument() == iDocument && this.fInfo.hasChangesQueued()) {
                ((IDocumentExtension)iDocument).registerPostNotificationReplace((IDocumentListener)this, (IDocumentExtension.IReplace)new PostDocumentChangedListener(this.fInfo));
            }
        }
    }

    private class PostDocumentChangedListener
    implements IDocumentExtension.IReplace {
        private ProjectionViewerInformation fInfo;

        public PostDocumentChangedListener(ProjectionViewerInformation projectionViewerInformation2) {
            this.fInfo = projectionViewerInformation2;
        }

        public void perform(IDocument iDocument, IDocumentListener iDocumentListener) {
            this.fInfo.applyAnnotationModelChanges();
            this.fInfo.setIsDocumentChanging(false);
        }
    }
}

