/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.actions.ActionUtils;
import org.eclipse.php.internal.ui.actions.CopyToClipboardAction;
import org.eclipse.php.internal.ui.actions.SelectionDispatchAction;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class CutAction
extends SelectionDispatchAction {
    private CopyToClipboardAction fCopyToClipboardAction;

    public CutAction(IWorkbenchSite iWorkbenchSite, Clipboard clipboard, SelectionDispatchAction selectionDispatchAction) {
        super(iWorkbenchSite);
        this.setText(PHPUIMessages.CutAction_text);
        this.fCopyToClipboardAction = new CopyToClipboardAction(iWorkbenchSite, clipboard, selectionDispatchAction);
        ISharedImages iSharedImages = PHPUiPlugin.getDefault().getWorkbench().getSharedImages();
        this.setDisabledImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_CUT_DISABLED"));
        this.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_CUT"));
        this.setHoverImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_CUT"));
        this.update(this.getSelection());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.php.ui.cut_action");
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        if (!iStructuredSelection.isEmpty()) {
            if (!CutAction.containsOnlyElementsInsidePHPFiles(iStructuredSelection)) {
                this.setEnabled(false);
                return;
            }
            this.fCopyToClipboardAction.selectionChanged(iStructuredSelection);
            this.setEnabled(this.fCopyToClipboardAction.isEnabled() && ActionUtils.isDeleteAvailable(iStructuredSelection));
        } else {
            this.setEnabled(false);
        }
    }

    private static boolean containsOnlyElementsInsidePHPFiles(IStructuredSelection iStructuredSelection) {
        for (Object e : iStructuredSelection) {
            if (ActionUtils.isInsidePHPFile(e)) continue;
            return false;
        }
        return true;
    }

    public void run(IStructuredSelection iStructuredSelection) {
        this.selectionChanged(iStructuredSelection);
        if (this.isEnabled()) {
            this.fCopyToClipboardAction.run(iStructuredSelection);
        }
    }
}

