/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.dialogs.openType.generic;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.dialogs.openType.generic.CompositeFactory;
import org.eclipse.php.internal.ui.dialogs.openType.generic.CompositeFactoryAsserter;
import org.eclipse.php.internal.ui.dialogs.openType.generic.HighLoadTableViewer;
import org.eclipse.php.internal.ui.dialogs.openType.generic.IBasicSelectorLabelProvider;
import org.eclipse.php.internal.ui.dialogs.openType.generic.filter.ElementSpecificFilter;
import org.eclipse.php.internal.ui.dialogs.openType.generic.filter.IFilter;
import org.eclipse.php.internal.ui.util.SearchPattern;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class BasicSelector
extends Composite {
    private Label instructionLabel;
    private Text filterText;
    private Label matchingLabel;
    private HighLoadTableViewer tableViewer;
    private Composite tableViewerComposite;
    private CompositeFactory contentAreaCompositeFactory;
    private ViewerElementFilter phpTypeViewerFilter;
    private IBasicSelectorLabelProvider basicSelectorLabelProvider;

    public BasicSelector(Composite composite, CompositeFactory compositeFactory) {
        super(composite, 0);
        this.contentAreaCompositeFactory = new CompositeFactoryAsserter(compositeFactory);
        this.initialize();
    }

    public void setInitFilterText(String string) {
        this.filterText.setText(string);
    }

    private void initialize() {
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 10;
        formLayout.marginHeight = 5;
        this.setLayout((Layout)formLayout);
        this.initControls();
        this.setSize(new Point(341, 400));
    }

    private void initControls() {
        this.createInstructionLabel();
        FormData formData = new FormData();
        this.instructionLabel.setLayoutData((Object)formData);
        formData.top = new FormAttachment(0);
        this.createFilterText();
        formData = new FormData();
        this.filterText.setLayoutData((Object)formData);
        formData.top = new FormAttachment((Control)this.instructionLabel, 5);
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        Text text = this.filterText;
        if (this.contentAreaCompositeFactory != null) {
            Composite composite = this.contentAreaCompositeFactory.createComposite(this);
            text = composite;
            formData = new FormData();
            composite.setLayoutData((Object)formData);
            formData.top = new FormAttachment((Control)this.filterText, 5);
            formData.left = new FormAttachment(0);
            formData.right = new FormAttachment(100);
        }
        this.createMatchingLabel();
        formData = new FormData();
        this.matchingLabel.setLayoutData((Object)formData);
        formData.top = new FormAttachment((Control)text, 5);
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        this.createTableViewer();
        formData = new FormData();
        this.tableViewerComposite.setLayoutData((Object)formData);
        formData.top = new FormAttachment((Control)this.matchingLabel, 5);
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.bottom = new FormAttachment(100);
    }

    private void createTableViewer() {
        this.tableViewerComposite = new Composite((Composite)this, 0);
        FillLayout fillLayout = new FillLayout();
        this.tableViewerComposite.setLayout((Layout)fillLayout);
        this.tableViewer = new HighLoadTableViewer(this.tableViewerComposite, 2820);
        this.phpTypeViewerFilter = new ViewerElementFilter();
        this.tableViewer.addFilter(this.phpTypeViewerFilter);
        this.tableViewer.getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                StructuredSelection structuredSelection = (StructuredSelection)BasicSelector.this.tableViewer.getSelection();
                if (structuredSelection.getFirstElement() == BasicSelector.this.tableViewer.getElementAt(0) && 0x1000001 == keyEvent.keyCode) {
                    BasicSelector.this.filterText.setFocus();
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        this.tableViewer.getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if ((keyEvent.keyCode & 0x1000000) == 0) {
                    if (keyEvent.keyCode > 97 && keyEvent.keyCode < 122 || keyEvent.keyCode > 65 && keyEvent.keyCode < 90) {
                        BasicSelector.this.filterText.setFocus();
                        BasicSelector.this.filterText.setText(String.valueOf(BasicSelector.this.filterText.getText()) + keyEvent.character);
                        BasicSelector.this.filterText.setSelection(BasicSelector.this.filterText.getText().length());
                    } else if (keyEvent.keyCode == 8) {
                        BasicSelector.this.filterText.setFocus();
                        String string = BasicSelector.this.filterText.getText();
                        if (string.length() == 0) {
                            return;
                        }
                        BasicSelector.this.filterText.setText(string.substring(0, string.length() - 1));
                        BasicSelector.this.filterText.setSelection(string.length() - 1);
                    }
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        });
    }

    private void createMatchingLabel() {
        this.matchingLabel = new Label((Composite)this, 0);
        this.matchingLabel.setText(PHPUIMessages.OpenType_matchingResources);
    }

    private void createFilterText() {
        this.filterText = new Text((Composite)this, 2048);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                BasicSelector.this.phpTypeViewerFilter.setFilterText(BasicSelector.this.filterText.getText());
            }
        });
        this.filterText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (0x1000002 == keyEvent.keyCode && BasicSelector.this.tableViewer.getTableElements().length != 0) {
                    BasicSelector.this.tableViewer.getControl().setFocus();
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        });
    }

    private void createInstructionLabel() {
        this.instructionLabel = new Label((Composite)this, 0);
        this.instructionLabel.setText(PHPUIMessages.OpenType_instructionText);
    }

    public void setElements(Object[] objectArray) {
        this.tableViewer.setElements(objectArray);
    }

    public void setLabelProvider(IBasicSelectorLabelProvider iBasicSelectorLabelProvider) {
        this.basicSelectorLabelProvider = iBasicSelectorLabelProvider;
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object object, int n) {
                return BasicSelector.this.basicSelectorLabelProvider.getElementImage(object);
            }

            public String getColumnText(Object object, int n) {
                return BasicSelector.this.basicSelectorLabelProvider.getElementDescription(object);
            }

            public void addListener(ILabelProviderListener iLabelProviderListener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object object, String string) {
                return false;
            }

            public void removeListener(ILabelProviderListener iLabelProviderListener) {
            }
        });
    }

    public void addFilter(IFilter iFilter) {
        this.tableViewer.addFilter(iFilter);
    }

    public Object getSelectedElement() {
        return ((StructuredSelection)this.tableViewer.getSelection()).getFirstElement();
    }

    public void addDoubleClickListener(IDoubleClickListener iDoubleClickListener) {
        this.tableViewer.addDoubleClickListener(iDoubleClickListener);
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.tableViewer.addSelectionChangedListener(iSelectionChangedListener);
    }

    public void setDefaultElementSelection(boolean bl) {
        this.tableViewer.setDefaultElementSelection(bl);
    }

    public void close() {
        this.tableViewer.close();
    }

    private class ViewerElementFilter
    extends ElementSpecificFilter {
        private String textFilter = "";

        private ViewerElementFilter() {
        }

        public boolean select(Object object) {
            if (this.textFilter.equals("")) {
                return false;
            }
            String string = BasicSelector.this.basicSelectorLabelProvider.getElementName(object).toLowerCase();
            return SearchPattern.match(this.textFilter, string);
        }

        public void setFilterText(String string) {
            this.textFilter = string.toLowerCase();
            this.notifyFilterChanged();
        }
    }
}

