/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.IReconcileStep;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.core.documentModel.DOMModelForPHP;
import org.eclipse.php.internal.core.phpModel.parser.ModelListener;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.IPHPMarker;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.resources.ExternalFilesRegistry;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.editor.reconcile.ReconcileStepForPHP;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.html.core.internal.validate.HTMLValidationAdapterFactory;
import org.eclipse.wst.html.internal.validation.HTMLValidationReporter;
import org.eclipse.wst.html.internal.validation.HTMLValidator;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.FileBufferModelManager;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.validate.ValidationAdapter;
import org.eclipse.wst.sse.core.internal.validate.ValidationReporter;
import org.eclipse.wst.sse.ui.internal.StructuredResourceMarkerAnnotationModel;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.reconcile.ReconcileAnnotationKey;
import org.eclipse.wst.sse.ui.internal.reconcile.TemporaryAnnotation;
import org.eclipse.wst.validation.internal.operations.LocalizedMessage;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.xml.core.internal.document.DocumentTypeAdapter;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Text;

public class PHPHTMLValidator
extends HTMLValidator
implements ModelListener {
    private IDocument fDocument;
    private String currentFileName = null;

    public void validate(IRegion iRegion, IValidationContext iValidationContext, IReporter iReporter) {
        ITypedRegion iTypedRegion;
        if (this.currentFileName == null && this.fDocument != null) {
            this.innerConnect();
        }
        int n = iRegion.getOffset();
        try {
            iTypedRegion = this.fDocument.getPartition(n);
        }
        catch (BadLocationException badLocationException) {
            Logger.logException(badLocationException);
            return;
        }
        String string = iTypedRegion.getType();
        if (string.equals("org.eclipse.wst.html.HTML_DEFAULT")) {
            IStructuredModel iStructuredModel = null;
            iStructuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.fDocument);
            DOMModelForPHP dOMModelForPHP = (DOMModelForPHP)iStructuredModel;
            IFile iFile = dOMModelForPHP.getIFile();
            iStructuredModel.releaseFromRead();
            if (ExternalFilesRegistry.getInstance().isEntryExist(iFile.getFullPath().toString())) {
                this.validateHTMLForExternalDocument(iRegion, iValidationContext, iReporter);
            } else {
                super.validate(iRegion, iValidationContext, iReporter);
            }
            return;
        }
    }

    public void connect(IDocument iDocument) {
        super.connect(iDocument);
        this.fDocument = iDocument;
        this.innerConnect();
    }

    private void innerConnect() {
        IStructuredModel iStructuredModel = null;
        try {
            iStructuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.fDocument);
            if (iStructuredModel == null) {
                return;
            }
            this.currentFileName = iStructuredModel.getId();
            PHPWorkspaceModelManager.getInstance().addModelListener((ModelListener)this);
            DOMModelForPHP dOMModelForPHP = (DOMModelForPHP)iStructuredModel;
            PHPFileData pHPFileData = dOMModelForPHP.getFileData();
            if (pHPFileData != null) {
                this.fileDataChanged(pHPFileData);
            }
        }
        finally {
            if (iStructuredModel != null) {
                iStructuredModel.releaseFromRead();
            }
        }
    }

    private void calcCurrentFileName() {
        IStructuredModel iStructuredModel = null;
        try {
            iStructuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.fDocument);
            if (iStructuredModel == null) {
                return;
            }
            this.currentFileName = iStructuredModel.getId();
        }
        finally {
            if (iStructuredModel != null) {
                iStructuredModel.releaseFromRead();
            }
        }
    }

    public void disconnect(IDocument iDocument) {
        super.disconnect(iDocument);
        if (iDocument == this.fDocument) {
            this.fDocument = null;
        }
        PHPWorkspaceModelManager.getInstance().removeModelListener((ModelListener)this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void validateHTMLForExternalDocument(IRegion iRegion, IValidationContext iValidationContext, IReporter iReporter) {
        if (iValidationContext == null) return;
        if (this.fDocument == null) {
            return;
        }
        if (iReporter != null && iReporter.isCancelled()) {
            throw new OperationCanceledException();
        }
        IStructuredModel iStructuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.fDocument);
        if (iStructuredModel == null) {
            return;
        }
        try {
            IDOMDocument iDOMDocument = null;
            if (iStructuredModel instanceof IDOMModel) {
                iDOMDocument = ((IDOMModel)iStructuredModel).getDocument();
            }
            if (iDOMDocument == null) return;
            if (!this.hasHTMLFeature(iDOMDocument)) {
                return;
            }
            ITextFileBuffer iTextFileBuffer = FileBufferModelManager.getInstance().getBuffer(this.fDocument);
            if (iTextFileBuffer == null) {
                return;
            }
            IFile iFile = ExternalFilesRegistry.getInstance().getFileEntry(iTextFileBuffer.getLocation().toString());
            IndexedRegion indexedRegion = this.getCoveringNode(iRegion);
            if (indexedRegion instanceof Text) {
                while (indexedRegion != null && indexedRegion instanceof Text) {
                    indexedRegion = iStructuredModel.getIndexedRegion(indexedRegion.getEndOffset());
                }
            }
            if (!(indexedRegion instanceof INodeNotifier)) return;
            HTMLValidationAdapterFactory hTMLValidationAdapterFactory = HTMLValidationAdapterFactory.getInstance();
            ValidationAdapter validationAdapter = (ValidationAdapter)hTMLValidationAdapterFactory.adapt((INodeNotifier)indexedRegion);
            if (validationAdapter == null) {
                return;
            }
            if (iReporter != null) {
                HTMLValidationReporter hTMLValidationReporter = null;
                hTMLValidationReporter = this.getReporter(iReporter, iFile, (IDOMModel)iStructuredModel);
                hTMLValidationReporter.clear();
                validationAdapter.setReporter((ValidationReporter)hTMLValidationReporter);
                String string = "";
                IPath iPath = iFile.getFullPath();
                if (iPath != null) {
                    string = iPath.toString();
                }
                Object[] objectArray = new String[]{string};
                LocalizedMessage localizedMessage = new LocalizedMessage(4, NLS.bind((String)"HTML Syntax : {0}", (Object[])objectArray));
                localizedMessage.setParams((String[])objectArray);
                iReporter.displaySubtask((IValidator)this, (IMessage)localizedMessage);
            }
            validationAdapter.validate(indexedRegion);
            return;
        }
        finally {
            if (iStructuredModel != null) {
                iStructuredModel.releaseFromRead();
            }
        }
    }

    private boolean hasHTMLFeature(IDOMDocument iDOMDocument) {
        DocumentTypeAdapter documentTypeAdapter = (DocumentTypeAdapter)iDOMDocument.getAdapterFor(DocumentTypeAdapter.class);
        if (documentTypeAdapter == null) {
            return false;
        }
        return documentTypeAdapter.hasFeature("HTML");
    }

    private IndexedRegion getCoveringNode(IRegion iRegion) {
        IndexedRegion indexedRegion = null;
        if (this.fDocument instanceof IStructuredDocument) {
            IStructuredModel iStructuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.fDocument);
            try {
                if (iStructuredModel != null) {
                    IStructuredDocumentRegion[] iStructuredDocumentRegionArray = ((IStructuredDocument)this.fDocument).getStructuredDocumentRegions(iRegion.getOffset(), iRegion.getLength());
                    indexedRegion = this.getLargest(iStructuredDocumentRegionArray);
                }
            }
            finally {
                if (iStructuredModel != null) {
                    iStructuredModel.releaseFromRead();
                }
            }
        }
        return indexedRegion;
    }

    public void dataCleared() {
    }

    public void fileDataAdded(PHPFileData pHPFileData) {
        this.calcCurrentFileName();
    }

    public void fileDataChanged(PHPFileData pHPFileData) {
        Iterator iterator;
        StructuredResourceMarkerAnnotationModel structuredResourceMarkerAnnotationModel;
        Object object;
        Object object2;
        if (!pHPFileData.getName().equals(this.currentFileName)) {
            return;
        }
        IPHPMarker[] iPHPMarkerArray = pHPFileData.getMarkers();
        if (iPHPMarkerArray == null) {
            return;
        }
        ArrayList<StructuredResourceMarkerAnnotationModel> arrayList = new ArrayList<StructuredResourceMarkerAnnotationModel>();
        int n = 0;
        while (iPHPMarkerArray.length > n) {
            object2 = iPHPMarkerArray[n];
            if (!object2.getType().equals("TASK")) {
                object = object2.getDescription();
                structuredResourceMarkerAnnotationModel = new LocalizedMessage(1, (String)object);
                iterator = object2.getUserData();
                int n2 = iterator.getStartPosition();
                int n3 = iterator.getEndPosition() - n2;
                structuredResourceMarkerAnnotationModel.setOffset(n2);
                structuredResourceMarkerAnnotationModel.setLength(n3);
                arrayList.add(structuredResourceMarkerAnnotationModel);
            }
            ++n;
        }
        ReconcileStepForPHP reconcileStepForPHP = new ReconcileStepForPHP();
        object2 = this.createAnnotations(reconcileStepForPHP, arrayList);
        object = this.getTextViewer();
        if (object == null) {
            return;
        }
        structuredResourceMarkerAnnotationModel = (StructuredResourceMarkerAnnotationModel)object.getAnnotationModel();
        iterator = structuredResourceMarkerAnnotationModel.getAnnotationIterator();
        ArrayList<TemporaryAnnotation> arrayList2 = new ArrayList<TemporaryAnnotation>();
        while (iterator.hasNext()) {
            TemporaryAnnotation temporaryAnnotation;
            Annotation annotation = (Annotation)iterator.next();
            if (!(annotation instanceof TemporaryAnnotation) || !this.isPhpViewerAnnotation(temporaryAnnotation = (TemporaryAnnotation)annotation)) continue;
            arrayList2.add(temporaryAnnotation);
        }
        structuredResourceMarkerAnnotationModel.replaceAnnotations(arrayList2.toArray(new Annotation[0]), (Map)object2);
    }

    private StructuredTextViewer getTextViewer() {
        IWorkbenchPage iWorkbenchPage;
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        IWorkbenchWindow iWorkbenchWindow = iWorkbench.getActiveWorkbenchWindow();
        if (iWorkbenchWindow == null && ((IWorkbenchPage)(iWorkbenchPage = iWorkbench.getWorkbenchWindows())).length > 0) {
            iWorkbenchWindow = iWorkbenchPage[0];
        }
        if ((iWorkbenchPage = iWorkbenchWindow.getActivePage()) == null) {
            return null;
        }
        IEditorPart iEditorPart = iWorkbenchPage.getActiveEditor();
        if (iEditorPart instanceof PHPStructuredEditor) {
            PHPStructuredEditor pHPStructuredEditor = (PHPStructuredEditor)iEditorPart;
            StructuredTextViewer structuredTextViewer = pHPStructuredEditor.getTextViewer();
            if (this.fDocument == structuredTextViewer.getDocument()) {
                return structuredTextViewer;
            }
            IEditorReference[] iEditorReferenceArray = iWorkbenchPage.getEditorReferences();
            int n = 0;
            while (n < iEditorReferenceArray.length) {
                IEditorReference iEditorReference = iEditorReferenceArray[n];
                iEditorPart = iEditorReference.getEditor(false);
                if (iEditorPart instanceof PHPStructuredEditor && this.fDocument == (structuredTextViewer = (pHPStructuredEditor = (PHPStructuredEditor)iEditorPart).getTextViewer()).getDocument()) {
                    return structuredTextViewer;
                }
                ++n;
            }
        }
        return null;
    }

    private boolean isPhpViewerAnnotation(TemporaryAnnotation temporaryAnnotation) {
        ReconcileAnnotationKey reconcileAnnotationKey = (ReconcileAnnotationKey)temporaryAnnotation.getKey();
        return reconcileAnnotationKey.getPartitionType().equals("org.eclipse.php.PHP_DEFAULT");
    }

    public Map createAnnotations(ReconcileStepForPHP reconcileStepForPHP, List list) {
        HashMap<TemporaryAnnotation, Position> hashMap = new HashMap<TemporaryAnnotation, Position>();
        int n = 0;
        while (n < list.size()) {
            block5: {
                IMessage iMessage = (IMessage)list.get(n);
                int n2 = iMessage.getOffset();
                if (n2 >= 0) {
                    String string = null;
                    try {
                        string = iMessage.getText(iMessage.getClass().getClassLoader());
                    }
                    catch (Exception exception) {
                        Logger.logException("exception reporting message from validator", exception);
                        break block5;
                    }
                    int n3 = iMessage.getLength();
                    if (n3 >= 0) {
                        Position position = new Position(n2, n3);
                        ReconcileAnnotationKey reconcileAnnotationKey = this.createKey(reconcileStepForPHP);
                        hashMap.put(new TemporaryAnnotation(position, "org.eclipse.wst.sse.ui.temp.error", string, reconcileAnnotationKey), position);
                    }
                }
            }
            ++n;
        }
        return hashMap;
    }

    public ReconcileAnnotationKey createKey(ReconcileStepForPHP reconcileStepForPHP) {
        return new ReconcileAnnotationKey((IReconcileStep)reconcileStepForPHP, "org.eclipse.php.PHP_DEFAULT", 0);
    }

    public void fileDataRemoved(PHPFileData pHPFileData) {
    }
}

