/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.binding;

import org.eclipse.php.internal.core.ast.binding.AttributeType;

public abstract class Attribute {
    public static final NullAttribute NULL_ATTRIBUTE = new NullAttribute();
    public static final IntAttribute INT_ATTRIBUTE = new IntAttribute();
    public static final StringAttribute STRING_ATTRIBUTE = new StringAttribute();
    public static final BoolAttribute BOOL_ATTRIBUTE = new BoolAttribute();
    public static final RealAttribute REAL_ATTRIBUTE = new RealAttribute();

    public abstract AttributeType getType();

    public String toString() {
        return this.getType().toString();
    }

    private static class BoolAttribute
    extends Attribute {
        private BoolAttribute() {
        }

        public AttributeType getType() {
            return AttributeType.BOOL_ATTRIBUTE;
        }
    }

    private static class IntAttribute
    extends Attribute {
        private IntAttribute() {
        }

        public AttributeType getType() {
            return AttributeType.INT_ATTRIBUTE;
        }
    }

    private static class NullAttribute
    extends Attribute {
        private NullAttribute() {
        }

        public AttributeType getType() {
            return AttributeType.NULL_ATTRIBUTE;
        }
    }

    private static class RealAttribute
    extends Attribute {
        private RealAttribute() {
        }

        public AttributeType getType() {
            return AttributeType.REAL_ATTRIBUTE;
        }
    }

    private static class StringAttribute
    extends Attribute {
        private StringAttribute() {
        }

        public AttributeType getType() {
            return AttributeType.STRING_ATTRIBUTE;
        }
    }
}

