/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phpModel.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.php.internal.core.phpModel.IPHPLanguageModel;
import org.eclipse.php.internal.core.phpModel.parser.ExternalFilesModel;
import org.eclipse.php.internal.core.phpModel.parser.FilterableCompositePhpModel;
import org.eclipse.php.internal.core.phpModel.parser.IPhpModel;
import org.eclipse.php.internal.core.phpModel.parser.IPhpProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.IProjectModelListener;
import org.eclipse.php.internal.core.phpModel.parser.ModelSupport;
import org.eclipse.php.internal.core.phpModel.parser.PHPCodeContext;
import org.eclipse.php.internal.core.phpModel.parser.PHPCodeDataFactory;
import org.eclipse.php.internal.core.phpModel.parser.PHPIncludePathModelManager;
import org.eclipse.php.internal.core.phpModel.parser.PHPLanguageModelManager;
import org.eclipse.php.internal.core.phpModel.parser.PHPUserModel;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassConstData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassVarData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class PHPProjectModel
extends FilterableCompositePhpModel
implements IPhpProjectModel,
IAdaptable {
    private static String ID = "PHPProjectModel";
    private PHPUserModel userModel;
    private IPHPLanguageModel languageModel;
    private Set<IProjectModelListener> listeners = new HashSet<IProjectModelListener>(2);
    private IProject currentProject;

    public void initialize() {
        this.languageModel = new PHPLanguageModelManager().setDefaultLanguageModel();
        this.addModel(this.languageModel);
    }

    public void initialize(IProject iProject) {
        this.currentProject = iProject;
        this.userModel = new PHPUserModel();
        this.userModel.initialize(iProject);
        this.addModel(this.userModel);
        this.languageModel = new PHPLanguageModelManager();
        this.languageModel.initialize(iProject);
        this.addModel(this.languageModel);
        if (iProject != null && iProject.isAccessible()) {
            PHPIncludePathModelManager pHPIncludePathModelManager = new PHPIncludePathModelManager();
            pHPIncludePathModelManager.initialize(iProject);
            this.addModel(pHPIncludePathModelManager);
        }
        this.addModelListenrs();
    }

    public IProject getProject() {
        return this.currentProject;
    }

    public String getID() {
        return ID;
    }

    private void addModelListenrs() {
        IPhpModel[] iPhpModelArray = this.getModels();
        int n = 0;
        while (n < iPhpModelArray.length) {
            IPhpModel iPhpModel = iPhpModelArray[n];
            if (iPhpModel instanceof IProjectModelListener) {
                this.addProjectModelListener((IProjectModelListener)((Object)iPhpModel));
            }
            ++n;
        }
    }

    public PHPUserModel getPHPUserModel() {
        return this.userModel;
    }

    public IPHPLanguageModel getPHPLanguageModel() {
        return this.languageModel;
    }

    public Object getExternalResource(PHPFileData pHPFileData) {
        IPhpModel[] iPhpModelArray = this.getModels();
        int n = 0;
        while (n < iPhpModelArray.length) {
            Object object;
            if (iPhpModelArray[n] instanceof ExternalFilesModel && (object = ((ExternalFilesModel)iPhpModelArray[n]).getExternalResource(pHPFileData)) != null) {
                return object;
            }
            ++n;
        }
        return null;
    }

    public CodeData getActiveConstructor(String string, String string2) {
        PHPClassData pHPClassData = this.getClass(string2, string);
        CodeData codeData = null;
        if (pHPClassData != null && (codeData = this.getUserActiveConstructor(pHPClassData)) == null) {
            codeData = pHPClassData.getConstructor();
        }
        return codeData;
    }

    private CodeData getUserActiveConstructor(PHPClassData pHPClassData) {
        return this.getUserActiveConstructor(pHPClassData, new HashSet());
    }

    private CodeData getUserActiveConstructor(PHPClassData pHPClassData, HashSet hashSet) {
        if (pHPClassData == null) {
            return null;
        }
        if (pHPClassData.hasConstructor()) {
            return pHPClassData.getConstructor();
        }
        String string = pHPClassData.getSuperClassData().getName();
        if (string != null && !hashSet.contains(string)) {
            hashSet.add(pHPClassData.getName());
            String string2 = pHPClassData.isUserCode() ? pHPClassData.getUserData().getFileName() : "";
            return this.getUserActiveConstructor(this.getClass(string2, string), hashSet);
        }
        return null;
    }

    public CodeData getClassFunctionData(String string, String string2, String string3) {
        return this.getClassFunctionData(string, string2, string3, new HashSet());
    }

    private CodeData getClassFunctionData(String string, String string2, String string3, HashSet hashSet) {
        PHPClassData pHPClassData = this.getClass(string, string2);
        if (pHPClassData == null) {
            return null;
        }
        CodeData[] codeDataArray = pHPClassData.getFunctions();
        int n = ModelSupport.getFirstMatch(codeDataArray, string3, true);
        if (n >= 0) {
            return codeDataArray[n];
        }
        String string4 = pHPClassData.getSuperClassData().getName();
        if (string4 != null && !hashSet.contains(string4)) {
            hashSet.add(string2);
            string = pHPClassData.isUserCode() ? pHPClassData.getUserData().getFileName() : "";
            return this.getClassFunctionData(string, string4, string3, hashSet);
        }
        return null;
    }

    public CodeData[] getClassFunctions(String string, String string2, String string3) {
        return this.getClassFunctions(string, string2, string3, new HashSet());
    }

    private CodeData[] getClassFunctions(String string, String string2, String string3, HashSet hashSet) {
        PHPClassData pHPClassData = this.getClass(string, string2);
        if (pHPClassData == null) {
            return null;
        }
        CodeData[] codeDataArray = ModelSupport.getCodeDataStartingWith(pHPClassData.getFunctions(), string3);
        CodeData[] codeDataArray2 = new CodeData[]{};
        String string4 = pHPClassData.getSuperClassData().getName();
        if (string4 != null && !hashSet.contains(string4)) {
            hashSet.add(string2);
            string = pHPClassData.isUserCode() ? pHPClassData.getUserData().getFileName() : "";
            codeDataArray2 = ModelSupport.getFilteredCodeData(this.getClassFunctions(string, string4, string3, hashSet), ModelSupport.PROTECTED_ACCESS_LEVEL_FILTER);
        }
        return ModelSupport.removeRepeatedNames(ModelSupport.mergeAndRemoveDuplicated(codeDataArray, codeDataArray2));
    }

    public CodeData getClassVariablesData(String string, String string2, String string3) {
        PHPClassData pHPClassData = this.getClass(string, string2);
        if (pHPClassData == null) {
            return null;
        }
        if (string3.startsWith("$")) {
            string3 = string3.substring(1);
        }
        PHPClassVarData[] pHPClassVarDataArray = pHPClassData.getVars();
        int n = 0;
        while (n < pHPClassVarDataArray.length) {
            if (pHPClassVarDataArray[n].getName().equals(string3)) {
                return pHPClassVarDataArray[n];
            }
            ++n;
        }
        String string4 = pHPClassData.getSuperClassData().getName();
        if (string4 != null) {
            string = pHPClassData.isUserCode() ? pHPClassData.getUserData().getFileName() : "";
            return this.getClassVariablesData(string, string4, string3);
        }
        return null;
    }

    public CodeData[] getClassVariables(String string, String string2, String string3) {
        return this.getClassVariables(string, string2, string3, new HashSet());
    }

    private CodeData[] getClassVariables(String string, String string2, String string3, HashSet hashSet) {
        PHPClassData pHPClassData = this.getClass(string, string2);
        if (pHPClassData == null) {
            return null;
        }
        if (string3.startsWith("$")) {
            string3 = string3.substring(1);
        }
        CodeData[] codeDataArray = ModelSupport.getCodeDataStartingWith(pHPClassData.getVars(), string3);
        CodeData[] codeDataArray2 = null;
        String string4 = pHPClassData.getSuperClassData().getName();
        if (string4 != null && !hashSet.contains(string4)) {
            hashSet.add(string2);
            string = pHPClassData.isUserCode() ? pHPClassData.getUserData().getFileName() : "";
            codeDataArray2 = ModelSupport.getFilteredCodeData(this.getClassVariables(string, string4, string3, hashSet), ModelSupport.PROTECTED_ACCESS_LEVEL_FILTER);
        }
        return ModelSupport.merge(codeDataArray, codeDataArray2);
    }

    public CodeData getClassConstsData(String string, String string2, String string3) {
        return this.getClassConstsData(string, string2, string3, new HashSet());
    }

    private CodeData getClassConstsData(String string, String string2, String string3, HashSet hashSet) {
        Object object;
        PHPClassData pHPClassData = this.getClass(string, string2);
        if (pHPClassData == null) {
            return null;
        }
        PHPClassConstData[] pHPClassConstDataArray = pHPClassData.getConsts();
        int n = 0;
        while (n < pHPClassConstDataArray.length) {
            if (pHPClassConstDataArray[n].getName().equals(string3)) {
                return pHPClassConstDataArray[n];
            }
            ++n;
        }
        String string4 = pHPClassData.getSuperClassData().getName();
        if (string4 != null && !hashSet.contains(string4)) {
            hashSet.add(string2);
            string = pHPClassData.isUserCode() ? pHPClassData.getUserData().getFileName() : "";
            object = this.getClassConstsData(string, string4, string3, hashSet);
            if (object != null) {
                return object;
            }
        }
        object = pHPClassData.getInterfacesNamesData();
        int n2 = 0;
        while (n2 < ((PHPClassData.PHPInterfaceNameData[])object).length) {
            PHPClassData.PHPInterfaceNameData pHPInterfaceNameData = object[n2];
            string = pHPClassData.isUserCode() ? pHPClassData.getUserData().getFileName() : "";
            CodeData codeData = this.getClassConstsData(string, pHPInterfaceNameData.getName(), string3);
            if (codeData != null) {
                return codeData;
            }
            ++n2;
        }
        return null;
    }

    public CodeData[] getClassConsts(String string, String string2, String string3) {
        return this.getClassConsts(string, string2, string3, new HashSet());
    }

    private CodeData[] getClassConsts(String string, String string2, String string3, HashSet hashSet) {
        PHPClassData.PHPInterfaceNameData[] pHPInterfaceNameDataArray;
        PHPClassData pHPClassData = this.getClass(string, string2);
        if (pHPClassData == null) {
            return null;
        }
        CodeData[] codeDataArray = ModelSupport.getCodeDataStartingWith(pHPClassData.getConsts(), string3);
        ArrayList arrayList = new ArrayList();
        String string4 = pHPClassData.getSuperClassData().getName();
        if (string4 != null && !hashSet.contains(string4)) {
            hashSet.add(string2);
            string = pHPClassData.isUserCode() ? pHPClassData.getUserData().getFileName() : "";
            arrayList.addAll(Arrays.asList(this.getClassConsts(string, string4, string3, hashSet)));
        }
        PHPClassData.PHPInterfaceNameData[] pHPInterfaceNameDataArray2 = pHPInterfaceNameDataArray = pHPClassData.getInterfacesNamesData();
        int n = pHPInterfaceNameDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            PHPClassData.PHPInterfaceNameData pHPInterfaceNameData = pHPInterfaceNameDataArray2[n2];
            String string5 = pHPInterfaceNameData.getName();
            string = pHPClassData.isUserCode() ? pHPClassData.getUserData().getFileName() : "";
            arrayList.addAll(Arrays.asList(this.getClassConsts(string, string5, string3)));
            ++n2;
        }
        return ModelSupport.merge(codeDataArray, arrayList.toArray(new CodeData[arrayList.size()]));
    }

    public String getSuperClassName(String string, String string2) {
        PHPClassData pHPClassData = this.getClass(string, string2);
        if (pHPClassData != null) {
            return pHPClassData.getSuperClassData().getName();
        }
        return null;
    }

    public CodeData[] getKeywordData() {
        return this.languageModel.getKeywordData();
    }

    public CodeData[] getKeywordData(String string) {
        return ModelSupport.getCodeDataStartingWith(this.getKeywordData(), string);
    }

    public CodeData[] getVariables(String string, PHPCodeContext pHPCodeContext, String string2, boolean bl) {
        return ModelSupport.removeRepeatedNames(super.getVariables(string, pHPCodeContext, string2, bl));
    }

    public CodeData[] getArrayVariables(String string, String string2, String string3, boolean bl) {
        if (string2.equals("_SERVER") || string2.equals("HTTP_SERVER_VARS")) {
            return ModelSupport.getCodeDataStartingWith(this.languageModel.getServerVariables(), string3);
        }
        if (string2.equals("_SESSION") || string2.equals("HTTP_SESSION_VARS")) {
            return ModelSupport.getCodeDataStartingWith(this.languageModel.getSessionVariables(), string3);
        }
        if (string2.equals("GLOBALS")) {
            CodeData[] codeDataArray = ModelSupport.getCodeDataStartingWith(this.languageModel.getPHPVariables(), string3);
            CodeData[] codeDataArray2 = this.userModel.getGlobalVariables(string, string3, bl);
            return ModelSupport.removeRepeatedNames(ModelSupport.merge(codeDataArray, codeDataArray2));
        }
        return PHPCodeDataFactory.EMPTY_CODE_DATA_ARRAY;
    }

    public Object getAdapter(Class clazz) {
        return Platform.getAdapterManager().getAdapter((Object)this, clazz);
    }

    public void addFileToModel(IFile iFile) {
        this.fireFileDataAdded(iFile);
    }

    public void removeFileFromModel(IFile iFile) {
        this.fireFileDataRemoved(iFile);
    }

    public void fileWasChanged(IFile iFile, IStructuredDocument iStructuredDocument) {
        this.fireFileChanged(iFile, iStructuredDocument);
    }

    public synchronized void addProjectModelListener(IProjectModelListener iProjectModelListener) {
        this.listeners.add(iProjectModelListener);
    }

    public synchronized void removeProjectModelListener(IProjectModelListener iProjectModelListener) {
        this.listeners.remove(iProjectModelListener);
    }

    public synchronized IProjectModelListener[] getProjectModelListeners() {
        return this.listeners.toArray(new IProjectModelListener[this.listeners.size()]);
    }

    private void fireFileChanged(IFile iFile, IStructuredDocument iStructuredDocument) {
        IProjectModelListener[] iProjectModelListenerArray;
        IProjectModelListener[] iProjectModelListenerArray2 = iProjectModelListenerArray = this.getProjectModelListeners();
        int n = iProjectModelListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProjectModelListener iProjectModelListener = iProjectModelListenerArray2[n2];
            iProjectModelListener.fileChanged(iFile, iStructuredDocument);
            ++n2;
        }
    }

    private void fireFileDataRemoved(IFile iFile) {
        IProjectModelListener[] iProjectModelListenerArray;
        IProjectModelListener[] iProjectModelListenerArray2 = iProjectModelListenerArray = this.getProjectModelListeners();
        int n = iProjectModelListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProjectModelListener iProjectModelListener = iProjectModelListenerArray2[n2];
            iProjectModelListener.fileRemoved(iFile);
            ++n2;
        }
    }

    private void fireFileDataAdded(IFile iFile) {
        IProjectModelListener[] iProjectModelListenerArray;
        IProjectModelListener[] iProjectModelListenerArray2 = iProjectModelListenerArray = this.getProjectModelListeners();
        int n = iProjectModelListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProjectModelListener iProjectModelListener = iProjectModelListenerArray2[n2];
            iProjectModelListener.fileAdded(iFile);
            ++n2;
        }
    }
}

