/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.preferences;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.preferences.AbstractPreferencesPropagator;
import org.eclipse.php.internal.core.preferences.IPreferencesPropagatorListener;
import org.eclipse.php.internal.core.preferences.PreferencesPropagatorEvent;

public class ProjectPreferencesPropagator
extends AbstractPreferencesPropagator {
    private IProject project;
    private IEclipsePreferences.IPreferenceChangeListener preferenceChangeListener;
    private ProjectScope scope;
    private String nodeQualifier;

    public ProjectPreferencesPropagator(IProject iProject, String string) {
        this.project = iProject;
        this.nodeQualifier = string;
        this.install();
    }

    protected synchronized void install() {
        if (this.isInstalled) {
            return;
        }
        this.scope = new ProjectScope(this.project);
        this.preferenceChangeListener = new InnerPreferenceChangeListener();
        this.scope.getNode(this.nodeQualifier).addPreferenceChangeListener(this.preferenceChangeListener);
        super.install();
    }

    protected synchronized void uninstall() {
        if (!this.isInstalled) {
            return;
        }
        try {
            try {
                IEclipsePreferences iEclipsePreferences = this.scope.getNode(this.nodeQualifier);
                iEclipsePreferences.removePreferenceChangeListener(this.preferenceChangeListener);
            }
            catch (Exception exception) {
                this.scope = null;
                this.preferenceChangeListener = null;
                super.uninstall();
            }
        }
        finally {
            this.scope = null;
            this.preferenceChangeListener = null;
            super.uninstall();
        }
    }

    public List removePropagatorListeners(String string) {
        return (List)this.listenersMap.remove(string);
    }

    public void notifyPropagatorEvent(PreferencesPropagatorEvent preferencesPropagatorEvent) {
        this.notifyEvent((String)preferencesPropagatorEvent.getKey(), preferencesPropagatorEvent.getOldValue(), preferencesPropagatorEvent.getNewValue());
    }

    private void notifyPropagatorEvent(IEclipsePreferences.PreferenceChangeEvent preferenceChangeEvent) {
        this.notifyEvent(preferenceChangeEvent.getKey(), preferenceChangeEvent.getOldValue(), preferenceChangeEvent.getNewValue());
    }

    private void notifyEvent(String string, Object object, Object object2) {
        List list = this.getPropagatorListeners(string);
        if (list != null) {
            if (object2 == null && (object2 = this.getWorkspaceProperty(string)) != null && object2.equals(object)) {
                return;
            }
            PreferencesPropagatorEvent preferencesPropagatorEvent = new PreferencesPropagatorEvent(this.project, object, object2, string);
            IPreferencesPropagatorListener[] iPreferencesPropagatorListenerArray = new IPreferencesPropagatorListener[list.size()];
            list.toArray(iPreferencesPropagatorListenerArray);
            int n = 0;
            while (n < iPreferencesPropagatorListenerArray.length) {
                iPreferencesPropagatorListenerArray[n].preferencesEventOccured(preferencesPropagatorEvent);
                ++n;
            }
        }
    }

    public String getWorkspaceProperty(String string) {
        return PHPCorePlugin.getDefault().getPreferenceStore().getString(string);
    }

    private class InnerPreferenceChangeListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        private InnerPreferenceChangeListener() {
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent preferenceChangeEvent) {
            ProjectPreferencesPropagator.this.notifyPropagatorEvent(preferenceChangeEvent);
        }
    }
}

