/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.jdt.dbunit.internal.buildpath;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.drivers.DriverManager;
import org.eclipse.datatools.enablement.jdt.classpath.internal.DriverClasspathContainer;
import org.eclipse.datatools.enablement.jdt.dbunit.Activator;
import org.eclipse.datatools.enablement.jdt.dbunit.internal.buildpath.DbUnitContainerInitializer;
import org.eclipse.datatools.enablement.jdt.dbunit.internal.buildpath.DbUnitHomeInitializer;
import org.eclipse.datatools.enablement.jdt.dbunit.internal.buildpath.MyFilenameFilter;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;

public class BuildPathSupport {
    public static final String DBUNIT2_PLUGIN_ID = "org.dbunit";
    public static final String DBUNIT2_LIBS_DIR = "libs";

    public static IPath getBundleLocation(String bundleName) {
        Bundle bundle = Activator.getDefault().getBundle(bundleName);
        if (bundle == null) {
            return null;
        }
        URL local = null;
        try {
            local = FileLocator.toFileURL((URL)bundle.getEntry("/"));
        }
        catch (IOException iOException) {
            return null;
        }
        String fullPath = new File(local.getPath()).getAbsolutePath();
        return Path.fromOSString((String)fullPath);
    }

    public static IPath getSourceLocation(String bundleName) {
        Bundle bundle = Activator.getDefault().getBundle(bundleName);
        if (bundle == null) {
            return null;
        }
        String version = (String)bundle.getHeaders().get("Bundle-Version");
        if (version == null) {
            return null;
        }
        bundle = Activator.getDefault().getBundle(DBUNIT2_PLUGIN_ID);
        if (bundle == null) {
            return null;
        }
        URL local = null;
        try {
            local = FileLocator.toFileURL((URL)bundle.getEntry("/"));
        }
        catch (IOException iOException) {
            return null;
        }
        String fullPath = String.valueOf(new File(local.getPath()).getAbsolutePath()) + File.separator + "src" + File.separator + bundleName + "_" + version;
        return Path.fromOSString((String)fullPath);
    }

    public static IClasspathEntry getDbUnit2ClasspathEntry() {
        return JavaCore.newContainerEntry((IPath)DbUnitContainerInitializer.DBUNIT2_PATH);
    }

    public static IClasspathEntry getDbUnit2LibraryEntry() {
        IPath bundleBase = BuildPathSupport.getBundleLocation(DBUNIT2_PLUGIN_ID);
        if (bundleBase != null) {
            IPath jarLocation = bundleBase.append("dbunit-2.2.jar");
            IPath sourceBase = BuildPathSupport.getSourceLocation(DBUNIT2_PLUGIN_ID);
            IPath srcLocation = sourceBase != null ? sourceBase.append("dbunit-2.2-sources.jar") : null;
            return JavaCore.newLibraryEntry((IPath)jarLocation, (IPath)srcLocation, null);
        }
        return null;
    }

    public static IClasspathEntry getDbUnit2VariableEntry() {
        IPath jarBundleBase = JavaCore.getClasspathVariable((String)DbUnitHomeInitializer.DBUNIT_HOME);
        if (jarBundleBase != null) {
            IPath jarLocation = jarBundleBase.append("dbunit-2.2.jar");
            IPath sourceBase = JavaCore.getClasspathVariable((String)DbUnitHomeInitializer.DBUNIT_SRC_HOME);
            IPath srcLocation = sourceBase != null ? sourceBase.append("dbunit-2.2-sources.jar") : null;
            IClasspathEntry entry = JavaCore.newLibraryEntry((IPath)jarLocation, (IPath)srcLocation, null, (IAccessRule[])new IAccessRule[0], (IClasspathAttribute[])new IClasspathAttribute[0], (boolean)true);
            return entry;
        }
        return null;
    }

    public static IClasspathEntry getDriverVariableEntry(String driverID) {
        DriverClasspathContainer dcc;
        DriverInstance di = DriverManager.getInstance().getDriverInstanceByID(driverID);
        if (di != null && (dcc = new DriverClasspathContainer(di.getName())) != null && dcc.getClasspathEntries() != null && dcc.getClasspathEntries().length > 0) {
            return dcc.getClasspathEntries()[0];
        }
        return null;
    }

    private static String getResolvedFilename(IPath path, String pattern) {
        Object[] files;
        String absolutePath = path.toOSString();
        File folder = new File(absolutePath);
        if (folder.exists() && (files = folder.list(new MyFilenameFilter(pattern))) != null && files.length > 0) {
            Arrays.sort(files);
            return files[0];
        }
        return null;
    }

    private static IClasspathEntry getEntryForValues(IPath path, String libName) {
        String realName = BuildPathSupport.getResolvedFilename(path, libName);
        IPath jarLocation = null;
        jarLocation = realName != null ? path.append(realName) : path.append(libName);
        return JavaCore.newLibraryEntry((IPath)jarLocation, null, null);
    }

    public static IClasspathEntry[] getOtherDbUnitVariableEntries() {
        IPath jarBundleBase = JavaCore.getClasspathVariable((String)DbUnitHomeInitializer.DBUNIT_HOME);
        if (jarBundleBase != null) {
            IClasspathEntry[] entries = new IClasspathEntry[]{BuildPathSupport.getEntryForValues(jarBundleBase, "commons-collections.*.jar$"), BuildPathSupport.getEntryForValues(jarBundleBase, "commons-lang.*.jar$"), BuildPathSupport.getEntryForValues(jarBundleBase, "commons-logging.*.jar$"), BuildPathSupport.getEntryForValues(jarBundleBase, "poi.*.jar$"), BuildPathSupport.getEntryForValues(jarBundleBase, "xml-apis.jar"), BuildPathSupport.getEntryForValues(jarBundleBase, "xercesImpl.jar")};
            return entries;
        }
        return null;
    }

    public static IClasspathEntry modifyClasspathEntry(Shell shell, IClasspathEntry newEntry, String[] changedAttributes, IJavaProject jproject, IProgressMonitor monitor) throws CoreException {
        return BuildPathSupport.updateProjectClasspath(shell, jproject, newEntry, changedAttributes, monitor);
    }

    private static IClasspathEntry getUpdatedEntry(IClasspathEntry currEntry, IClasspathEntry updatedEntry, String[] updatedAttributes, IJavaProject jproject) {
        if (updatedAttributes == null) {
            return updatedEntry;
        }
        CPListElement currElem = CPListElement.createFromExisting((IClasspathEntry)currEntry, (IJavaProject)jproject);
        CPListElement newElem = CPListElement.createFromExisting((IClasspathEntry)updatedEntry, (IJavaProject)jproject);
        int i = 0;
        while (i < updatedAttributes.length) {
            String attrib = updatedAttributes[i];
            currElem.setAttribute(attrib, newElem.getAttribute(attrib));
            ++i;
        }
        return currElem.getClasspathEntry();
    }

    private static IClasspathEntry updateProjectClasspath(Shell shell, IJavaProject jproject, IClasspathEntry newEntry, String[] changedAttributes, IProgressMonitor monitor) throws JavaModelException {
        IClasspathEntry[] oldClasspath = jproject.getRawClasspath();
        int nEntries = oldClasspath.length;
        int entryKind = newEntry.getEntryKind();
        IPath jarPath = newEntry.getPath();
        boolean found = false;
        int i = 0;
        while (i < nEntries) {
            IClasspathEntry curr = oldClasspath[i];
            if (curr.getEntryKind() == entryKind && curr.getPath().equals((Object)jarPath)) {
                newEntry = BuildPathSupport.getUpdatedEntry(curr, newEntry, changedAttributes, jproject);
                found = true;
            }
            ++i;
        }
        if (!found) {
            return newEntry;
        }
        return null;
    }

    public static IClasspathEntry updateNativeLibraryForClassPath(String nativeLibraryPath, IPackageFragmentRoot elem, IClasspathEntry entry) {
        try {
            IJavaProject project = elem.getJavaProject();
            if (elem instanceof IPackageFragmentRoot) {
                CPListElement cpElem = CPListElement.createFromExisting((IClasspathEntry)entry, (IJavaProject)project);
                cpElem.setAttribute(CPListElement.NATIVE_LIB_PATH, (Object)nativeLibraryPath);
                IClasspathEntry newEntry = cpElem.getClasspathEntry();
                String[] changedAttributes = new String[]{CPListElement.NATIVE_LIB_PATH};
                return BuildPathSupport.modifyClasspathEntry(new Shell(), newEntry, changedAttributes, project, null);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }
}

