/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.archive;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.internal.archive.AppClientComponentArchiveLoadAdapter;
import org.eclipse.jst.j2ee.internal.archive.ComponentArchiveLoadAdapter;
import org.eclipse.jst.j2ee.internal.archive.ConnectorComponentArchiveLoadAdapter;
import org.eclipse.jst.j2ee.internal.archive.EARComponentArchiveLoadAdapter;
import org.eclipse.jst.j2ee.internal.archive.EJBComponentArchiveLoadAdapter;
import org.eclipse.jst.j2ee.internal.archive.JavaComponentArchiveLoadAdapter;
import org.eclipse.jst.j2ee.internal.archive.JavaEEEMFArchiveAdapterHelper;
import org.eclipse.jst.j2ee.internal.archive.WebComponentArchiveLoadAdapter;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.jee.archive.ArchiveModelLoadException;
import org.eclipse.jst.jee.archive.ArchiveOpenFailureException;
import org.eclipse.jst.jee.archive.ArchiveOptions;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.jst.jee.archive.IArchiveFactory;
import org.eclipse.jst.jee.archive.IArchiveLoadAdapter;
import org.eclipse.jst.jee.archive.IArchiveResource;
import org.eclipse.jst.jee.archive.internal.ArchiveFactoryImpl;
import org.eclipse.jst.jee.archive.internal.ArchiveImpl;
import org.eclipse.jst.jee.archive.internal.ArchiveUtil;
import org.eclipse.jst.jee.util.internal.JavaEEQuickPeek;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class JavaEEArchiveUtilities
extends ArchiveFactoryImpl
implements IArchiveFactory {
    public static JavaEEArchiveUtilities INSTANCE = new JavaEEArchiveUtilities();
    public static final String DOT_JAVA = ".java";
    public static final String DOT_CLASS = ".class";
    private Map<IArchive, JavaEEQuickPeek> archiveToJavaEEQuickPeek = new WeakHashMap<IArchive, JavaEEQuickPeek>();

    private JavaEEArchiveUtilities() {
    }

    public static boolean isJava(IFile iFile) {
        return JavaEEArchiveUtilities.hasExtension(iFile, DOT_JAVA);
    }

    public static boolean isClass(IFile iFile) {
        return JavaEEArchiveUtilities.hasExtension(iFile, DOT_CLASS);
    }

    public static boolean hasExtension(IFile iFile, String ext) {
        String name = iFile.getName();
        return JavaEEArchiveUtilities.hasExtension(name, ext);
    }

    public static boolean hasExtension(String name, String ext) {
        int offset = ext.length();
        return name.regionMatches(true, name.length() - offset, ext, 0, offset);
    }

    public IArchive openArchive(IVirtualComponent virtualComponent) throws ArchiveOpenFailureException {
        if (virtualComponent.isBinary()) {
            VirtualArchiveComponent archiveComponent = (VirtualArchiveComponent)virtualComponent;
            File diskFile = null;
            diskFile = archiveComponent.getUnderlyingDiskFile();
            if (!diskFile.exists()) {
                IFile wbFile = archiveComponent.getUnderlyingWorkbenchFile();
                diskFile = new File(wbFile.getLocation().toOSString());
            }
            Path path = new Path(diskFile.getAbsolutePath());
            return this.openArchive((IPath)path);
        }
        int type = -1;
        ComponentArchiveLoadAdapter archiveLoadAdapter = null;
        if (J2EEProjectUtilities.isEARProject(virtualComponent.getProject())) {
            archiveLoadAdapter = new EARComponentArchiveLoadAdapter(virtualComponent);
            type = 1;
        } else if (J2EEProjectUtilities.isEJBComponent(virtualComponent)) {
            archiveLoadAdapter = new EJBComponentArchiveLoadAdapter(virtualComponent);
            type = 0;
        } else if (J2EEProjectUtilities.isApplicationClientComponent(virtualComponent)) {
            archiveLoadAdapter = new AppClientComponentArchiveLoadAdapter(virtualComponent);
            type = 3;
        } else if (J2EEProjectUtilities.isJCAComponent(virtualComponent)) {
            archiveLoadAdapter = new ConnectorComponentArchiveLoadAdapter(virtualComponent);
            type = 2;
        } else if (J2EEProjectUtilities.isDynamicWebComponent(virtualComponent)) {
            archiveLoadAdapter = new WebComponentArchiveLoadAdapter(virtualComponent);
            type = 4;
        } else if (J2EEProjectUtilities.isUtilityProject(virtualComponent.getProject())) {
            archiveLoadAdapter = new JavaComponentArchiveLoadAdapter(virtualComponent);
        }
        if (archiveLoadAdapter != null) {
            ArchiveOptions options = new ArchiveOptions();
            options.setOption((Object)"LOAD_ADAPTER", (Object)archiveLoadAdapter);
            IArchive archive = super.openArchive(options);
            if (type != -1) {
                int version = -1;
                String versionStr = J2EEProjectUtilities.getJ2EEProjectVersion(virtualComponent.getProject());
                switch (type) {
                    case 1: 
                    case 3: {
                        if (versionStr.equals("1.2")) {
                            version = 12;
                            break;
                        }
                        if (versionStr.equals("1.3")) {
                            version = 13;
                            break;
                        }
                        if (versionStr.equals("1.4")) {
                            version = 14;
                            break;
                        }
                        if (!versionStr.equals("5.0")) break;
                        version = 50;
                        break;
                    }
                    case 2: {
                        if (versionStr.equals("1.0")) {
                            version = 10;
                            break;
                        }
                        if (!versionStr.equals("1.5")) break;
                        version = 15;
                        break;
                    }
                    case 0: {
                        if (versionStr.equals("1.1")) {
                            version = 11;
                            break;
                        }
                        if (versionStr.equals("2.0")) {
                            version = 20;
                            break;
                        }
                        if (versionStr.equals("2.1")) {
                            version = 21;
                            break;
                        }
                        if (!versionStr.equals("3.0")) break;
                        version = 30;
                        break;
                    }
                    case 4: {
                        if (versionStr.equals("2.2")) {
                            version = 22;
                            break;
                        }
                        if (versionStr.equals("2.3")) {
                            version = 23;
                            break;
                        }
                        if (versionStr.equals("2.4")) {
                            version = 24;
                            break;
                        }
                        if (!versionStr.equals("2.5")) break;
                        version = 25;
                    }
                }
                if (version != -1) {
                    this.archiveToJavaEEQuickPeek.put(archive, new JavaEEQuickPeek(type, version));
                }
            }
            return archive;
        }
        return null;
    }

    public JavaEEQuickPeek getJavaEEQuickPeek(IArchive archive) {
        if (this.archiveToJavaEEQuickPeek.containsKey(archive)) {
            return this.archiveToJavaEEQuickPeek.get(archive);
        }
        String[] deploymentDescriptorsToCheck = new String[]{"META-INF/application.xml", "META-INF/application-client.xml", "META-INF/ejb-jar.xml", "WEB-INF/web.xml", "META-INF/ra.xml"};
        int i = 0;
        while (i < deploymentDescriptorsToCheck.length) {
            Path deploymentDescriptorPath = new Path(deploymentDescriptorsToCheck[i]);
            if (archive.containsArchiveResource((IPath)deploymentDescriptorPath)) {
                InputStream in = null;
                try {
                    IArchiveResource dd = archive.getArchiveResource((IPath)deploymentDescriptorPath);
                    in = dd.getInputStream();
                    JavaEEQuickPeek quickPeek = new JavaEEQuickPeek(in);
                    this.archiveToJavaEEQuickPeek.put(archive, quickPeek);
                    return quickPeek;
                }
                catch (FileNotFoundException e) {
                    ArchiveUtil.warn((Throwable)e);
                }
                catch (IOException e) {
                    ArchiveUtil.warn((Throwable)e);
                }
            }
            ++i;
        }
        JavaEEQuickPeek quickPeek = new JavaEEQuickPeek(null);
        this.archiveToJavaEEQuickPeek.put(archive, quickPeek);
        return quickPeek;
    }

    public IArchive openArchive(ArchiveOptions archiveOptions) throws ArchiveOpenFailureException {
        IArchive simpleArchive = super.openArchive(archiveOptions);
        return this.refineForJavaEE(simpleArchive);
    }

    private IArchive refineForJavaEE(IArchive simpleArchive) {
        String[] deploymentDescriptorsToCheck = new String[]{"META-INF/application.xml", "META-INF/application-client.xml", "META-INF/ejb-jar.xml", "WEB-INF/web.xml", "META-INF/ra.xml"};
        int[] nArray = new int[5];
        nArray[0] = 1;
        nArray[1] = 3;
        nArray[3] = 4;
        nArray[4] = 2;
        int[] typeToVerify = nArray;
        int i = 0;
        while (i < deploymentDescriptorsToCheck.length) {
            Path deploymentDescriptorPath = new Path(deploymentDescriptorsToCheck[i]);
            if (simpleArchive.containsArchiveResource((IPath)deploymentDescriptorPath)) {
                InputStream in = null;
                try {
                    IArchiveResource dd = simpleArchive.getArchiveResource((IPath)deploymentDescriptorPath);
                    in = dd.getInputStream();
                    JavaEEQuickPeek quickPeek = new JavaEEQuickPeek(in);
                    if (quickPeek.getType() == typeToVerify[i] && quickPeek.getVersion() != -1 && !simpleArchive.containsModelObject((IPath)deploymentDescriptorPath)) {
                        final IArchiveLoadAdapter simpleLoadAdapter = simpleArchive.getLoadAdapter();
                        IArchiveLoadAdapter wrappingEMFLoadAdapter = new IArchiveLoadAdapter(simpleArchive, (IPath)deploymentDescriptorPath){
                            private JavaEEEMFArchiveAdapterHelper emfHelper;
                            private final /* synthetic */ IPath val$deploymentDescriptorPath;
                            {
                                this.val$deploymentDescriptorPath = iPath;
                                this.emfHelper = new JavaEEEMFArchiveAdapterHelper(iArchive);
                            }

                            public void close() {
                                simpleLoadAdapter.close();
                            }

                            public boolean containsArchiveResource(IPath resourcePath) {
                                return simpleLoadAdapter.containsArchiveResource(resourcePath);
                            }

                            public boolean containsModelObject(IPath modelObjectPath) {
                                if (simpleLoadAdapter.containsArchiveResource(modelObjectPath)) {
                                    return true;
                                }
                                if (IArchive.EMPTY_MODEL_PATH == modelObjectPath) {
                                    modelObjectPath = this.val$deploymentDescriptorPath;
                                }
                                return this.emfHelper.containsModelObject(modelObjectPath);
                            }

                            public IArchiveResource getArchiveResource(IPath resourcePath) throws FileNotFoundException {
                                return simpleLoadAdapter.getArchiveResource(resourcePath);
                            }

                            public List<IArchiveResource> getArchiveResources() {
                                return simpleLoadAdapter.getArchiveResources();
                            }

                            public InputStream getInputStream(IArchiveResource archiveResource) throws IOException, FileNotFoundException {
                                return simpleLoadAdapter.getInputStream(archiveResource);
                            }

                            public Object getModelObject(IPath modelObjectPath) throws ArchiveModelLoadException {
                                if (simpleLoadAdapter.containsModelObject(modelObjectPath)) {
                                    return simpleLoadAdapter.getModelObject(modelObjectPath);
                                }
                                if (IArchive.EMPTY_MODEL_PATH == modelObjectPath) {
                                    modelObjectPath = this.val$deploymentDescriptorPath;
                                }
                                return this.emfHelper.getModelObject(modelObjectPath);
                            }

                            public IArchive getArchive() {
                                return simpleLoadAdapter.getArchive();
                            }

                            public void setArchive(IArchive archive) {
                                simpleLoadAdapter.setArchive(archive);
                            }

                            public String toString() {
                                StringBuffer buffer = new StringBuffer(JavaEEArchiveUtilities.class.getName());
                                buffer.append(" wrapping: ");
                                buffer.append(simpleLoadAdapter.toString());
                                return buffer.toString();
                            }
                        };
                        simpleArchive.getArchiveOptions().setOption((Object)"LOAD_ADAPTER", (Object)wrappingEMFLoadAdapter);
                        ((ArchiveImpl)simpleArchive).setLoadAdapter(wrappingEMFLoadAdapter);
                        IArchive iArchive = simpleArchive;
                        return iArchive;
                    }
                }
                catch (FileNotFoundException e) {
                    ArchiveUtil.warn((Throwable)e);
                }
                catch (IOException e) {
                    ArchiveUtil.warn((Throwable)e);
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            ArchiveUtil.warn((Throwable)e);
                        }
                    }
                }
            }
            ++i;
        }
        return simpleArchive;
    }
}

