/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.model;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.php.internal.core.project.IIncludePathEntry;
import org.eclipse.php.internal.core.project.options.PHPProjectOptions;
import org.eclipse.php.internal.debug.core.model.PHPLineBreakpoint;
import org.eclipse.php.internal.debug.core.model.PHPRunToLineBreakpoint;
import org.eclipse.php.internal.debug.core.zend.debugger.RemoteDebugger;

public class BreakpointSet {
    private IProject fProject;
    private ArrayList fDirectories;
    private ArrayList fProjects;

    public BreakpointSet(IProject iProject, boolean bl) {
        IIncludePathEntry[] iIncludePathEntryArray;
        this.fProject = iProject;
        this.fDirectories = new ArrayList();
        this.fProjects = new ArrayList();
        PHPProjectOptions pHPProjectOptions = PHPProjectOptions.forProject((IProject)iProject);
        if (pHPProjectOptions != null && (iIncludePathEntryArray = pHPProjectOptions.readRawIncludePath()) != null) {
            int n = 0;
            while (n < iIncludePathEntryArray.length) {
                File file;
                Object object;
                IPath iPath;
                if (iIncludePathEntryArray[n].getEntryKind() == 1) {
                    iPath = iIncludePathEntryArray[n].getPath();
                    object = new File(iPath.toString());
                    this.fDirectories.add(RemoteDebugger.convertToSystemIndependentFileName(((File)object).getAbsolutePath()));
                } else if (iIncludePathEntryArray[n].getEntryKind() == 2) {
                    iPath = iIncludePathEntryArray[n].getResource();
                    if (iPath instanceof IProject) {
                        this.fProjects.add(iPath);
                    }
                } else if (iIncludePathEntryArray[n].getEntryKind() == 4 && (file = this.getVariableFile((String)(object = (iPath = iIncludePathEntryArray[n].getPath()).toString()))) != null && file.isDirectory()) {
                    this.fDirectories.add(RemoteDebugger.convertToSystemIndependentFileName(file.getAbsolutePath()));
                }
                ++n;
            }
        }
    }

    public boolean supportsBreakpoint(IBreakpoint iBreakpoint) {
        if (this.fProject == null) {
            return true;
        }
        PHPLineBreakpoint pHPLineBreakpoint = (PHPLineBreakpoint)iBreakpoint;
        IMarker iMarker = pHPLineBreakpoint.getMarker();
        IResource iResource = null;
        if (iBreakpoint instanceof PHPRunToLineBreakpoint) {
            return true;
        }
        iResource = iMarker.getResource();
        if (iResource instanceof IWorkspaceRoot) {
            String string;
            String string2 = iMarker.getAttribute("org.eclipse.php.debug.core.Storage_Type", "");
            if (string2.equals("org.eclipse.php.debug.core.Include") && !"".equals(string = iMarker.getAttribute("org.eclipse.php.debug.core.Include_Path_Basedir", ""))) {
                Object[] objectArray = this.fDirectories.toArray();
                int n = 0;
                while (n < objectArray.length) {
                    if (string.equals((String)objectArray[n])) {
                        return true;
                    }
                    ++n;
                }
                return false;
            }
            return true;
        }
        IProject iProject = iResource.getProject();
        if (this.fProject.equals((Object)iProject)) {
            return true;
        }
        return this.fProjects.contains(iProject);
    }

    private File getVariableFile(String string) {
        IPath iPath;
        int n = string.indexOf(47);
        String string2 = "";
        if (n != -1) {
            if (n + 1 < string.length()) {
                string2 = string.substring(n + 1);
            }
            string = string.substring(0, n);
        }
        if ((iPath = PHPProjectOptions.getIncludePathVariable((String)string)) == null) {
            return null;
        }
        iPath = iPath.append(string2);
        return iPath.toFile();
    }
}

