/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp.session;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpLogger;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.session.DBGpSession;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.session.DBGpSessionListener;

public class DBGpSessionHandler {
    public static final String IDEKEY_PREFIX = "ECLIPSE_DBGP";
    private static DBGpSessionHandler globalSessionHandler;
    private static Object sessionHandlerCreator;
    private ListenerList listeners = new ListenerList();
    private int sessionCount = 0;
    private Object sessionCountMonitor = new Object();
    private int fTimeout;

    static {
        sessionHandlerCreator = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBGpSessionHandler getInstance() {
        Object object = sessionHandlerCreator;
        synchronized (object) {
            if (globalSessionHandler == null) {
                globalSessionHandler = new DBGpSessionHandler();
            }
        }
        return globalSessionHandler;
    }

    public boolean isCorrectSession(DBGpSession dBGpSession, DBGpTarget dBGpTarget) {
        boolean bl = false;
        if (dBGpSession.getIdeKey().equals(dBGpTarget.getIdeKey())) {
            if (dBGpSession.getSessionId() != null) {
                if (dBGpSession.getSessionId().equals(dBGpTarget.getSessionID())) {
                    bl = true;
                }
            } else if (dBGpTarget.getSessionID() == null) {
                bl = true;
            }
        }
        if (DBGpLogger.debugSession()) {
            DBGpLogger.debug("session test:" + dBGpSession.getIdeKey() + "=" + dBGpTarget.getIdeKey() + ", " + dBGpSession.getSessionId() + "=" + dBGpTarget.getSessionID() + " == " + bl);
        }
        return bl;
    }

    public String getIDEKey() {
        return IDEKEY_PREFIX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateSessionId() {
        long l = System.currentTimeMillis();
        StringBuffer stringBuffer = new StringBuffer(Long.toString(l));
        Object object = this.sessionCountMonitor;
        synchronized (object) {
            ++this.sessionCount;
            stringBuffer.append(this.sessionCount);
        }
        return stringBuffer.toString();
    }

    public synchronized void addSessionListener(DBGpSessionListener dBGpSessionListener) {
        this.listeners.add((Object)dBGpSessionListener);
    }

    public void removeSessionListener(DBGpSessionListener dBGpSessionListener) {
        this.listeners.remove((Object)dBGpSessionListener);
    }

    public synchronized boolean fireSessionAdded(DBGpSession dBGpSession) {
        boolean bl = false;
        Object[] objectArray = this.listeners.getListeners();
        if (DBGpLogger.debugSession()) {
            DBGpLogger.debug("firing to " + objectArray.length + " active debug targets");
        }
        int n = 0;
        while (n < objectArray.length && !bl) {
            DBGpSessionListener dBGpSessionListener = (DBGpSessionListener)objectArray[n];
            bl = dBGpSessionListener.SessionCreated(dBGpSession);
            ++n;
        }
        return bl;
    }
}

