/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.plan.internal.preference;

import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.datatools.sqltools.common.ui.preferences.AbstractDBPreferenceFieldPage;
import org.eclipse.datatools.sqltools.plan.internal.PlanViewPlugin;
import org.eclipse.datatools.sqltools.plan.internal.preference.Messages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;

public class ExecutionPlanPage
extends AbstractDBPreferenceFieldPage {
    private Group _planViewOrientation;
    private Button _verticalLayout;
    private Button _horizontalLayout;
    private Button _defaultEncoding = null;
    private Button _otherEncoding = null;
    private Combo _fileEncoding = null;

    public String getPreferencePageId() {
        return "org.eclipse.datatools.sqltools.plan.executionPlanPage";
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(PlanViewPlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        comp.setLayout((Layout)layout);
        Composite global = new Composite(comp, 0);
        global.setLayoutData((Object)new GridData(768));
        global.setLayout((Layout)new GridLayout());
        this._planViewOrientation = new Group(global, 0);
        this._planViewOrientation.setText(Messages.getString("ExecutionPlanPage.orientation.group.name"));
        this._planViewOrientation.setLayoutData((Object)new GridData(768));
        this._planViewOrientation.setLayout((Layout)new GridLayout());
        this._verticalLayout = new Button((Composite)this._planViewOrientation, 16);
        this._verticalLayout.setText(Messages.getString("ExecutionPlanPage.vertical.orientation"));
        this._verticalLayout.setLayoutData((Object)new GridData(768));
        this._horizontalLayout = new Button((Composite)this._planViewOrientation, 16);
        this._horizontalLayout.setText(Messages.getString("ExecutionPlanPage.horizontal.orientation"));
        this._horizontalLayout.setLayoutData((Object)new GridData(768));
        this.createEncodingGroup(global);
        Composite tabs = new Composite(comp, 0);
        tabs.setLayoutData((Object)new GridData(1808));
        tabs.setLayout((Layout)layout);
        super.createContents(tabs);
        return comp;
    }

    protected void initializeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        this._verticalLayout.setSelection(store.getBoolean("org.eclipse.datatools.sqltools.plan.preferences.VerticalLayoutPlanView"));
        this._horizontalLayout.setSelection(store.getBoolean("org.eclipse.datatools.sqltools.plan.preferences.HorizontalLayoutPlanView"));
        this._otherEncoding.setSelection(store.getBoolean("org.eclipse.datatools.sqltools.plan.preferences.exportformat.other"));
        this._fileEncoding.select(store.getInt("org.eclipse.datatools.sqltools.plan.preferences.exportformat.other.selection"));
        this._defaultEncoding.setSelection(store.getBoolean("org.eclipse.datatools.sqltools.plan.preferences.exportformat.defalut"));
        boolean enabled = this._defaultEncoding.getSelection();
        this._fileEncoding.setEnabled(!enabled);
        super.initializeValues();
    }

    protected void performDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        this._verticalLayout.setSelection(store.getDefaultBoolean("org.eclipse.datatools.sqltools.plan.preferences.VerticalLayoutPlanView"));
        this._horizontalLayout.setSelection(store.getDefaultBoolean("org.eclipse.datatools.sqltools.plan.preferences.HorizontalLayoutPlanView"));
        this._defaultEncoding.setSelection(store.getDefaultBoolean("org.eclipse.datatools.sqltools.plan.preferences.exportformat.defalut"));
        this._otherEncoding.setSelection(store.getDefaultBoolean("org.eclipse.datatools.sqltools.plan.preferences.exportformat.other"));
        this._fileEncoding.select(store.getDefaultInt("org.eclipse.datatools.sqltools.plan.preferences.exportformat.other.selection"));
        boolean enabled = this._defaultEncoding.getSelection();
        this._fileEncoding.setEnabled(!enabled);
        super.performDefaults();
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("org.eclipse.datatools.sqltools.plan.preferences.VerticalLayoutPlanView", this._verticalLayout.getSelection());
        store.setValue("org.eclipse.datatools.sqltools.plan.preferences.HorizontalLayoutPlanView", this._horizontalLayout.getSelection());
        store.setValue("org.eclipse.datatools.sqltools.plan.preferences.exportformat.defalut", this._defaultEncoding.getSelection());
        store.setValue("org.eclipse.datatools.sqltools.plan.preferences.exportformat.other", this._otherEncoding.getSelection());
        store.setValue("org.eclipse.datatools.sqltools.plan.preferences.exportformat.other.selection", this._fileEncoding.getSelectionIndex());
        store.setValue("org.eclipse.datatools.sqltools.plan.preferences.exportformat.pref_encoding", this._fileEncoding.getText());
        if (this._defaultEncoding.getSelection()) {
            store.setValue("org.eclipse.datatools.sqltools.plan.preferences.exportformat.pref_encoding", System.getProperty("file.encoding", "UTF-8"));
        }
        return super.performOk();
    }

    private void createEncodingGroup(Composite parent) {
        String enc;
        boolean isDefault;
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        GridData data = new GridData(768);
        group.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setText(Messages.getString("ExecutionPlanPage.export.group"));
        group.setFont(font);
        SelectionAdapter buttonListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExecutionPlanPage.this.updateEncodingState(ExecutionPlanPage.this._defaultEncoding.getSelection());
            }
        };
        this._defaultEncoding = new Button((Composite)group, 16);
        String defaultEnc = System.getProperty("file.encoding", "UTF-8");
        this._defaultEncoding.setText(MessageFormat.format(Messages.getString("ExecutionPlanPage.default.enc"), defaultEnc));
        data = new GridData();
        data.horizontalSpan = 2;
        this._defaultEncoding.setLayoutData((Object)data);
        this._defaultEncoding.addSelectionListener((SelectionListener)buttonListener);
        this._defaultEncoding.setFont(font);
        this._otherEncoding = new Button((Composite)group, 16);
        this._otherEncoding.setText(Messages.getString("ExecutionPlanPage.other.enc"));
        this._otherEncoding.addSelectionListener((SelectionListener)buttonListener);
        this._otherEncoding.setFont(font);
        this._fileEncoding = new Combo((Composite)group, 0);
        data = new GridData();
        data.widthHint = this.convertWidthInCharsToPixels(15);
        this._fileEncoding.setFont(font);
        this._fileEncoding.setLayoutData((Object)data);
        this._fileEncoding.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExecutionPlanPage.this.updateValidState();
            }
        });
        ArrayList<String> encodings = new ArrayList<String>();
        int n = 0;
        try {
            n = Integer.parseInt(Messages.getString("ExportFormatPage.fileencoding.numDefaultEncodings"));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        for (int i = 0; i < n; ++i) {
            String enc2 = Messages.getString("ExportFormatPage.fileencoding.defaultEncoding" + (i + 1));
            if (enc2 == null) continue;
            encodings.add(enc2);
        }
        if (!encodings.contains(defaultEnc)) {
            encodings.add(defaultEnc);
        }
        boolean bl = isDefault = (enc = this.getPreferenceStore().getString("org.eclipse.datatools.sqltools.plan.preferences.exportformat.pref_encoding")) == null || enc.length() == 0;
        if (!isDefault && !encodings.contains(enc)) {
            encodings.add(enc);
        }
        Collections.sort(encodings);
        for (int i = 0; i < encodings.size(); ++i) {
            this._fileEncoding.add((String)encodings.get(i));
        }
        this._fileEncoding.setText(isDefault ? defaultEnc : enc);
        this.updateEncodingState(isDefault);
    }

    private void updateEncodingState(boolean useDefault) {
        this._defaultEncoding.setSelection(useDefault);
        this._otherEncoding.setSelection(!useDefault);
        this._fileEncoding.setEnabled(!useDefault);
    }

    private void updateValidState() {
        if (!this.isEncodingValid()) {
            this.setErrorMessage(Messages.getString("ExportFormatPage.fileencoding.unsupportedEncoding"));
            this.setValid(false);
        } else {
            this.setErrorMessage(null);
            this.setValid(true);
        }
    }

    private boolean isEncodingValid() {
        return this._defaultEncoding.getSelection() || this.isValidEncoding(this._fileEncoding.getText());
    }

    private boolean isValidEncoding(String enc) {
        try {
            new String(new byte[0], enc);
            return true;
        }
        catch (UnsupportedEncodingException e) {
            return false;
        }
    }
}

