/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.internal.core.documentModel.parser.regions.PhpScriptRegion;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPBlock;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPDocBlock;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.core.phpModel.phpElementData.UserData;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.editor.util.PHPDocBlockSerialezer;
import org.eclipse.php.internal.ui.editor.util.PHPDocTool;
import org.eclipse.php.internal.ui.util.EditorUtility;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public class AddDescriptionAction
implements IObjectActionDelegate {
    private PHPCodeData[] phpCodeData;

    public void setActivePart(IAction iAction, IWorkbenchPart iWorkbenchPart) {
    }

    public void run(IAction iAction) {
        if (this.phpCodeData == null) {
            return;
        }
        int n = 0;
        while (n < this.phpCodeData.length) {
            IEditorPart iEditorPart;
            PHPCodeData pHPCodeData = this.phpCodeData[n];
            UserData userData = pHPCodeData.getUserData();
            String string = userData.getFileName();
            IFile iFile = PHPUiPlugin.getWorkspace().getRoot().getFile((IPath)new Path(string));
            try {
                iEditorPart = EditorUtility.openInEditor(iFile, true);
            }
            catch (PartInitException partInitException) {
                Logger.logException(partInitException);
                return;
            }
            PHPStructuredEditor pHPStructuredEditor = EditorUtility.getPHPStructuredEditor((IWorkbenchPart)iEditorPart);
            IEditorInput iEditorInput = iEditorPart.getEditorInput();
            IDocument iDocument = pHPStructuredEditor.getDocumentProvider().getDocument((Object)iEditorInput);
            if (pHPCodeData instanceof PHPFileData) {
                this.handleFileDocBlock((PHPFileData)pHPCodeData, (IStructuredDocument)iDocument);
            }
            PHPDocBlock pHPDocBlock = PHPDocTool.createPhpDoc((CodeData)pHPCodeData);
            int n2 = this.getCodeDataOffset(pHPCodeData);
            String string2 = this.insertDocBlock((CodeData)pHPCodeData, (IStructuredDocument)iDocument, n2);
            if (string2 == null) {
                return;
            }
            String string3 = pHPDocBlock.getShortDescription();
            int n3 = string2.indexOf(string3);
            int n4 = n2 + n3;
            EditorUtility.revealInEditor((IEditorPart)pHPStructuredEditor, n4, string3.length());
            ++n;
        }
    }

    private int getCodeDataOffset(PHPCodeData pHPCodeData) {
        if (pHPCodeData instanceof PHPFileData) {
            PHPBlock[] pHPBlockArray = ((PHPFileData)pHPCodeData).getPHPBlocks();
            return pHPBlockArray.length > 0 ? pHPBlockArray[0].getPHPStartTag().getEndPosition() : -1;
        }
        int n = pHPCodeData.getUserData().getStartPosition();
        return n;
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        if (iSelection == null || !(iSelection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
        this.phpCodeData = new PHPCodeData[iStructuredSelection.size()];
        Iterator iterator = iStructuredSelection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            this.phpCodeData[n++] = (PHPCodeData)iterator.next();
        }
    }

    private void handleFileDocBlock(PHPFileData pHPFileData, IStructuredDocument iStructuredDocument) {
        ITextRegion iTextRegion;
        IStructuredDocumentRegion iStructuredDocumentRegion = iStructuredDocument.getFirstStructuredDocumentRegion();
        PhpScriptRegion phpScriptRegion = null;
        while (iStructuredDocumentRegion != null) {
            iTextRegion = iStructuredDocumentRegion.getFirstRegion();
            if (iTextRegion.getType() == "PHP_OPEN" && (iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(iTextRegion.getEnd())) != null && iTextRegion.getType() == "PHP_CONTENT") {
                phpScriptRegion = (PhpScriptRegion)iTextRegion;
                break;
            }
            iStructuredDocumentRegion = iStructuredDocumentRegion.getNext();
        }
        if (phpScriptRegion != null) {
            try {
                iTextRegion = phpScriptRegion.getPhpToken(0);
                int n = iTextRegion.getStart() + iStructuredDocumentRegion.getStartOffset() + phpScriptRegion.getStart();
                if (iTextRegion.getType() == "PHP_CLASS") {
                    this.addClassBlock(iStructuredDocument, pHPFileData, n);
                } else if (iTextRegion.getType() == "PHP_FUNCTION") {
                    this.addFunctionBlock(iStructuredDocument, pHPFileData, n);
                } else if (iTextRegion.getType() == "PHP_STRING" && iStructuredDocument.get(n, iTextRegion.getLength()).trim().equalsIgnoreCase("define")) {
                    this.addConstantBlock(iStructuredDocument, pHPFileData, n);
                }
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    private void addConstantBlock(IStructuredDocument iStructuredDocument, PHPFileData pHPFileData, int n) {
        PHPConstantData[] pHPConstantDataArray = pHPFileData.getConstants();
        if (pHPConstantDataArray.length > 0 && pHPConstantDataArray[0].getUserData().getStartPosition() == n) {
            this.insertDocBlock((CodeData)pHPConstantDataArray[0], iStructuredDocument, n);
        }
    }

    private void addFunctionBlock(IStructuredDocument iStructuredDocument, PHPFileData pHPFileData, int n) {
        PHPFunctionData[] pHPFunctionDataArray = pHPFileData.getFunctions();
        if (pHPFunctionDataArray.length > 0 && pHPFunctionDataArray[0].getUserData().getStartPosition() == n) {
            this.insertDocBlock((CodeData)pHPFunctionDataArray[0], iStructuredDocument, n);
        }
    }

    private void addClassBlock(IStructuredDocument iStructuredDocument, PHPFileData pHPFileData, int n) {
        PHPClassData[] pHPClassDataArray = pHPFileData.getClasses();
        if (pHPClassDataArray.length > 0 && pHPClassDataArray[0].getUserData().getStartPosition() == n) {
            this.insertDocBlock((CodeData)pHPClassDataArray[0], iStructuredDocument, n);
        }
    }

    private String insertDocBlock(CodeData codeData, IStructuredDocument iStructuredDocument, int n) {
        PHPDocBlock pHPDocBlock = PHPDocTool.createPhpDoc(codeData);
        String string = PHPDocBlockSerialezer.instance().createDocBlockText(iStructuredDocument, pHPDocBlock, n, true);
        try {
            iStructuredDocument.replace(n, 0, string);
        }
        catch (BadLocationException badLocationException) {
            Logger.logException(badLocationException);
            string = null;
        }
        return string;
    }
}

