/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.util.LinkedList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.internal.core.phpModel.parser.IPhpModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPIncludePathModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPIncludePathModelManager;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.project.IIncludePathEntry;
import org.eclipse.php.internal.core.project.options.PHPProjectOptions;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.actions.SelectionDispatchAction;
import org.eclipse.ui.IWorkbenchSite;

public class RemoveFromIncludePathAction
extends SelectionDispatchAction {
    public RemoveFromIncludePathAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        this.setText(PHPUIMessages.RemoveFromIncludePathAction_remove_from_include_path_title);
        this.setToolTipText(PHPUIMessages.RemoveFromIncludePathAction_remove_from_include_path_tooltip);
        this.setDescription(PHPUIMessages.RemoveFromIncludePathAction_remove_from_include_path_desc);
    }

    public void selectionChanged(ITextSelection iTextSelection) {
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        this.setEnabled(this.checkEnabled(iStructuredSelection));
    }

    private boolean checkEnabled(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.isEmpty()) {
            return false;
        }
        Object object = iStructuredSelection.getFirstElement();
        return object instanceof PHPIncludePathModel;
    }

    public void run(IStructuredSelection iStructuredSelection) {
        Object object = iStructuredSelection.getFirstElement();
        if (object instanceof PHPIncludePathModel) {
            Object object2;
            IProject iProject = null;
            final PHPIncludePathModel pHPIncludePathModel = (PHPIncludePathModel)object;
            PHPProjectModel[] pHPProjectModelArray = PHPWorkspaceModelManager.getInstance().listModels();
            int n = 0;
            while (iProject == null && n < pHPProjectModelArray.length) {
                object2 = (PHPIncludePathModelManager)pHPProjectModelArray[n].getModel("CompositeIncludePathModel");
                IPhpModel[] iPhpModelArray = object2.listModels();
                int n2 = 0;
                while (iProject == null && n2 < iPhpModelArray.length) {
                    if (iPhpModelArray[n2] == pHPIncludePathModel) {
                        iProject = PHPWorkspaceModelManager.getInstance().getProjectForModel(pHPProjectModelArray[n]);
                    }
                    ++n2;
                }
                ++n;
            }
            if (iProject != null) {
                final PHPProjectOptions pHPProjectOptions = PHPProjectOptions.forProject(iProject);
                object2 = new WorkspaceJob(PHPUIMessages.RemoveFromIncludePathAction_remove_from_include_path_job){

                    public IStatus runInWorkspace(IProgressMonitor iProgressMonitor) throws CoreException {
                        IIncludePathEntry[] iIncludePathEntryArray = pHPProjectOptions.readRawIncludePath();
                        LinkedList<IIncludePathEntry> linkedList = new LinkedList<IIncludePathEntry>();
                        int n = 0;
                        while (n < iIncludePathEntryArray.length) {
                            if (!iIncludePathEntryArray[n].getPath().equals((Object)new Path(pHPIncludePathModel.getID()))) {
                                linkedList.add(iIncludePathEntryArray[n]);
                            }
                            ++n;
                        }
                        pHPProjectOptions.setRawIncludePath(linkedList.toArray(new IIncludePathEntry[linkedList.size()]), new SubProgressMonitor(iProgressMonitor, 1));
                        return Status.OK_STATUS;
                    }
                };
                object2.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().modifyRule(iProject));
                object2.schedule();
            }
        }
    }
}

