/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.ws.ui.wizards;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSetWizardPage;
import org.eclipse.datatools.enablement.oda.ws.soap.SOAPParameter;
import org.eclipse.datatools.enablement.oda.ws.soap.SOAPRequest;
import org.eclipse.datatools.enablement.oda.ws.ui.i18n.Messages;
import org.eclipse.datatools.enablement.oda.ws.ui.util.WSConsole;
import org.eclipse.datatools.enablement.oda.ws.ui.util.WSUIUtil;
import org.eclipse.datatools.enablement.oda.ws.ui.wizards.SOAPRequestPage;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class SOAPParametersPage
extends DataSetWizardPage {
    private static final String COLUMN_NAME = Messages.getString("parameterInputDialog.column.name");
    private static final String COLUMN_DATATYPE = Messages.getString("parameterInputDialog.column.type");
    private static final String COLUMN_DEFAULTVALUE = Messages.getString("parameterInputDialog.column.defaultValue");
    private CheckboxTableViewer viewer;
    private SOAPRequest soapRequest;
    private String wsQueryText;
    private static String DEFAULT_MESSAGE = Messages.getString("soapParametersPage.message.default");

    public SOAPParametersPage(String pageName) {
        super(pageName);
        this.setMessage(DEFAULT_MESSAGE);
    }

    public void createPageCustomControl(Composite parent) {
        this.setControl(this.createPageControl(parent));
        this.initializeControl();
    }

    private Control createPageControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        GridData layoutData = new GridData(272);
        composite.setLayoutData((Object)layoutData);
        this.setupParametersComposite(composite);
        return composite;
    }

    private void setupParametersComposite(Composite parent) {
        this.createCheckboxTable(parent);
        this.setupEditors();
    }

    private void createCheckboxTable(Composite parent) {
        Table table = new Table(parent, 68386);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        GridData layouData = new GridData(1808);
        table.setLayoutData((Object)layouData);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn column0 = new TableColumn(table, 0);
        column0.setText(COLUMN_NAME);
        column0.setWidth(200);
        TableColumn column1 = new TableColumn(table, 0);
        column1.setText(COLUMN_DATATYPE);
        column1.setWidth(200);
        TableColumn column2 = new TableColumn(table, 0);
        column2.setText(COLUMN_DEFAULTVALUE);
        column2.setWidth(200);
        this.viewer = new CheckboxTableViewer(table);
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement == null || !(inputElement instanceof SOAPParameter[])) {
                    return new Object[0];
                }
                return (SOAPParameter[])inputElement;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                SOAPParameter param = (SOAPParameter)element;
                String value = "";
                switch (columnIndex) {
                    case 0: {
                        value = param.getName();
                        break;
                    }
                    case 1: {
                        value = "";
                        break;
                    }
                    case 2: {
                        value = param.getDefaultValue();
                    }
                }
                return WSUIUtil.getNonNullString((String)value);
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (!event.getChecked() && event.getElement() instanceof SOAPParameter) {
                    ((SOAPParameter)event.getElement()).setDefaultValue("");
                    SOAPParametersPage.this.viewer.refresh();
                }
            }
        });
    }

    private void setupEditors() {
        CellEditor[] editors = new CellEditor[3];
        int i = 0;
        while (i < editors.length) {
            editors[i] = new TextCellEditor((Composite)this.viewer.getTable(), 0);
            ++i;
        }
        this.viewer.setCellEditors(editors);
        this.viewer.setColumnProperties(new String[]{COLUMN_NAME, COLUMN_DATATYPE, COLUMN_DEFAULTVALUE});
        this.viewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return SOAPParametersPage.this.viewer.getChecked(element) && property.equals(COLUMN_DEFAULTVALUE);
            }

            public Object getValue(Object element, String property) {
                return WSUIUtil.getNonNullString((String)((SOAPParameter)element).getDefaultValue());
            }

            public void modify(Object element, String property, Object value) {
                SOAPParameter soapParameter = (SOAPParameter)((TableItem)element).getData();
                soapParameter.setDefaultValue(value.toString());
                SOAPParametersPage.this.viewer.refresh();
            }
        });
    }

    private void initializeControl() {
        this.initWSConsole();
        this.initFromModel();
        this.initViewer();
    }

    private void initWSConsole() {
        if (!WSConsole.getInstance().isSessionOK()) {
            WSConsole.getInstance().start(this.getInitializationDesign());
        }
    }

    private void initFromModel() {
        this.wsQueryText = WSConsole.getInstance().getPropertyValue("wsQueryText");
    }

    private void initViewer() {
        if (WSUIUtil.isNull((Object)this.wsQueryText)) {
            return;
        }
        this.soapRequest = new SOAPRequest(this.wsQueryText);
        SOAPParameter[] soapParameters = this.soapRequest.getParameters();
        if (!WSUIUtil.isNull((Object)soapParameters)) {
            this.viewer.setInput((Object)soapParameters);
            int i = 0;
            while (i < soapParameters.length) {
                this.viewer.setChecked((Object)soapParameters[i], soapParameters[i].isUsed());
                ++i;
            }
        }
    }

    protected DataSetDesign collectDataSetDesign(DataSetDesign design) {
        this.savePage(design);
        return design;
    }

    private void savePage(DataSetDesign dataSetDesign) {
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public IWizardPage getNextPage() {
        this.saveToModel();
        IWizardPage page = super.getNextPage();
        if (page instanceof SOAPRequestPage) {
            ((SOAPRequestPage)page).refresh();
        }
        return page;
    }

    private void saveToModel() {
        WSConsole.getInstance().setPropertyValue("wsQueryText", this.wsQueryText);
        WSConsole.getInstance().setParameters(this.getSOAPParameters());
    }

    private SOAPParameter[] getSOAPParameters() {
        SOAPParameter[] targets = this.soapRequest.getParameters();
        if (WSUIUtil.isNull((Object)targets)) {
            return targets;
        }
        Object[] candidates = this.viewer.getCheckedElements();
        List manipulated = this.getManipulatedIndexList(candidates);
        int i = 0;
        while (i < targets.length) {
            targets[i].setUsed(manipulated.contains(new Integer(targets[i].getId())));
            ++i;
        }
        return targets;
    }

    private List getManipulatedIndexList(Object[] soapParameters) {
        if (WSUIUtil.isNull((Object)soapParameters) || soapParameters.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Integer> manipulated = new ArrayList<Integer>();
        int i = 0;
        while (i < soapParameters.length) {
            manipulated.add(new Integer(((SOAPParameter)soapParameters[i]).getId()));
            ++i;
        }
        return manipulated;
    }

    protected void cleanup() {
        WSConsole.getInstance().terminateSession();
    }

    void refresh() {
        this.wsQueryText = WSConsole.getInstance().getTemplate();
        this.initViewer();
    }
}

