/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jdtutility;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.ExpressionConverter;
import org.eclipse.jpt.core.internal.jdtutility.ExpressionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.ModifiedDeclaration;
import org.eclipse.jpt.core.internal.jdtutility.StringExpressionConverter;
import org.eclipse.jpt.utility.internal.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConversionDeclarationAnnotationElementAdapter<T, E extends Expression>
implements DeclarationAnnotationElementAdapter<T> {
    private final DeclarationAnnotationElementAdapter<E> adapter;
    private final ExpressionConverter<T, E> converter;

    public static ConversionDeclarationAnnotationElementAdapter<String, StringLiteral> forStrings(DeclarationAnnotationAdapter annotationAdapter) {
        return new ConversionDeclarationAnnotationElementAdapter<String, StringLiteral>(annotationAdapter, StringExpressionConverter.instance());
    }

    public ConversionDeclarationAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, ExpressionConverter<T, E> converter) {
        this(new ExpressionDeclarationAnnotationElementAdapter(annotationAdapter), converter);
    }

    public static ConversionDeclarationAnnotationElementAdapter<String, StringLiteral> forStrings(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return new ConversionDeclarationAnnotationElementAdapter<String, StringLiteral>(annotationAdapter, elementName, StringExpressionConverter.instance());
    }

    public ConversionDeclarationAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName, ExpressionConverter<T, E> converter) {
        this(new ExpressionDeclarationAnnotationElementAdapter(annotationAdapter, elementName), converter);
    }

    public static ConversionDeclarationAnnotationElementAdapter<String, StringLiteral> forStrings(DeclarationAnnotationAdapter annotationAdapter, String elementName, boolean removeAnnotationWhenEmpty) {
        return new ConversionDeclarationAnnotationElementAdapter<String, StringLiteral>(annotationAdapter, elementName, removeAnnotationWhenEmpty, StringExpressionConverter.instance());
    }

    public ConversionDeclarationAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName, boolean removeAnnotationWhenEmpty, ExpressionConverter<T, E> converter) {
        this(new ExpressionDeclarationAnnotationElementAdapter(annotationAdapter, elementName, removeAnnotationWhenEmpty), converter);
    }

    public ConversionDeclarationAnnotationElementAdapter(DeclarationAnnotationElementAdapter<E> adapter, ExpressionConverter<T, E> converter) {
        this.adapter = adapter;
        this.converter = converter;
    }

    @Override
    public T getValue(ModifiedDeclaration declaration) {
        return this.converter.convert((Expression)this.adapter.getValue(declaration));
    }

    @Override
    public void setValue(T value, ModifiedDeclaration declaration) {
        this.adapter.setValue(this.converter.convert(value, this.adapter.astNode(declaration).getAST()), declaration);
    }

    @Override
    public Expression expression(ModifiedDeclaration declaration) {
        return this.adapter.expression(declaration);
    }

    @Override
    public ASTNode astNode(ModifiedDeclaration declaration) {
        return this.adapter.astNode(declaration);
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, this.adapter);
    }
}

