/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.project.facet;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.javaee.web.Servlet;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.project.facet.AbstractJSFFacetInstallDelegate;
import org.eclipse.jst.jsf.core.internal.project.facet.JSFUtils12;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class JSFJavaEEFacetInstallDelegate
extends AbstractJSFFacetInstallDelegate {
    protected void createConfigFile(final IProject project, final IProjectFacetVersion fv, IDataModel config, IProgressMonitor monitor) {
        final IPath configPath = this.resolveConfigPath(project, config.getStringProperty("IJSFFacetInstallDataModelProperties.CONFIG_PATH"));
        try {
            if (!configPath.toFile().exists()) {
                IWorkspaceRunnable op = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor_inner) throws CoreException {
                        JSFUtils12.createConfigFile(fv.getVersionString(), configPath);
                        project.refreshLocal(2, monitor_inner);
                    }
                };
                op.run(monitor);
            }
        }
        catch (CoreException e) {
            JSFCorePlugin.log((Exception)((Object)e), "Exception occured while creating faces-config.xml");
        }
    }

    protected void createServletAndModifyWebXML(IProject project, IDataModel config, IProgressMonitor monitor) {
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)project);
        Object webAppObj = provider.getModelObject();
        if (webAppObj == null) {
            JSFCorePlugin.log(4, String.valueOf(project.getName()) + ": unable to configure web module for JavaServer Faces");
            return;
        }
        if (JSFUtils12.isWebApp25(webAppObj)) {
            WebApp webApp = (WebApp)webAppObj;
            provider.modify((Runnable)new UpdateWebXMLFor25(webApp, config), new Path("WEB-INF").append("web.xml"));
        }
    }

    private class UpdateWebXMLFor25
    implements Runnable {
        private WebApp webApp;
        private IDataModel config;

        UpdateWebXMLFor25(WebApp webApp, IDataModel config) {
            this.webApp = webApp;
            this.config = config;
        }

        public void run() {
            Servlet servlet = JSFUtils12.findJSFServlet(this.webApp);
            if (servlet != null) {
                JSFUtils12.removeURLMappings(this.webApp, servlet);
            }
            servlet = JSFUtils12.createOrUpdateServletRef(this.webApp, this.config, servlet);
            List listOfMappings = JSFJavaEEFacetInstallDelegate.this.getServletMappings(this.config);
            JSFUtils12.setUpURLMappings(this.webApp, listOfMappings, servlet);
            JSFUtils12.setupConfigFileContextParamForV2_5(this.webApp, this.config);
        }
    }
}

