/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ui.wizards.BaseWizardPage;
import org.eclipse.datatools.connectivity.ui.PingJob;
import org.eclipse.datatools.enablement.sybase.asa.JDBCASAProfileMessages;
import org.eclipse.datatools.enablement.sybase.asa.NewJDBCASAConnectionProfileWizard;
import org.eclipse.datatools.enablement.sybase.asa.ui.JDBCASAProfileTabs;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class JDBCASAPropertyWizardPage
extends BaseWizardPage {
    private JDBCASAProfileTabs mASAProfileTabs = null;
    private Button mPingButton;
    protected boolean mShowFilterTab = false;
    protected boolean mShowOptionalTab = true;

    public JDBCASAPropertyWizardPage(String pageName) {
        super(pageName);
        this.setTitle(JDBCASAProfileMessages.getString("JDBCASAPropertyWizardPage.title"));
        this.setDescription(JDBCASAProfileMessages.getString("JDBCASAPropertyWizardPage.msg"));
    }

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        content.setLayout((Layout)layout);
        this.mASAProfileTabs = this.createTabs();
        if (this.getWizard() instanceof NewJDBCASAConnectionProfileWizard) {
            NewJDBCASAConnectionProfileWizard ncpw = (NewJDBCASAConnectionProfileWizard)this.getWizard();
            String providerId = ncpw.getProfileProviderID();
            this.mASAProfileTabs.setProviderID(providerId);
        }
        this.mASAProfileTabs.setShowOptionalTab(this.mShowOptionalTab);
        this.mASAProfileTabs.setShowFilterTab(this.mShowFilterTab);
        this.mASAProfileTabs.createControl(content);
        this.mASAProfileTabs.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent arg0) {
                JDBCASAPropertyWizardPage.this.isValid();
            }
        });
        this.mPingButton = new Button(content, 8);
        GridData pingData = new GridData();
        pingData.horizontalSpan = 2;
        pingData.horizontalAlignment = 3;
        this.mPingButton.setLayoutData((Object)pingData);
        this.mPingButton.setText(JDBCASAProfileMessages.getString("JDBCPropertyWizardPage.PingButton"));
        this.mPingButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JDBCASAPropertyWizardPage.this.ping();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.setControl((Control)content);
        if (this.mASAProfileTabs.getDriverCombo().getCombo().getItemCount() == 1) {
            this.mASAProfileTabs.getDriverCombo().getCombo().select(0);
        }
        this.isValid();
    }

    protected JDBCASAProfileTabs createTabs() {
        return new JDBCASAProfileTabs();
    }

    private void ping() {
        ConnectionProfile tempProfile = new ConnectionProfile("tempJDBCForPing", "empty", this.mASAProfileTabs.getProviderID());
        Properties props = new Properties();
        props.setProperty("org.eclipse.datatools.connectivity.driverDefinitionID", this.getDriverID());
        props.setProperty("org.eclipse.datatools.connectivity.db.connectionProperties", this.getDBConnProps());
        props.setProperty("org.eclipse.datatools.connectivity.db.password", this.getDBPWD());
        props.setProperty("org.eclipse.datatools.connectivity.db.username", this.getDBUID());
        props.setProperty("org.eclipse.datatools.connectivity.db.driverClass", this.getDriverClass());
        String driverURL = this.mASAProfileTabs.getURL();
        props.setProperty("org.eclipse.datatools.connectivity.db.URL", driverURL);
        props.setProperty("org.eclipse.datatools.enablement.sybase.catalog", this.getCatalog());
        props.setProperty("org.eclipse.datatools.enablement.sybase.schema", this.getSchema());
        props.setProperty("org.eclipse.datatools.enablement.sybase.spName", this.getProcName());
        props.setProperty("org.eclipse.datatools.enablement.sybase.host", this.getHost());
        props.setProperty("org.eclipse.datatools.enablement.sybase.dbName", this.getDBName());
        props.setProperty("org.eclipse.datatools.enablement.sybase.port", this.getPort());
        tempProfile.setBaseProperties(props);
        PingJob job = new PingJob(this.getShell(), (IConnectionProfile)tempProfile);
        job.schedule();
    }

    public String getDriverClass() {
        return this.mASAProfileTabs.getDriverClass();
    }

    public String getDriverJarList() {
        return this.mASAProfileTabs.getDriverJarList();
    }

    public String getXAConnectString() {
        return this.mASAProfileTabs.getNamedPropertyFromDriverInstance("xaConnectString");
    }

    public String getXAConnectClass() {
        return this.mASAProfileTabs.getNamedPropertyFromDriverInstance("xaConnectClass");
    }

    public String getDriverURL() {
        return this.mASAProfileTabs.getDriverURL();
    }

    public String getDBUID() {
        return this.mASAProfileTabs.getDBUID();
    }

    public String getDBPWD() {
        return this.mASAProfileTabs.getDBPWD();
    }

    public String getDBConnProps() {
        return this.mASAProfileTabs.getDBConnProps();
    }

    public String getURL() {
        return this.mASAProfileTabs.getURL();
    }

    public String getDriverName() {
        return this.mASAProfileTabs.getDriverName();
    }

    public String getDriverID() {
        return this.mASAProfileTabs.getDriverID();
    }

    public String getCatalog() {
        return this.mASAProfileTabs.getCatalog();
    }

    public String getSchema() {
        return this.mASAProfileTabs.getSchema();
    }

    public String getProcName() {
        return this.mASAProfileTabs.getProcName();
    }

    public String getDBName() {
        return this.mASAProfileTabs.getDBName();
    }

    public String getHost() {
        return this.mASAProfileTabs.getHostName();
    }

    public String getPort() {
        return this.mASAProfileTabs.getPortName();
    }

    public List getSummaryData() {
        ArrayList<String[]> data = new ArrayList<String[]>();
        data.add(new String[]{JDBCASAProfileMessages.getString("JDBCASAPropertyWizardPage.summary.driverName.label"), this.getDriverName()});
        data.add(new String[]{JDBCASAProfileMessages.getString("JDBCASAPropertyWizardPage.summary.connProps.label"), this.getDBConnProps()});
        data.add(new String[]{JDBCASAProfileMessages.getString("JDBCASAPropertyWizardPage.summary.host.label"), this.getHost()});
        data.add(new String[]{JDBCASAProfileMessages.getString("JDBCASAPropertyWizardPage.summary.port.label"), this.getPort()});
        data.add(new String[]{JDBCASAProfileMessages.getString("JDBCASAPropertyWizardPage.summary.userName.label"), this.getDBUID()});
        String pwdMask = "";
        if (this.getDBPWD() != null && this.getDBPWD().length() > 0) {
            int i = 0;
            while (i < this.getDBPWD().length()) {
                pwdMask = String.valueOf(pwdMask) + "*";
                ++i;
            }
        }
        data.add(new String[]{JDBCASAProfileMessages.getString("JDBCASAPropertyWizardPage.summary.password.label"), pwdMask});
        data.add(new String[]{JDBCASAProfileMessages.getString("JDBCASAPropertyWizardPage.summary.driverClass.label"), this.getDriverClass()});
        data.add(new String[]{JDBCASAProfileMessages.getString("JDBCASAPropertyWizardPage.summary.catalog.label"), this.getCatalog()});
        data.add(new String[]{JDBCASAProfileMessages.getString("JDBCASAPropertyWizardPage.summary.schema.label"), this.getSchema()});
        data.add(new String[]{JDBCASAProfileMessages.getString("JDBCASAPropertyWizardPage.summary.procedureName.label"), this.getProcName()});
        return data;
    }

    private boolean isValid() {
        super.setErrorMessage(null);
        boolean isValid = this.mASAProfileTabs.isValid();
        if (!isValid) {
            this.setPageComplete(false);
            super.setErrorMessage(this.mASAProfileTabs.getErrorMessage());
            return false;
        }
        this.setPageComplete(true);
        return true;
    }

    public void setErrorMessage(String newMessage) {
        super.setErrorMessage(newMessage);
        this.isValid();
    }

    public boolean getShowFilterTab() {
        return this.mShowFilterTab;
    }

    public void setShowFilterTab(boolean flag) {
        this.mShowFilterTab = flag;
    }

    public boolean getShowOptionalTab() {
        return this.mShowOptionalTab;
    }

    public void setShowOptionalTab(boolean flag) {
        this.mShowOptionalTab = flag;
    }

    public String getVendor() {
        String vendor = "";
        if (this.mASAProfileTabs != null) {
            vendor = this.mASAProfileTabs.getNamedPropertyFromDriverInstance("Vendor");
        }
        return vendor;
    }

    public String getVersion() {
        String version = "";
        if (this.mASAProfileTabs != null) {
            version = this.mASAProfileTabs.getNamedPropertyFromDriverInstance("Version");
        }
        return version;
    }

    public boolean getSaveDBPWD() {
        return this.mASAProfileTabs.getSaveDBPWD();
    }
}

