/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.baseloaders;

import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCTableColumnLoader;
import org.eclipse.datatools.enablement.sybase.asa.JDBCASAPlugin;
import org.eclipse.datatools.enablement.sybase.asa.base.catalog.SybaseASACatalogBaseColumn;
import org.eclipse.datatools.enablement.sybase.asa.base.catalog.SybaseASACatalogBaseIndex;
import org.eclipse.datatools.enablement.sybase.asa.base.catalog.SybaseASACatalogBaseTrigger;
import org.eclipse.datatools.enablement.sybase.asa.catalog.SQLScriptsProvider;
import org.eclipse.datatools.enablement.sybase.asa.catalog.SybaseASACatalogUtils;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseDatabase;
import org.eclipse.datatools.modelbase.sql.constraints.Index;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.emf.common.util.EList;

public abstract class TableASABaseLoader {
    protected ICatalogObject catalogObj;
    protected Table table;
    private SoftReference columnLoaderRef;

    public TableASABaseLoader(Table catalogTable) {
        this.table = catalogTable;
        this.catalogObj = (ICatalogObject)catalogTable;
    }

    public final void loadColumns(EList columnContainmentList) {
        try {
            boolean deliver = this.table.eDeliver();
            this.table.eSetDeliver(false);
            ArrayList existingColumns = new ArrayList(columnContainmentList.size());
            existingColumns.addAll(columnContainmentList);
            this.getColumnLoader().clearColumns((List)columnContainmentList);
            this.getColumnLoader().loadColumns((List)columnContainmentList, existingColumns);
            this.table.eSetDeliver(deliver);
        }
        catch (Exception e) {
            JDBCASAPlugin.getDefault().log(e);
        }
    }

    protected Column createCatalogColumn() {
        return new SybaseASACatalogBaseColumn();
    }

    protected JDBCTableColumnLoader createColumnLoader() {
        return new ASABaseColumnLoader(this.catalogObj);
    }

    private JDBCTableColumnLoader getColumnLoader() {
        if (this.columnLoaderRef == null || this.columnLoaderRef.get() == null) {
            this.columnLoaderRef = new SoftReference<JDBCTableColumnLoader>(this.createColumnLoader());
        }
        return (JDBCTableColumnLoader)this.columnLoaderRef.get();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void loadIndices(EList indexConstainmentList) {
        boolean deliver = this.table.eDeliver();
        this.table.eSetDeliver(false);
        ArrayList existingIndices = new ArrayList(indexConstainmentList.size());
        existingIndices.addAll(indexConstainmentList);
        indexConstainmentList.clear();
        Connection conn = this.catalogObj.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        SybaseASABaseDatabase db = (SybaseASABaseDatabase)this.catalogObj.getCatalogDatabase();
        try {
            try {
                stmt = conn.prepareStatement(SQLScriptsProvider.getQueryTableIndex((Database)db));
                stmt.setString(1, this.table.getSchema().getName());
                stmt.setString(2, this.table.getName());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    String indexName = rs.getString(1);
                    Index index = (Index)SybaseASACatalogUtils.findElement(existingIndices, indexName);
                    if (index == null) {
                        index = this.createCatalogIndex();
                        this.initIndex(index, rs);
                        indexConstainmentList.add((Object)index);
                        continue;
                    }
                    indexConstainmentList.add((Object)index);
                    ((ICatalogObject)index).refresh();
                }
            }
            catch (SQLException e) {
                JDBCASAPlugin.getDefault().log(e);
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
            throw throwable;
        }
        {
            Object var10_13 = null;
        }
        SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
        this.table.eSetDeliver(deliver);
    }

    protected void initIndex(Index index, ResultSet rs) throws SQLException {
        SybaseASABaseDatabase db = (SybaseASABaseDatabase)this.catalogObj.getCatalogDatabase();
        String idxName = rs.getString(1);
        index.setName(idxName);
        boolean isSysGen = false;
        if (db.isBaseOnASA10()) {
            int indexUnique = rs.getInt(2);
            int indexCategory = rs.getInt(3);
            switch (indexCategory) {
                case 1: 
                case 2: {
                    isSysGen = true;
                }
                case 3: {
                    isSysGen = indexUnique == 2;
                }
            }
        } else {
            String strUnique = rs.getString(2);
            isSysGen = strUnique.equals("U");
        }
        index.setSystemGenerated(isSysGen);
    }

    protected Index createCatalogIndex() {
        return new SybaseASACatalogBaseIndex();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void loadTriggers(EList triggerContainmentList) {
        boolean deliver = this.table.eDeliver();
        this.table.eSetDeliver(false);
        ArrayList existingTriggers = new ArrayList(triggerContainmentList.size());
        existingTriggers.addAll(triggerContainmentList);
        triggerContainmentList.clear();
        Connection conn = this.catalogObj.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                stmt = conn.prepareStatement("SELECT TRIM(G.trigger_name) as trigger_name FROM SYS.SYSTRIGGER G JOIN SYS.SYSTABLE T ON T.table_id = G.table_id JOIN SYS.SYSUSERPERMS U ON U.user_id = T.creator WHERE G.foreign_key_id IS NULL AND U.user_name LIKE ? AND T.table_name LIKE ?");
                stmt.setString(1, this.table.getSchema().getName());
                stmt.setString(2, this.table.getName());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    String triggerName = rs.getString(1);
                    Object trigger = (SQLObject)SybaseASACatalogUtils.findElement(existingTriggers, triggerName);
                    if (trigger == null) {
                        trigger = new SybaseASACatalogBaseTrigger();
                        trigger.setName(triggerName);
                        triggerContainmentList.add(trigger);
                        continue;
                    }
                    triggerContainmentList.add(trigger);
                    ((ICatalogObject)trigger).refresh();
                }
            }
            catch (SQLException e) {
                JDBCASAPlugin.getDefault().log(e);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
            throw throwable;
        }
        {
            Object var9_12 = null;
        }
        SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
        this.table.eSetDeliver(deliver);
    }

    protected Trigger createCatalogTrigger() {
        return new SybaseASACatalogBaseTrigger();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void loadTableInfo() {
        boolean deliver = this.table.eDeliver();
        this.table.eSetDeliver(false);
        Connection conn = this.catalogObj.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            try {
                rs = this.createTableInfoResultSet(conn);
                stmt = rs.getStatement();
                while (rs.next()) {
                    this.processTableInfoResultSet(rs);
                }
            }
            catch (SQLException e) {
                JDBCASAPlugin.getDefault().log(e);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
        this.table.eSetDeliver(deliver);
    }

    protected ResultSet createTableInfoResultSet(Connection conn) throws SQLException {
        SybaseASABaseDatabase db = (SybaseASABaseDatabase)this.catalogObj.getCatalogDatabase();
        PreparedStatement stmt = conn.prepareStatement(SQLScriptsProvider.getQueryTableInfo((Database)db));
        stmt.setString(1, this.table.getSchema().getName());
        stmt.setString(2, this.table.getName());
        return stmt.executeQuery();
    }

    protected abstract void processTableInfoResultSet(ResultSet var1) throws SQLException;

    public static class ASABaseColumnLoader
    extends JDBCTableColumnLoader {
        public ASABaseColumnLoader(ICatalogObject catalogObj) {
            super(catalogObj);
        }

        protected ResultSet createResultSet() throws SQLException {
            Table table = this.getTable();
            Schema schema = table.getSchema();
            PreparedStatement stmt = this.getCatalogObject().getConnection().prepareStatement("SELECT DISTINCT C.column_id, TRIM(C.column_name) as 'COLUMN_NAME' FROM SYS.SYSCOLUMN C JOIN SYS.SYSTABLE T ON T.table_id = C.table_id JOIN SYS.SYSUSERPERMS U ON U.user_id = T.creator WHERE U.user_name = ? AND T.table_name = ? ORDER BY C.column_id");
            stmt.setString(1, schema.getName());
            stmt.setString(2, table.getName());
            return stmt.executeQuery();
        }

        protected Column createColumn() {
            return new SybaseASACatalogBaseColumn();
        }

        protected void initialize(Column column, ResultSet rs) throws SQLException {
            column.setName(rs.getString("COLUMN_NAME"));
        }
    }
}

