/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.ui.export.actions;

import org.eclipse.datatools.sqltools.result.IResultSetObject;
import org.eclipse.datatools.sqltools.result.internal.export.TextOutputter;
import org.eclipse.datatools.sqltools.result.internal.utils.Messages;
import org.eclipse.datatools.sqltools.result.model.IResultInstance;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class PrintResultSetAction
extends Action {
    IResultSetObject _result;
    IResultInstance _resultInstance;
    Shell _shell;
    Composite _parent;
    private static final String FONT_STYLE = "Courier New";
    private static final int FONT_SIZE = 10;

    public PrintResultSetAction(IResultSetObject result, Composite parent) {
        super(Messages.ResultSetAction_Title);
        this._shell = parent.getShell();
        this._result = result;
        this._parent = parent;
    }

    public PrintResultSetAction(IResultInstance resultInstance, Composite parent) {
        super(Messages.AllResultSetAction_Title);
        this._shell = parent.getShell();
        this._resultInstance = resultInstance;
        this._parent = parent;
    }

    public void run() {
        PrintDialog pdlg = new PrintDialog(this._shell, 0);
        PrinterData data = pdlg.open();
        if (data != null) {
            Printer printer = new Printer(data);
            StyledText styledText = new StyledText(this._parent, 0);
            styledText.setVisible(false);
            TextOutputter outputter = new TextOutputter();
            String printString = "";
            if (this._result != null) {
                printString = outputter.getPrintString(this._result);
            } else if (this._resultInstance != null) {
                printString = outputter.getPrintString(this._resultInstance);
            } else {
                printer.dispose();
                return;
            }
            FontData fd = new FontData(FONT_STYLE, 10, 0);
            Font font = new Font((Device)styledText.getDisplay(), fd);
            styledText.setFont(font);
            styledText.setText(printString);
            styledText.print(printer).run();
            printer.dispose();
        }
    }
}

