/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.ui.internal.dialogfield;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.jsf.common.ui.JSFUICommonPlugin;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.DialogField;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.IStringButtonAdapter;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.StringButtonDialogField;
import org.eclipse.jst.jsf.common.ui.internal.dialogs.ResourceOnClasspathDialog;
import org.eclipse.swt.widgets.Shell;

public class ClasspathResourceButtonDialogField
extends StringButtonDialogField {
    private IProject _project;
    private static final String[] PROPERTIES_FILES_SUFFIXS = new String[]{"properties"};

    public ClasspathResourceButtonDialogField(IProject project) {
        this(null, project);
        this.setStringButtonAdapter(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                ClasspathResourceButtonDialogField.this.browseButtonPressed();
            }
        });
    }

    public ClasspathResourceButtonDialogField(IStringButtonAdapter adapter, IProject project) {
        super(adapter);
        this._project = project;
    }

    private void browseButtonPressed() {
        String newValue;
        String oldValue;
        Shell shell = this.getShell();
        ResourceOnClasspathDialog dialog = new ResourceOnClasspathDialog(shell, this.getJavaProject());
        dialog.setTitle(JSFUICommonPlugin.getResourceString("DialogField.ResourceButton.SelectFile"));
        dialog.setSuffixs(PROPERTIES_FILES_SUFFIXS);
        if (dialog.open() == 0 && (oldValue = this.getText()) != (newValue = (String)dialog.getResult()[0])) {
            this.setText(newValue);
        }
    }

    private IJavaProject getJavaProject() {
        try {
            if (this._project != null && this._project.hasNature("org.eclipse.jdt.core.javanature")) {
                return JavaCore.create((IProject)this._project);
            }
            return null;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public IProject getProject() {
        return this._project;
    }

    public void setProject(IProject project) {
        this._project = project;
    }
}

