/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.content.java.mappings;

import java.util.Iterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.ITextRange;
import org.eclipse.jpt.core.internal.content.java.mappings.AbstractJavaColumn;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaJoinTable;
import org.eclipse.jpt.core.internal.content.java.mappings.JpaJavaMappingsFactory;
import org.eclipse.jpt.core.internal.content.java.mappings.JpaJavaMappingsPackage;
import org.eclipse.jpt.core.internal.jdtutility.AnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.CombinationIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.IndexedAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.Member;
import org.eclipse.jpt.core.internal.jdtutility.MemberIndexedAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.NestedIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.mappings.IAbstractJoinColumn;
import org.eclipse.jpt.core.internal.mappings.IJoinColumn;
import org.eclipse.jpt.core.internal.platform.DefaultsContext;
import org.eclipse.jpt.db.internal.Column;
import org.eclipse.jpt.db.internal.Table;
import org.eclipse.jpt.utility.internal.Filter;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaJoinColumn
extends AbstractJavaColumn
implements IJoinColumn {
    protected static final String REFERENCED_COLUMN_NAME_EDEFAULT = null;
    protected static final String SPECIFIED_REFERENCED_COLUMN_NAME_EDEFAULT = null;
    protected String specifiedReferencedColumnName = SPECIFIED_REFERENCED_COLUMN_NAME_EDEFAULT;
    protected static final String DEFAULT_REFERENCED_COLUMN_NAME_EDEFAULT = null;
    protected String defaultReferencedColumnName = DEFAULT_REFERENCED_COLUMN_NAME_EDEFAULT;
    private final IndexedAnnotationAdapter annotationAdapter;
    private final DeclarationAnnotationElementAdapter<String> referencedColumnNameDeclarationAdapter;
    private final AnnotationElementAdapter<String> referencedColumnNameAdapter;
    public static final SimpleDeclarationAnnotationAdapter SINGLE_DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.JoinColumn");
    public static final SimpleDeclarationAnnotationAdapter MULTIPLE_DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.JoinColumns");

    protected JavaJoinColumn() {
        throw new UnsupportedOperationException("Use JavaJoinColumn(Owner, Member, IndexedDeclarationAnnotationAdapter) instead");
    }

    protected JavaJoinColumn(IJoinColumn.Owner owner, Member member, IndexedDeclarationAnnotationAdapter daa) {
        super(owner, member, daa);
        this.annotationAdapter = new MemberIndexedAnnotationAdapter(member, daa);
        this.referencedColumnNameDeclarationAdapter = this.buildStringElementAdapter("referencedColumnName");
        this.referencedColumnNameAdapter = this.buildShortCircuitElementAdapter(this.referencedColumnNameDeclarationAdapter);
    }

    @Override
    protected String nameElementName() {
        return "name";
    }

    @Override
    protected String columnDefinitionElementName() {
        return "columnDefinition";
    }

    @Override
    protected String tableElementName() {
        return "table";
    }

    @Override
    protected String uniqueElementName() {
        return "unique";
    }

    @Override
    protected String nullableElementName() {
        return "nullable";
    }

    @Override
    protected String insertableElementName() {
        return "insertable";
    }

    @Override
    protected String updatableElementName() {
        return "updatable";
    }

    @Override
    protected void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        switch (notification.getFeatureID(IAbstractJoinColumn.class)) {
            case 5: {
                this.referencedColumnNameAdapter.setValue((String)notification.getNewValue());
                break;
            }
        }
    }

    @Override
    protected EClass eStaticClass() {
        return JpaJavaMappingsPackage.Literals.JAVA_JOIN_COLUMN;
    }

    @Override
    public String getReferencedColumnName() {
        return this.specifiedReferencedColumnName == null ? this.defaultReferencedColumnName : this.specifiedReferencedColumnName;
    }

    @Override
    public String getSpecifiedReferencedColumnName() {
        return this.specifiedReferencedColumnName;
    }

    @Override
    public void setSpecifiedReferencedColumnName(String newSpecifiedReferencedColumnName) {
        String oldSpecifiedReferencedColumnName = this.specifiedReferencedColumnName;
        this.specifiedReferencedColumnName = newSpecifiedReferencedColumnName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, (Object)oldSpecifiedReferencedColumnName, (Object)this.specifiedReferencedColumnName));
        }
    }

    @Override
    public String getDefaultReferencedColumnName() {
        return this.defaultReferencedColumnName;
    }

    protected void setDefaultReferencedColumnName(String newDefaultReferencedColumnName) {
        String oldDefaultReferencedColumnName = this.defaultReferencedColumnName;
        this.defaultReferencedColumnName = newDefaultReferencedColumnName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, (Object)oldDefaultReferencedColumnName, (Object)newDefaultReferencedColumnName));
        }
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 11: {
                return this.getReferencedColumnName();
            }
            case 12: {
                return this.getSpecifiedReferencedColumnName();
            }
            case 13: {
                return this.getDefaultReferencedColumnName();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 12: {
                this.setSpecifiedReferencedColumnName((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 12: {
                this.setSpecifiedReferencedColumnName(SPECIFIED_REFERENCED_COLUMN_NAME_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 11: {
                return REFERENCED_COLUMN_NAME_EDEFAULT == null ? this.getReferencedColumnName() != null : !REFERENCED_COLUMN_NAME_EDEFAULT.equals(this.getReferencedColumnName());
            }
            case 12: {
                return SPECIFIED_REFERENCED_COLUMN_NAME_EDEFAULT == null ? this.specifiedReferencedColumnName != null : !SPECIFIED_REFERENCED_COLUMN_NAME_EDEFAULT.equals(this.specifiedReferencedColumnName);
            }
            case 13: {
                return DEFAULT_REFERENCED_COLUMN_NAME_EDEFAULT == null ? this.defaultReferencedColumnName != null : !DEFAULT_REFERENCED_COLUMN_NAME_EDEFAULT.equals(this.defaultReferencedColumnName);
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == IAbstractJoinColumn.class) {
            switch (derivedFeatureID) {
                case 11: {
                    return 4;
                }
                case 12: {
                    return 5;
                }
                case 13: {
                    return 6;
                }
            }
            return -1;
        }
        if (baseClass == IJoinColumn.class) {
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    @Override
    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == IAbstractJoinColumn.class) {
            switch (baseFeatureID) {
                case 4: {
                    return 11;
                }
                case 5: {
                    return 12;
                }
                case 6: {
                    return 13;
                }
            }
            return -1;
        }
        if (baseClass == IJoinColumn.class) {
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (specifiedReferencedColumnName: ");
        result.append(this.specifiedReferencedColumnName);
        result.append(", defaultReferencedColumnName: ");
        result.append(this.defaultReferencedColumnName);
        result.append(')');
        return result.toString();
    }

    @Override
    public IJoinColumn.Owner getOwner() {
        return (IJoinColumn.Owner)super.getOwner();
    }

    public Table dbReferencedColumnTable() {
        return this.getOwner().dbReferencedColumnTable();
    }

    @Override
    public Column dbReferencedColumn() {
        Table table = this.dbReferencedColumnTable();
        return table == null ? null : table.columnNamed(this.getReferencedColumnName());
    }

    @Override
    public boolean tableIsAllowed() {
        return this.getOwner().tableIsAllowed();
    }

    public boolean referencedColumnNameTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(this.referencedColumnNameDeclarationAdapter, pos, astRoot);
    }

    private Iterator<String> candidateReferencedColumnNames() {
        Table table = this.getOwner().dbReferencedColumnTable();
        return table != null ? table.columnNames() : EmptyIterator.instance();
    }

    private Iterator<String> candidateReferencedColumnNames(Filter<String> filter) {
        return new FilteringIterator(this.candidateReferencedColumnNames(), filter);
    }

    private Iterator<String> quotedCandidateReferencedColumnNames(Filter<String> filter) {
        return StringTools.quote(this.candidateReferencedColumnNames(filter));
    }

    @Override
    public Iterator<String> connectedCandidateValuesFor(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.connectedCandidateValuesFor(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.referencedColumnNameTouches(pos, astRoot)) {
            return this.quotedCandidateReferencedColumnNames(filter);
        }
        return null;
    }

    @Override
    public boolean isReferencedColumnResolved() {
        return this.dbReferencedColumn() != null;
    }

    @Override
    public ITextRange referencedColumnNameTextRange() {
        return this.elementTextRange(this.referencedColumnNameDeclarationAdapter);
    }

    public Annotation annotation(CompilationUnit astRoot) {
        return this.annotationAdapter.getAnnotation(astRoot);
    }

    @Override
    public void updateFromJava(CompilationUnit astRoot) {
        super.updateFromJava(astRoot);
        this.setSpecifiedReferencedColumnName(this.referencedColumnNameAdapter.getValue(astRoot));
    }

    @Override
    public void refreshDefaults(DefaultsContext defaultsContext) {
        this.setDefaultReferencedColumnName((String)defaultsContext.getDefault("joinColumn.referencedColumnName"));
        this.setDefaultName((String)defaultsContext.getDefault("joinColumn.name"));
        this.setDefaultTable((String)defaultsContext.getDefault("joinColumn.table"));
    }

    void moveAnnotation(int newIndex) {
        this.annotationAdapter.moveAnnotation(newIndex);
    }

    void newAnnotation() {
        this.annotationAdapter.newMarkerAnnotation();
    }

    void removeAnnotation() {
        this.annotationAdapter.removeAnnotation();
    }

    static JavaJoinColumn createSingleRelationshipMappingJoinColumn(IJoinColumn.Owner owner, Member member, int index) {
        return JpaJavaMappingsFactory.eINSTANCE.createJavaJoinColumn(owner, member, JavaJoinColumn.buildSingleRelationshipMappingAnnotationAdapter(index));
    }

    private static IndexedDeclarationAnnotationAdapter buildSingleRelationshipMappingAnnotationAdapter(int index) {
        return new CombinationIndexedDeclarationAnnotationAdapter(SINGLE_DECLARATION_ANNOTATION_ADAPTER, MULTIPLE_DECLARATION_ANNOTATION_ADAPTER, index, "javax.persistence.JoinColumn");
    }

    static JavaJoinColumn createAssociationOverrideJoinColumn(DeclarationAnnotationAdapter associationOverrideAdapter, IJoinColumn.Owner owner, Member member, int index) {
        return JpaJavaMappingsFactory.eINSTANCE.createJavaJoinColumn(owner, member, JavaJoinColumn.buildAssociationOverrideAnnotationAdapter(associationOverrideAdapter, index));
    }

    private static IndexedDeclarationAnnotationAdapter buildAssociationOverrideAnnotationAdapter(DeclarationAnnotationAdapter associationOverrideAdapter, int index) {
        return new NestedIndexedDeclarationAnnotationAdapter(associationOverrideAdapter, "joinColumns", index, "javax.persistence.JoinColumn");
    }

    static JavaJoinColumn createJoinTableJoinColumn(IJoinColumn.Owner owner, Member member, int index) {
        return JpaJavaMappingsFactory.eINSTANCE.createJavaJoinColumn(owner, member, JavaJoinColumn.buildJoinTableAnnotationAdapter(index));
    }

    private static IndexedDeclarationAnnotationAdapter buildJoinTableAnnotationAdapter(int index) {
        return new NestedIndexedDeclarationAnnotationAdapter(JavaJoinTable.DECLARATION_ANNOTATION_ADAPTER, "joinColumns", index, "javax.persistence.JoinColumn");
    }

    static JavaJoinColumn createJoinTableInverseJoinColumn(IJoinColumn.Owner owner, Member member, int index) {
        return JpaJavaMappingsFactory.eINSTANCE.createJavaJoinColumn(owner, member, JavaJoinColumn.buildJoinTableInverseAnnotationAdapter(index));
    }

    private static IndexedDeclarationAnnotationAdapter buildJoinTableInverseAnnotationAdapter(int index) {
        return new NestedIndexedDeclarationAnnotationAdapter(JavaJoinTable.DECLARATION_ANNOTATION_ADAPTER, "inverseJoinColumns", index, "javax.persistence.JoinColumn");
    }
}

