/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor;

import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.php.internal.ui.editor.Symbols;

final class PHPHeuristicScanner
implements Symbols {
    public static final int NOT_FOUND = -1;
    public static final int UNBOUND = -2;
    private static final char LBRACE = '{';
    private static final char RBRACE = '}';
    private static final char LPAREN = '(';
    private static final char RPAREN = ')';
    private static final char SEMICOLON = ';';
    private static final char COLON = ':';
    private static final char COMMA = ',';
    private static final char LBRACKET = '[';
    private static final char RBRACKET = ']';
    private static final char QUESTIONMARK = '?';
    private static final char EQUAL = '=';
    private static final char LANGLE = '<';
    private static final char RANGLE = '>';
    private IDocument fDocument;
    private String fPartitioning;
    private String fPartition;
    private char fChar;
    private int fPos;
    private final StopCondition fNonWSDefaultPart = new NonWhitespaceDefaultPartition();
    private static final StopCondition fNonWS = new NonWhitespace();
    private final StopCondition fNonIdent = new NonJavaIdentifierPartDefaultPartition();

    public PHPHeuristicScanner(IDocument iDocument, String string, String string2) {
        Assert.isNotNull((Object)iDocument);
        Assert.isNotNull((Object)string);
        Assert.isNotNull((Object)string2);
        this.fDocument = iDocument;
        this.fPartitioning = string;
        this.fPartition = string2;
    }

    public PHPHeuristicScanner(IDocument iDocument) {
        this(iDocument, "org.eclipse.wst.sse.core.default_structured_text_partitioning", "__dftl_partition_content_type");
    }

    public int getPosition() {
        return this.fPos;
    }

    public int nextToken(int n, int n2) {
        int n3 = this.scanForward(n, n2, this.fNonWSDefaultPart);
        if (n3 == -1) {
            return -1;
        }
        ++this.fPos;
        switch (this.fChar) {
            case '{': {
                return 1;
            }
            case '}': {
                return 2;
            }
            case '[': {
                return 3;
            }
            case ']': {
                return 4;
            }
            case '(': {
                return 5;
            }
            case ')': {
                return 6;
            }
            case ';': {
                return 7;
            }
            case ',': {
                return 11;
            }
            case '?': {
                return 10;
            }
            case '=': {
                return 12;
            }
            case '<': {
                return 13;
            }
            case '>': {
                return 14;
            }
        }
        if (Character.isJavaIdentifierPart(this.fChar)) {
            String string;
            int n4 = n3;
            int n5 = (n3 = this.scanForward(n3 + 1, n2, this.fNonIdent)) == -1 ? (n2 == -2 ? this.fDocument.getLength() : n2) : n3;
            try {
                string = this.fDocument.get(n4, n5 - n4);
            }
            catch (BadLocationException badLocationException) {
                return -1;
            }
            return this.getToken(string);
        }
        return 8;
    }

    public int previousToken(int n, int n2) {
        int n3 = this.scanBackward(n, n2, this.fNonWSDefaultPart);
        if (n3 == -1) {
            return -1;
        }
        --this.fPos;
        switch (this.fChar) {
            case '{': {
                return 1;
            }
            case '}': {
                return 2;
            }
            case '[': {
                return 3;
            }
            case ']': {
                return 4;
            }
            case '(': {
                return 5;
            }
            case ')': {
                return 6;
            }
            case ';': {
                return 7;
            }
            case ':': {
                return 9;
            }
            case ',': {
                return 11;
            }
            case '?': {
                return 10;
            }
            case '=': {
                return 12;
            }
            case '<': {
                return 13;
            }
            case '>': {
                return 14;
            }
        }
        if (Character.isJavaIdentifierPart(this.fChar)) {
            String string;
            int n4 = n3 + 1;
            int n5 = (n3 = this.scanBackward(n3 - 1, n2, this.fNonIdent)) == -1 ? (n2 == -2 ? 0 : n2 + 1) : n3 + 1;
            try {
                string = this.fDocument.get(n5, n4 - n5);
            }
            catch (BadLocationException badLocationException) {
                return -1;
            }
            return this.getToken(string);
        }
        return 8;
    }

    private int getToken(String string) {
        Assert.isNotNull((Object)string);
        switch (string.length()) {
            case 2: {
                if ("if".equals(string)) {
                    return 109;
                }
                if (!"do".equals(string)) break;
                return 1010;
            }
            case 3: {
                if ("for".equals(string)) {
                    return 1011;
                }
                if ("try".equals(string)) {
                    return 1012;
                }
                if (!"new".equals(string)) break;
                return 1025;
            }
            case 4: {
                if ("case".equals(string)) {
                    return 1013;
                }
                if ("else".equals(string)) {
                    return 1014;
                }
                if ("enum".equals(string)) {
                    return 1028;
                }
                if (!"goto".equals(string)) break;
                return 1023;
            }
            case 5: {
                if ("break".equals(string)) {
                    return 1015;
                }
                if ("catch".equals(string)) {
                    return 1016;
                }
                if ("class".equals(string)) {
                    return 1026;
                }
                if (!"while".equals(string)) break;
                return 1017;
            }
            case 6: {
                if ("return".equals(string)) {
                    return 1018;
                }
                if ("static".equals(string)) {
                    return 1019;
                }
                if (!"switch".equals(string)) break;
                return 1020;
            }
            case 7: {
                if ("default".equals(string)) {
                    return 1024;
                }
                if (!"finally".equals(string)) break;
                return 1021;
            }
            case 9: {
                if (!"interface".equals(string)) break;
                return 1027;
            }
            case 12: {
                if (!"synchronized".equals(string)) break;
                return 1022;
            }
        }
        return 2000;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int findClosingPeer(int n, char c, char c2) {
        Assert.isNotNull((Object)this.fDocument);
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        try {
            int n2 = 1;
            --n;
            do {
                if ((n = this.scanForward(n + 1, -2, new CharacterMatch(new char[]{c, c2}))) == -1) {
                    return -1;
                }
                if (this.fDocument.getChar(n) == c) {
                    ++n2;
                    continue;
                }
                --n2;
            } while (n2 != 0);
            return n;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int findOpeningPeer(int n, char c, char c2) {
        Assert.isTrue((n < this.fDocument.getLength() ? 1 : 0) != 0);
        try {
            int n2 = 1;
            ++n;
            do {
                if ((n = this.scanBackward(n - 1, -2, new CharacterMatch(new char[]{c, c2}))) == -1) {
                    return -1;
                }
                if (this.fDocument.getChar(n) == c2) {
                    ++n2;
                    continue;
                }
                --n2;
            } while (n2 != 0);
            return n;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    public IRegion findSurroundingBlock(int n) {
        if (n < 1 || n >= this.fDocument.getLength()) {
            return null;
        }
        int n2 = this.findOpeningPeer(n - 1, '{', '}');
        int n3 = this.findClosingPeer(n, '{', '}');
        if (n2 == -1 || n3 == -1) {
            return null;
        }
        return new Region(n2, n3 + 1 - n2);
    }

    public int findNonWhitespaceForward(int n, int n2) {
        return this.scanForward(n, n2, this.fNonWSDefaultPart);
    }

    public int findNonWhitespaceForwardInAnyPartition(int n, int n2) {
        return this.scanForward(n, n2, fNonWS);
    }

    public int findNonWhitespaceBackward(int n, int n2) {
        return this.scanBackward(n, n2, this.fNonWSDefaultPart);
    }

    public int scanForward(int n, int n2, StopCondition stopCondition) {
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        if (n2 == -2) {
            n2 = this.fDocument.getLength();
        }
        Assert.isTrue((n2 <= this.fDocument.getLength() ? 1 : 0) != 0);
        try {
            this.fPos = n;
            while (this.fPos < n2) {
                this.fChar = this.fDocument.getChar(this.fPos);
                if (stopCondition.stop(this.fChar, this.fPos, true)) {
                    return this.fPos;
                }
                this.fPos = stopCondition.nextPosition(this.fPos, true);
            }
        }
        catch (BadLocationException badLocationException) {}
        return -1;
    }

    public int scanForward(int n, int n2, char c) {
        return this.scanForward(n, n2, new CharacterMatch(c));
    }

    public int scanForward(int n, int n2, char[] cArray) {
        return this.scanForward(n, n2, new CharacterMatch(cArray));
    }

    public int scanBackward(int n, int n2, StopCondition stopCondition) {
        if (n2 == -2) {
            n2 = -1;
        }
        Assert.isTrue((n2 >= -1 ? 1 : 0) != 0);
        Assert.isTrue((n < this.fDocument.getLength() ? 1 : 0) != 0);
        try {
            this.fPos = n;
            while (this.fPos > n2) {
                this.fChar = this.fDocument.getChar(this.fPos);
                if (stopCondition.stop(this.fChar, this.fPos, false)) {
                    return this.fPos;
                }
                this.fPos = stopCondition.nextPosition(this.fPos, false);
            }
        }
        catch (BadLocationException badLocationException) {}
        return -1;
    }

    public int scanBackward(int n, int n2, char c) {
        return this.scanBackward(n, n2, new CharacterMatch(c));
    }

    public int scanBackward(int n, int n2, char[] cArray) {
        return this.scanBackward(n, n2, new CharacterMatch(cArray));
    }

    public boolean isDefaultPartition(int n) {
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        Assert.isTrue((n <= this.fDocument.getLength() ? 1 : 0) != 0);
        try {
            return this.fPartition.equals(TextUtilities.getContentType((IDocument)this.fDocument, (String)this.fPartitioning, (int)n, (boolean)false));
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private ITypedRegion getPartition(int n) {
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        Assert.isTrue((n <= this.fDocument.getLength() ? 1 : 0) != 0);
        try {
            return TextUtilities.getPartition((IDocument)this.fDocument, (String)this.fPartitioning, (int)n, (boolean)false);
        }
        catch (BadLocationException badLocationException) {
            return new TypedRegion(n, 0, "__no_partition_at_all");
        }
    }

    public boolean isBracelessBlockStart(int n, int n2) {
        if (n < 1) {
            return false;
        }
        switch (this.previousToken(n, n2)) {
            case 1010: 
            case 1014: {
                return true;
            }
            case 6: {
                n = this.findOpeningPeer(this.fPos, '(', ')');
                if (n <= 0) break;
                switch (this.previousToken(n - 1, n2)) {
                    case 109: 
                    case 1011: 
                    case 1017: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final class CharacterMatch
    extends StopCondition {
        private final char[] fChars;

        public CharacterMatch(char c) {
            this(new char[]{c});
        }

        public CharacterMatch(char[] cArray) {
            Assert.isNotNull((Object)cArray);
            Assert.isTrue((cArray.length > 0 ? 1 : 0) != 0);
            this.fChars = cArray;
            Arrays.sort(cArray);
        }

        public boolean stop(char c, int n, boolean bl) {
            return Arrays.binarySearch(this.fChars, c) >= 0 && PHPHeuristicScanner.this.isDefaultPartition(n);
        }

        public int nextPosition(int n, boolean bl) {
            ITypedRegion iTypedRegion = PHPHeuristicScanner.this.getPartition(n);
            if (PHPHeuristicScanner.this.fPartition.equals(iTypedRegion.getType())) {
                return super.nextPosition(n, bl);
            }
            if (bl) {
                int n2 = iTypedRegion.getOffset() + iTypedRegion.getLength();
                if (n < n2) {
                    return n2;
                }
            } else {
                int n3 = iTypedRegion.getOffset();
                if (n > n3) {
                    return n3 - 1;
                }
            }
            return super.nextPosition(n, bl);
        }
    }

    private static class NonJavaIdentifierPart
    extends StopCondition {
        private NonJavaIdentifierPart() {
        }

        public boolean stop(char c, int n, boolean bl) {
            return !Character.isJavaIdentifierPart(c);
        }
    }

    private final class NonJavaIdentifierPartDefaultPartition
    extends NonJavaIdentifierPart {
        private NonJavaIdentifierPartDefaultPartition() {
        }

        public boolean stop(char c, int n, boolean bl) {
            return super.stop(c, n, true) || !PHPHeuristicScanner.this.isDefaultPartition(n);
        }

        public int nextPosition(int n, boolean bl) {
            ITypedRegion iTypedRegion = PHPHeuristicScanner.this.getPartition(n);
            if (PHPHeuristicScanner.this.fPartition.equals(iTypedRegion.getType())) {
                return super.nextPosition(n, bl);
            }
            if (bl) {
                int n2 = iTypedRegion.getOffset() + iTypedRegion.getLength();
                if (n < n2) {
                    return n2;
                }
            } else {
                int n3 = iTypedRegion.getOffset();
                if (n > n3) {
                    return n3 - 1;
                }
            }
            return super.nextPosition(n, bl);
        }
    }

    private static class NonWhitespace
    extends StopCondition {
        private NonWhitespace() {
        }

        public boolean stop(char c, int n, boolean bl) {
            return !Character.isWhitespace(c);
        }

        /* synthetic */ NonWhitespace(NonWhitespace nonWhitespace, NonWhitespace nonWhitespace2) {
            this();
        }
    }

    private final class NonWhitespaceDefaultPartition
    extends NonWhitespace {
        private NonWhitespaceDefaultPartition() {
            super(null, null);
        }

        public boolean stop(char c, int n, boolean bl) {
            return super.stop(c, n, true) && PHPHeuristicScanner.this.isDefaultPartition(n);
        }

        public int nextPosition(int n, boolean bl) {
            ITypedRegion iTypedRegion = PHPHeuristicScanner.this.getPartition(n);
            if (PHPHeuristicScanner.this.fPartition.equals(iTypedRegion.getType())) {
                return super.nextPosition(n, bl);
            }
            if (bl) {
                int n2 = iTypedRegion.getOffset() + iTypedRegion.getLength();
                if (n < n2) {
                    return n2;
                }
            } else {
                int n3 = iTypedRegion.getOffset();
                if (n > n3) {
                    return n3 - 1;
                }
            }
            return super.nextPosition(n, bl);
        }
    }

    private static abstract class StopCondition {
        private StopCondition() {
        }

        public abstract boolean stop(char var1, int var2, boolean var3);

        public int nextPosition(int n, boolean bl) {
            return bl ? n + 1 : n - 1;
        }
    }
}

