/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.hover;

import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.core.documentModel.parser.regions.PhpScriptRegion;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.ui.editor.hover.IHoverMessageDecorator;
import org.eclipse.php.ui.editor.hover.IPHPTextHover;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.ui.internal.derived.HTMLTextPresenter;

public abstract class AbstractPHPTextHover
implements IPHPTextHover,
ITextHoverExtension {
    protected Pattern tab = Pattern.compile("\t");
    protected IEditorPart fEditor;
    private IBindingService fBindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);

    public IEditorPart getEditorPart() {
        return this.fEditor;
    }

    public void setEditorPart(IEditorPart iEditorPart) {
        this.fEditor = iEditorPart;
    }

    public IRegion getHoverRegion(ITextViewer iTextViewer, int n) {
        if (iTextViewer == null || iTextViewer.getDocument() == null) {
            return null;
        }
        IStructuredDocumentRegion iStructuredDocumentRegion = ((IStructuredDocument)iTextViewer.getDocument()).getRegionAtCharacterOffset(n);
        ITextRegion iTextRegion = null;
        if (iStructuredDocumentRegion != null) {
            iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(n);
        }
        IStructuredDocumentRegion iStructuredDocumentRegion2 = iStructuredDocumentRegion;
        if (iTextRegion instanceof ITextRegionContainer) {
            iStructuredDocumentRegion2 = (ITextRegionContainer)iTextRegion;
            iTextRegion = iStructuredDocumentRegion2.getRegionAtCharacterOffset(n);
        }
        if (iTextRegion.getType() == "PHP_CONTENT") {
            PhpScriptRegion phpScriptRegion = (PhpScriptRegion)iTextRegion;
            try {
                iTextRegion = phpScriptRegion.getPhpToken(n - iStructuredDocumentRegion2.getStartOffset() - iTextRegion.getStart());
            }
            catch (BadLocationException badLocationException) {
                iTextRegion = null;
            }
            if (iTextRegion != null) {
                return new Region(iStructuredDocumentRegion2.getStartOffset() + phpScriptRegion.getStart() + iTextRegion.getStart(), iTextRegion.getLength());
            }
        }
        return null;
    }

    protected String getTooltipAffordanceString() {
        if (this.fBindingService == null) {
            return null;
        }
        String string = this.fBindingService.getBestActiveBindingFormattedFor("org.eclipse.php.ui.edit.text.show.phpdoc");
        if (string == null) {
            return null;
        }
        return NLS.bind((String)PHPUIMessages.HoverFocus_message, (Object)string);
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                return new DefaultInformationControl(shell, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true), AbstractPHPTextHover.this.getTooltipAffordanceString());
            }
        };
    }

    public IHoverMessageDecorator getMessageDecorator() {
        return null;
    }
}

