/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.ui.launching;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.internal.core.documentModel.provisional.contenttype.ContentTypeIdForPHP;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.util.FileUtils;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.debugger.AbstractDebuggerConfiguration;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.debug.ui.PHPDebugUIPlugin;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.manager.ServersManager;
import org.eclipse.php.internal.server.ui.launching.PHPWebPageURLLaunchDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public class PHPWebPageLaunchShortcut
implements ILaunchShortcut {
    public void launch(ISelection iSelection, String string) {
        if (iSelection instanceof IStructuredSelection) {
            PHPWebPageLaunchShortcut.searchAndLaunch(((IStructuredSelection)iSelection).toArray(), string, this.getPHPServerLaunchConfigType());
        }
    }

    public void launch(IEditorPart iEditorPart, String string) {
        IEditorInput iEditorInput = iEditorPart.getEditorInput();
        IFile iFile = (IFile)iEditorInput.getAdapter(IFile.class);
        if (iFile != null) {
            PHPWebPageLaunchShortcut.searchAndLaunch(new Object[]{iFile}, string, this.getPHPServerLaunchConfigType());
        }
    }

    private ILaunchConfigurationType getPHPServerLaunchConfigType() {
        ILaunchManager iLaunchManager = DebugPlugin.getDefault().getLaunchManager();
        return iLaunchManager.getLaunchConfigurationType("org.eclipse.php.debug.core.launching.webPageLaunch");
    }

    public static void searchAndLaunch(Object[] objectArray, String string, ILaunchConfigurationType iLaunchConfigurationType) {
        int n = objectArray == null ? 0 : objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus iStatus;
            try {
                IContentType iContentType;
                IFile iFile;
                String string2 = null;
                iStatus = null;
                Object object = objectArray[n2];
                if (object instanceof PHPCodeData) {
                    object = PHPModelUtil.getResource((Object)object);
                }
                if (object instanceof IFile) {
                    iFile = (IFile)object;
                    iStatus = iFile.getProject();
                    iContentType = Platform.getContentTypeManager().getContentType(ContentTypeIdForPHP.ContentTypeID_PHP);
                    if (iContentType.isAssociatedWith(iFile.getName())) {
                        string2 = iFile.getFullPath().toString();
                    }
                }
                if (string2 == null) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.php.debug.ui", 0, PHPDebugUIMessages.launch_failure_no_target, null));
                }
                iFile = ServersManager.getDefaultServer((IProject)iStatus);
                if (iFile == null) {
                    PHPDebugPlugin.createDefaultPHPServer();
                    iFile = ServersManager.getDefaultServer((IProject)iStatus);
                    if (iFile == null) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.php.debug.ui", 0, "Could not create a defualt server for the launch.", null));
                    }
                }
                if ((iContentType = PHPWebPageLaunchShortcut.findLaunchConfiguration((IProject)iStatus, string2, (Server)iFile, string, iLaunchConfigurationType)) != null) {
                    DebugUITools.launch((ILaunchConfiguration)iContentType, (String)string);
                }
            }
            catch (CoreException coreException) {
                iStatus = coreException.getStatus();
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        ErrorDialog.openError((Shell)PHPDebugUIPlugin.getActiveWorkbenchShell(), (String)PHPDebugUIMessages.launch_failure_msg_title, (String)PHPDebugUIMessages.launch_failure_server_msg_text, (IStatus)iStatus);
                    }
                });
            }
            ++n2;
        }
    }

    static ILaunchConfiguration findLaunchConfiguration(IProject iProject, String string, Server server, String string2, ILaunchConfigurationType iLaunchConfigurationType) {
        ILaunchConfiguration iLaunchConfiguration = null;
        try {
            ILaunchConfiguration[] iLaunchConfigurationArray = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(iLaunchConfigurationType);
            int n = iLaunchConfigurationArray == null ? 0 : iLaunchConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string3 = iLaunchConfigurationArray[n2].getAttribute("name", null);
                String string4 = iLaunchConfigurationArray[n2].getAttribute("file_name", null);
                if (string4.equals(string) && server.getName().equals(string3)) {
                    iLaunchConfiguration = iLaunchConfigurationArray[n2].getWorkingCopy();
                    break;
                }
                ++n2;
            }
            if (iLaunchConfiguration == null) {
                iLaunchConfiguration = PHPWebPageLaunchShortcut.createConfiguration(iProject, string, server, iLaunchConfigurationType, string2);
            }
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        return iLaunchConfiguration;
    }

    static String computeContextRoot(String string, String string2, Server server) {
        String string3 = server.getBaseURL();
        if (string.length() > string3.length() + 1) {
            string = string.substring(string3.length() + 1);
        } else if (string.length() == string3.length() || string.length() == string3.length() + 1) {
            return "";
        }
        if (string2.length() > 0) {
            int n = (string2 = string2.substring(1)).indexOf(47);
            string2 = n < 0 ? "" : string2.substring(n);
        }
        if (string.length() <= string2.length()) {
            return "";
        }
        string = string.substring(0, string.length() - string2.length());
        return string;
    }

    static ILaunchConfiguration createConfiguration(IProject iProject, String string, Server server, ILaunchConfigurationType iLaunchConfigurationType, String string2) throws CoreException {
        ILaunchConfiguration iLaunchConfiguration = null;
        if (!FileUtils.fileExists((String)string)) {
            return null;
        }
        String string3 = String.valueOf(server.getBaseURL()) + '/' + new Path(string).removeFirstSegments(1);
        ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfigurationType.newInstance(null, PHPWebPageLaunchShortcut.getNewConfigurationName(string));
        String string4 = PHPProjectPreferences.getDefaultDebuggerID((IProject)iProject);
        iLaunchConfigurationWorkingCopy.setAttribute(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, string4);
        AbstractDebuggerConfiguration abstractDebuggerConfiguration = PHPDebuggersRegistry.getDebuggerConfiguration((String)string4);
        iLaunchConfigurationWorkingCopy.setAttribute(PHPDebugCorePreferenceNames.CONFIGURATION_DELEGATE_CLASS, abstractDebuggerConfiguration.getWebLaunchDelegateClass());
        iLaunchConfigurationWorkingCopy.setAttribute("name", server.getName());
        iLaunchConfigurationWorkingCopy.setAttribute("file_name", string);
        iLaunchConfigurationWorkingCopy.setAttribute("context_root", PHPWebPageLaunchShortcut.computeContextRoot(string3, string, server));
        iLaunchConfigurationWorkingCopy.setAttribute("base_url", string3);
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.php.debug.core.RunWithDebugInfo", PHPDebugPlugin.getDebugInfoOption());
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.php.debug.core.OpenInBrowser", PHPDebugPlugin.getOpenInBrowserOption());
        iLaunchConfigurationWorkingCopy.setAttribute("firstLineBreakpoint", PHPProjectPreferences.getStopAtFirstLine((IProject)iProject));
        if (server.canPublish()) {
            iLaunchConfigurationWorkingCopy.setAttribute("publish", true);
        }
        String string5 = "debug".equals(string2) ? "Debug PHP Web Page" : "Run PHP Web Page";
        PHPWebPageURLLaunchDialog pHPWebPageURLLaunchDialog = new PHPWebPageURLLaunchDialog(iLaunchConfigurationWorkingCopy, server, string5);
        pHPWebPageURLLaunchDialog.setBlockOnOpen(true);
        if (pHPWebPageURLLaunchDialog.open() == 0) {
            iLaunchConfiguration = iLaunchConfigurationWorkingCopy.doSave();
            return iLaunchConfiguration;
        }
        return null;
    }

    protected static String getNewConfigurationName(String string) {
        String string2 = "New_configuration";
        try {
            IPath iPath = Path.fromOSString((String)string);
            String string3 = iPath.getFileExtension();
            String string4 = iPath.lastSegment();
            if (string4 != null) {
                if (string3 != null) {
                    string4 = string4.replaceFirst("." + string3, "");
                }
                string2 = string4;
            }
        }
        catch (Exception exception) {
            Logger.log((int)202, (String)("Could not generate configuration name for " + string + ".\nThe default name will be used."), (Throwable)exception);
        }
        return DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(string2);
    }
}

