/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.folding.projection;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.php.internal.core.documentModel.DOMModelForPHP;
import org.eclipse.php.internal.core.documentModel.dom.ElementImplForPhp;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassConstData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPDocBlock;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.core.phpModel.phpElementData.UserData;
import org.eclipse.php.internal.ui.folding.projection.CommentPosition;
import org.eclipse.php.internal.ui.folding.projection.ElementProjectionAnnotation;
import org.eclipse.php.internal.ui.folding.projection.ProjectionModelNodeAdapterFactoryPHP;
import org.eclipse.php.internal.ui.folding.projection.ProjectionModelNodeAdapterHTML;
import org.eclipse.php.internal.ui.folding.projection.ProjectionViewerInformation;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.document.NodeImpl;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectionModelNodeAdapterPHP
extends ProjectionModelNodeAdapterHTML {
    private IStructuredDocument document;
    private boolean shouldAutoCollapseAnnotations = true;

    public ProjectionModelNodeAdapterPHP(ProjectionModelNodeAdapterFactoryPHP projectionModelNodeAdapterFactoryPHP) {
        super(projectionModelNodeAdapterFactoryPHP);
    }

    @Override
    public boolean isAdapterForType(Object object) {
        return object == ProjectionModelNodeAdapterPHP.class;
    }

    @Override
    public void updateAdapter(Node node, ProjectionViewer projectionViewer) {
        HashMap<ProjectionAnnotation, Position> hashMap = new HashMap<ProjectionAnnotation, Position>();
        HashMap<ProjectionAnnotation, Position> hashMap2 = new HashMap<ProjectionAnnotation, Position>();
        if (node != null && node instanceof NodeImpl) {
            NodeImpl nodeImpl = (NodeImpl)node;
            assert (nodeImpl.getModel() instanceof DOMModelForPHP) : "Incompatible model";
            DOMModelForPHP dOMModelForPHP = (DOMModelForPHP)nodeImpl.getModel();
            this.document = dOMModelForPHP.getStructuredDocument();
            ProjectionViewer projectionViewer2 = this.getAdapterFactory().findViewer(dOMModelForPHP);
            if (projectionViewer2 == null) {
                return;
            }
            ProjectionViewerInformation projectionViewerInformation = this.getAdapterFactory().getInformation(projectionViewer2);
            if (projectionViewerInformation.isDocumentChanging()) {
                return;
            }
            PHPFileData pHPFileData = dOMModelForPHP.getFileData();
            if (pHPFileData == null) {
                return;
            }
            this.createAnnotationsForChild(hashMap, hashMap2, pHPFileData, node.getFirstChild());
            ProjectionAnnotation[] projectionAnnotationArray = null;
            if (!this.previousAnnotations.isEmpty()) {
                projectionAnnotationArray = this.previousAnnotations.keySet().toArray(new ProjectionAnnotation[0]);
            }
            ProjectionAnnotation[] projectionAnnotationArray2 = null;
            hashMap2.isEmpty();
            if (projectionViewer != null && !hashMap2.isEmpty()) {
                this.fAdapterFactory.queueAnnotationModelChanges(node, null, hashMap2, null, projectionViewer);
            }
            if (projectionAnnotationArray != null && projectionAnnotationArray.length > 0 || !hashMap.isEmpty() || projectionAnnotationArray2 != null && projectionAnnotationArray2.length > 0) {
                this.fAdapterFactory.queueAnnotationModelChanges(node, (Annotation[])projectionAnnotationArray, hashMap, (Annotation[])projectionAnnotationArray2);
            }
            this.shouldAutoCollapseAnnotations = false;
        }
        this.previousAnnotations = hashMap2;
    }

    private final Node createAnnotationsForChild(Map<ProjectionAnnotation, Position> map, Map<ProjectionAnnotation, Position> map2, PHPFileData pHPFileData, Node node) {
        while (node != null) {
            if (node.getNodeType() == 1) {
                assert (node instanceof ElementImplForPhp) : "Bad element";
                ElementImplForPhp elementImplForPhp = (ElementImplForPhp)node;
                if (elementImplForPhp.isPhpTag()) {
                    int n = elementImplForPhp.getStartOffset();
                    int n2 = elementImplForPhp.getEndOffset();
                    this.createFileAnnotations(map2, map, pHPFileData, n, n2);
                }
                elementImplForPhp.getFirstChild();
                this.createAnnotationsForChild(map, map2, pHPFileData, elementImplForPhp.getFirstChild());
            }
            node = node.getNextSibling();
        }
        return node;
    }

    private void createFileAnnotations(Map<ProjectionAnnotation, Position> map, Map<ProjectionAnnotation, Position> map2, PHPFileData pHPFileData, int n, int n2) {
        PHPFunctionData[] pHPFunctionDataArray;
        PHPFunctionData[] pHPFunctionDataArray2;
        PHPClassData[] pHPClassDataArray;
        ProjectionModelNodeAdapterFactoryPHP projectionModelNodeAdapterFactoryPHP = this.getAdapterFactory();
        assert (projectionModelNodeAdapterFactoryPHP != null) : "provider can't be null - see setProvider()";
        boolean bl = projectionModelNodeAdapterFactoryPHP.isFoldingPhpDoc();
        boolean bl2 = projectionModelNodeAdapterFactoryPHP.isFoldingFunctions();
        boolean bl3 = projectionModelNodeAdapterFactoryPHP.isFoldingClasses();
        this.createDocBlockAnnotations(map, map2, (PHPCodeData)pHPFileData, n, n2, bl);
        PHPClassData[] pHPClassDataArray2 = pHPClassDataArray = pHPFileData.getClasses();
        int n3 = pHPClassDataArray.length;
        int n4 = 0;
        while (n4 < n3) {
            PHPClassConstData[] pHPClassConstDataArray;
            PHPFunctionData pHPFunctionData;
            pHPFunctionDataArray2 = pHPClassDataArray2[n4];
            this.createCodeDataAnnotations(map, map2, (PHPCodeData)pHPFunctionDataArray2, n, n2, bl3);
            this.createDocBlockAnnotations(map, map2, (PHPCodeData)pHPFunctionDataArray2, n, n2, bl);
            PHPFunctionData[] pHPFunctionDataArray3 = pHPFunctionDataArray = pHPFunctionDataArray2.getFunctions();
            int n5 = pHPFunctionDataArray.length;
            int n6 = 0;
            while (n6 < n5) {
                pHPFunctionData = pHPFunctionDataArray3[n6];
                this.createCodeDataAnnotations(map, map2, (PHPCodeData)pHPFunctionData, n, n2, bl2);
                this.createDocBlockAnnotations(map, map2, (PHPCodeData)pHPFunctionData, n, n2, bl);
                ++n6;
            }
            PHPFunctionData pHPFunctionData2 = pHPFunctionData = pHPFunctionDataArray2.getVars();
            int n7 = ((PHPFunctionData)pHPFunctionData2).length;
            n5 = 0;
            while (n5 < n7) {
                PHPFunctionData pHPFunctionData3 = pHPFunctionData2[n5];
                this.createDocBlockAnnotations(map, map2, (PHPCodeData)pHPFunctionData3, n, n2, bl);
                ++n5;
            }
            PHPClassConstData[] pHPClassConstDataArray2 = pHPClassConstDataArray = pHPFunctionDataArray2.getConsts();
            int n8 = pHPClassConstDataArray.length;
            n7 = 0;
            while (n7 < n8) {
                PHPClassConstData pHPClassConstData = pHPClassConstDataArray2[n7];
                this.createDocBlockAnnotations(map, map2, (PHPCodeData)pHPClassConstData, n, n2, bl);
                ++n7;
            }
            ++n4;
        }
        pHPFunctionDataArray = pHPFunctionDataArray2 = pHPFileData.getFunctions();
        int n9 = pHPFunctionDataArray2.length;
        n3 = 0;
        while (n3 < n9) {
            PHPClassData pHPClassData = pHPFunctionDataArray[n3];
            this.createCodeDataAnnotations(map, map2, (PHPCodeData)pHPClassData, n, n2, bl2);
            this.createDocBlockAnnotations(map, map2, (PHPCodeData)pHPClassData, n, n2, bl);
            ++n3;
        }
    }

    private void createCodeDataAnnotations(Map<ProjectionAnnotation, Position> map, Map<ProjectionAnnotation, Position> map2, PHPCodeData pHPCodeData, int n, int n2, boolean bl) {
        UserData userData = pHPCodeData.getUserData();
        int n3 = userData.getStartPosition();
        if (n3 > n && n3 < n2) {
            ElementProjectionAnnotation elementProjectionAnnotation = new ElementProjectionAnnotation(pHPCodeData, false, this.shouldAutoCollapseAnnotations ? bl : false);
            ProjectionAnnotation projectionAnnotation = this.getExistingAnnotation(elementProjectionAnnotation);
            Position position = this.createPosition(n3, userData.getEndPosition(), (IDocument)this.document);
            if (projectionAnnotation == null) {
                map.put(elementProjectionAnnotation, position);
                map2.put(elementProjectionAnnotation, position);
            } else {
                map.put(projectionAnnotation, position);
                this.previousAnnotations.remove(projectionAnnotation);
            }
        }
    }

    private Position createPosition(int n, int n2, IDocument iDocument) {
        assert (iDocument != null);
        IRegion iRegion = this.alignRegion(n, n2, iDocument);
        return new Position(iRegion.getOffset(), iRegion.getLength());
    }

    private Position createCommentPosition(int n, int n2, IDocument iDocument) {
        assert (iDocument != null);
        IRegion iRegion = this.alignRegion(n, n2, iDocument);
        return new CommentPosition(iRegion.getOffset(), iRegion.getLength());
    }

    protected final IRegion alignRegion(int n, int n2, IDocument iDocument) {
        try {
            int n3 = iDocument.getLength();
            int n4 = iDocument.getLineOfOffset(n);
            int n5 = iDocument.getLineOfOffset(Math.min(n3, n2));
            if (n4 >= n5) {
                return new Region(n, 0);
            }
            int n6 = iDocument.getLineOffset(n4);
            int n7 = iDocument.getNumberOfLines() > n5 + 1 ? iDocument.getLineOffset(n5 + 1) : iDocument.getLineOffset(n5) + iDocument.getLineLength(n5);
            return new Region(n6, n7 - n6);
        }
        catch (BadLocationException badLocationException) {
            return new Region(n, n2 - n);
        }
    }

    private void createDocBlockAnnotations(Map<ProjectionAnnotation, Position> map, Map<ProjectionAnnotation, Position> map2, PHPCodeData pHPCodeData, int n, int n2, boolean bl) {
        PHPDocBlock pHPDocBlock = pHPCodeData.getDocBlock();
        if (pHPDocBlock == null) {
            return;
        }
        int n3 = pHPDocBlock.getStartPosition();
        if (n3 > n && n3 < n2) {
            Position position = this.createCommentPosition(n3, pHPDocBlock.getEndPosition(), (IDocument)this.document);
            ElementProjectionAnnotation elementProjectionAnnotation = new ElementProjectionAnnotation(pHPCodeData, true, this.shouldAutoCollapseAnnotations ? bl : false);
            ProjectionAnnotation projectionAnnotation = this.getExistingAnnotation(elementProjectionAnnotation);
            if (projectionAnnotation == null) {
                map.put(elementProjectionAnnotation, position);
                map2.put(elementProjectionAnnotation, position);
            } else {
                map.put(projectionAnnotation, position);
                this.previousAnnotations.remove(projectionAnnotation);
            }
        }
    }

    private ProjectionAnnotation getExistingAnnotation(ProjectionAnnotation projectionAnnotation) {
        assert (projectionAnnotation != null) : "projectionAnnotation should be not null";
        if (!this.previousAnnotations.isEmpty()) {
            for (ProjectionAnnotation projectionAnnotation2 : this.previousAnnotations.keySet()) {
                if (!projectionAnnotation.equals(projectionAnnotation2)) continue;
                return projectionAnnotation2;
            }
        }
        return null;
    }

    private ProjectionModelNodeAdapterFactoryPHP getAdapterFactory() {
        assert (this.fAdapterFactory instanceof ProjectionModelNodeAdapterFactoryPHP) : "Factory must be ProjectionModelNodeAdapterFactoryPHP";
        return (ProjectionModelNodeAdapterFactoryPHP)this.fAdapterFactory;
    }
}

