/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.daemon.communication;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.php.debug.daemon.communication.ICommunicationDaemon;
import org.eclipse.php.internal.debug.daemon.DaemonPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommunicationDaemonRegistry {
    private static final String EXTENSION_POINT_NAME = "debugCommunicationDaemon";
    private static final String DAEMON_TAG = "daemon";
    private static final String ID_ATTRIBUTE = "id";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String DEFAULT_DEBUG_DAEMONS_NAMESPACE = "org.eclipse.php.debug.core";
    private Dictionary<String, CommunicationDaemonFactory> daemons = new Hashtable<String, CommunicationDaemonFactory>();
    private static CommunicationDaemonRegistry instance = null;

    private CommunicationDaemonRegistry() {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor(DaemonPlugin.getID(), EXTENSION_POINT_NAME);
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            if (DAEMON_TAG.equals(iConfigurationElement.getName())) {
                this.daemons.put(iConfigurationElement.getAttribute(ID_ATTRIBUTE), new CommunicationDaemonFactory(iConfigurationElement));
            }
            ++n;
        }
    }

    private static CommunicationDaemonRegistry getInstance() {
        if (instance == null) {
            instance = new CommunicationDaemonRegistry();
        }
        return instance;
    }

    private Dictionary<String, CommunicationDaemonFactory> getDaemons() {
        return this.daemons;
    }

    public static ICommunicationDaemon getDaemon(String string) throws Exception {
        return (ICommunicationDaemon)((Object)CommunicationDaemonRegistry.getInstance().getDaemons().get(string));
    }

    public static ICommunicationDaemon[] getBestMatchCommunicationDaemons() {
        try {
            ICommunicationDaemon[] iCommunicationDaemonArray22;
            Object object;
            Dictionary<String, CommunicationDaemonFactory> dictionary = CommunicationDaemonRegistry.getInstance().getDaemons();
            Enumeration<CommunicationDaemonFactory> enumeration = dictionary.elements();
            ArrayList<ICommunicationDaemon[]> arrayList = new ArrayList<ICommunicationDaemon[]>(5);
            ArrayList<ICommunicationDaemon[]> arrayList2 = new ArrayList<ICommunicationDaemon[]>(5);
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                iCommunicationDaemonArray22 = ((CommunicationDaemonFactory)object).createDaemon();
                if (DEFAULT_DEBUG_DAEMONS_NAMESPACE.equals(((CommunicationDaemonFactory)object).element.getNamespaceIdentifier())) {
                    if (!iCommunicationDaemonArray22.isEnabled()) continue;
                    arrayList.add(iCommunicationDaemonArray22);
                    continue;
                }
                if (!iCommunicationDaemonArray22.isEnabled()) continue;
                arrayList2.add(iCommunicationDaemonArray22);
            }
            object = new ArrayList(arrayList.size() + 4);
            ((ArrayList)object).addAll(arrayList);
            for (ICommunicationDaemon[] iCommunicationDaemonArray22 : arrayList2) {
                ((ArrayList)object).add(iCommunicationDaemonArray22);
                for (ICommunicationDaemon iCommunicationDaemon : arrayList) {
                    if (!iCommunicationDaemon.getClass().isAssignableFrom(iCommunicationDaemonArray22.getClass())) continue;
                    ((ArrayList)object).remove(iCommunicationDaemon);
                }
            }
            iCommunicationDaemonArray22 = new ICommunicationDaemon[((ArrayList)object).size()];
            ((ArrayList)object).toArray(iCommunicationDaemonArray22);
            return iCommunicationDaemonArray22;
        }
        catch (Exception exception) {
            DaemonPlugin.log(exception);
            return null;
        }
    }

    class CommunicationDaemonFactory {
        ICommunicationDaemon daemon;
        IConfigurationElement element;

        public CommunicationDaemonFactory(IConfigurationElement iConfigurationElement) {
            this.element = iConfigurationElement;
        }

        public ICommunicationDaemon createDaemon() {
            if (this.daemon == null) {
                SafeRunner.run((ISafeRunnable)new SafeRunnable("Error creation extension for extension-point org.eclipse.php.internal.debug.daemon.communication"){

                    public void run() throws Exception {
                        CommunicationDaemonFactory.this.daemon = (ICommunicationDaemon)CommunicationDaemonFactory.this.element.createExecutableExtension(CommunicationDaemonRegistry.CLASS_ATTRIBUTE);
                    }
                });
            }
            return this.daemon;
        }
    }
}

