/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.actions;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.actions.IVariableValueEditor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.swt.widgets.Shell;

public class XDebugVariableValueEditor
implements IVariableValueEditor {
    public boolean editVariable(IVariable iVariable, Shell shell) {
        try {
            String string = iVariable.getName();
            String string2 = "Change Value";
            String string3 = MessageFormat.format("Enter a new value for {0}:", string);
            IValue iValue = iVariable.getValue();
            String string4 = iValue.getValueString();
            PrimitiveValidator primitiveValidator = new PrimitiveValidator(iVariable);
            InputDialog inputDialog = new InputDialog(shell, string2, string3, string4, (IInputValidator)primitiveValidator);
            if (inputDialog.open() == 0) {
                String string5 = inputDialog.getValue();
                iVariable.setValue(string5);
            }
        }
        catch (DebugException debugException) {
            IStatus iStatus = debugException.getStatus();
            ErrorDialog.openError((Shell)shell, (String)"Error Changing Value", (String)"An exception occurred attempting to change the variable value.", (IStatus)iStatus);
        }
        return true;
    }

    public boolean saveVariable(IVariable iVariable, String string, Shell shell) {
        return false;
    }

    protected class PrimitiveValidator
    implements IInputValidator {
        IVariable var;

        public PrimitiveValidator(IVariable iVariable) {
            this.var = iVariable;
        }

        public String isValid(String string) {
            String string2 = null;
            try {
                if (!this.var.verifyValue(string)) {
                    string2 = "Invalid entry for variable";
                }
            }
            catch (DebugException debugException) {
                Logger.logException("DebugException", debugException);
                string2 = "unexpected error occurred, see log for details";
            }
            return string2;
        }
    }
}

