/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.preferences;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.php.debug.daemon.communication.ICommunicationDaemon;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.debugger.AbstractDebuggerConfiguration;
import org.eclipse.php.internal.debug.daemon.communication.CommunicationDaemonRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PHPDebuggersRegistry {
    private static final String EXTENSION_POINT_NAME = "phpDebuggers";
    private static final String DEBUGGER_TAG = "phpDebugger";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String ID_ATTRIBUTE = "id";
    private static final String CONFIGURATION_CLASS_ATTRIBUTE = "debuggerConfiguration";
    private static String DEFAULT_DEBUGGER_ID = "org.eclipse.php.debug.core.zendDebugger";
    private static PHPDebuggersRegistry instance;
    private HashMap<String, String> debuggers = new HashMap();
    private HashMap<String, AbstractDebuggerConfiguration> configurations = new HashMap();

    private PHPDebuggersRegistry() {
        this.loadDebuggers();
    }

    private static PHPDebuggersRegistry getInstance() {
        if (instance == null) {
            instance = new PHPDebuggersRegistry();
        }
        return instance;
    }

    public static Set<String> getDebuggersIds() {
        return Collections.unmodifiableSet(PHPDebuggersRegistry.getInstance().debuggers.keySet());
    }

    public static AbstractDebuggerConfiguration getDebuggerConfiguration(String string) {
        return PHPDebuggersRegistry.getInstance().configurations.get(string);
    }

    public static AbstractDebuggerConfiguration[] getDebuggersConfigurations() {
        Collection<AbstractDebuggerConfiguration> collection = PHPDebuggersRegistry.getInstance().configurations.values();
        AbstractDebuggerConfiguration[] abstractDebuggerConfigurationArray = new AbstractDebuggerConfiguration[collection.size()];
        return collection.toArray(abstractDebuggerConfigurationArray);
    }

    public static String getDefaultDebuggerId() {
        return DEFAULT_DEBUGGER_ID;
    }

    public static void setDefaultDebuggerId(String string) throws IllegalArgumentException {
        if (!PHPDebuggersRegistry.getInstance().debuggers.containsKey(string)) {
            throw new IllegalArgumentException("No such debugger id was registered: " + string);
        }
        DEFAULT_DEBUGGER_ID = string;
    }

    public static String getDebuggerName(String string) {
        return PHPDebuggersRegistry.getInstance().debuggers.get(string);
    }

    private void loadDebuggers() {
        IConfigurationElement[] iConfigurationElementArray;
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor(PHPDebugPlugin.getID(), EXTENSION_POINT_NAME);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n2];
            if (DEBUGGER_TAG.equals(iConfigurationElement.getName())) {
                String string = iConfigurationElement.getAttribute(NAME_ATTRIBUTE);
                String string2 = iConfigurationElement.getAttribute(ID_ATTRIBUTE);
                this.debuggers.put(string2, string);
                try {
                    AbstractDebuggerConfiguration abstractDebuggerConfiguration = (AbstractDebuggerConfiguration)iConfigurationElement.createExecutableExtension(CONFIGURATION_CLASS_ATTRIBUTE);
                    abstractDebuggerConfiguration.setDebuggerId(string2);
                    abstractDebuggerConfiguration.setName(string);
                    try {
                        ICommunicationDaemon[] iCommunicationDaemonArray;
                        ICommunicationDaemon[] iCommunicationDaemonArray2 = iCommunicationDaemonArray = CommunicationDaemonRegistry.getBestMatchCommunicationDaemons();
                        int n3 = iCommunicationDaemonArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            ICommunicationDaemon iCommunicationDaemon = iCommunicationDaemonArray2[n4];
                            if (iCommunicationDaemon.isDebuggerDaemon() && string2.equals(iCommunicationDaemon.getDebuggerID())) {
                                abstractDebuggerConfiguration.setCommunicationDaemon(iCommunicationDaemon);
                                break;
                            }
                            ++n4;
                        }
                    }
                    catch (Exception exception) {
                        abstractDebuggerConfiguration.setPort(-1);
                    }
                    this.configurations.put(string2, abstractDebuggerConfiguration);
                }
                catch (CoreException coreException) {
                    Logger.logException(coreException);
                }
            }
            ++n2;
        }
    }
}

