/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.preferences;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.php.internal.core.util.UnixChmodUtil;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.osgi.framework.Bundle;

public class PHPexes {
    private static final String DEFAULT_ATTRIBUTE = "default";
    private static final String EXTENSION_POINT_NAME = "phpExe";
    private static final String LOCATION_ATTRIBUTE = "location";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String DEBUGGER_ID_ATTRIBUTE = "debuggerID";
    private static final String PHPEXE_TAG = "phpExe";
    public static final String SEPARATOR = ";";
    private static final String VERSION_ATTRIBUTE = "version";
    private static Object lock = new Object();
    private static PHPexes instance;
    private HashMap<String, HashMap<String, PHPexeItem>> items = new HashMap();
    private HashMap<String, PHPexeItem> defaultItems = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PHPexes getInstance() {
        Object object = lock;
        synchronized (object) {
            if (instance == null) {
                instance = new PHPexes();
            }
            return instance;
        }
    }

    private PHPexes() {
        this.load();
    }

    public void addItem(PHPexeItem pHPexeItem) {
        String string = pHPexeItem.getDebuggerID();
        HashMap<String, PHPexeItem> hashMap = this.items.get(string);
        if (hashMap == null) {
            hashMap = new HashMap();
            this.items.put(string, hashMap);
        }
        if (hashMap.isEmpty()) {
            this.setDefaultItem(pHPexeItem);
        }
        hashMap.put(pHPexeItem.getName(), pHPexeItem);
    }

    public PHPexeItem getDefaultItem(String string) {
        return this.defaultItems.get(string);
    }

    public boolean hasItems(String string) {
        HashMap<String, PHPexeItem> hashMap = this.items.get(string);
        return hashMap != null && hashMap.size() > 0;
    }

    public boolean hasItems() {
        return this.getAllItems().length > 0;
    }

    public PHPexeItem[] getEditableItems() {
        Set<String> set = PHPDebuggersRegistry.getDebuggersIds();
        ArrayList<PHPexeItem> arrayList = new ArrayList<PHPexeItem>();
        for (String string : set) {
            HashMap<String, PHPexeItem> hashMap = this.items.get(string);
            if (hashMap == null) continue;
            Set<String> set2 = hashMap.keySet();
            for (String string2 : set2) {
                PHPexeItem pHPexeItem = hashMap.get(string2);
                if (!pHPexeItem.isEditable()) continue;
                arrayList.add(pHPexeItem);
            }
        }
        return arrayList.toArray(new PHPexeItem[arrayList.size()]);
    }

    public PHPexeItem getItem(String string, String string2) {
        HashMap<String, PHPexeItem> hashMap = this.items.get(string);
        if (hashMap == null) {
            return null;
        }
        return hashMap.get(string2);
    }

    public PHPexeItem getItemForFile(String string) {
        Set<String> set = PHPDebuggersRegistry.getDebuggersIds();
        for (String string2 : set) {
            HashMap<String, PHPexeItem> hashMap = this.items.get(string2);
            if (hashMap == null) continue;
            Set<String> set2 = hashMap.keySet();
            for (String string3 : set2) {
                PHPexeItem pHPexeItem = hashMap.get(string3);
                if (!string.equals(pHPexeItem.getPhpEXE().toString())) continue;
                return pHPexeItem;
            }
        }
        return null;
    }

    public PHPexeItem[] getItems(String string) {
        HashMap<String, PHPexeItem> hashMap = this.items.get(string);
        if (hashMap == null) {
            return null;
        }
        PHPexeItem[] pHPexeItemArray = new PHPexeItem[hashMap.size()];
        return hashMap.values().toArray(pHPexeItemArray);
    }

    public PHPexeItem[] getAllItems() {
        ArrayList<PHPexeItem> arrayList = new ArrayList<PHPexeItem>();
        Set<String> set = this.items.keySet();
        for (String string : set) {
            HashMap<String, PHPexeItem> hashMap = this.items.get(string);
            if (hashMap == null) continue;
            Collection<PHPexeItem> collection = hashMap.values();
            for (PHPexeItem pHPexeItem : collection) {
                arrayList.add(pHPexeItem);
            }
        }
        return arrayList.toArray(new PHPexeItem[arrayList.size()]);
    }

    private void load() {
        String[] stringArray;
        Preferences preferences = PHPProjectPreferences.getModelPreferences();
        this.items = new HashMap();
        this.loadExtensions();
        String string = preferences.getString(PHPDebugCorePreferenceNames.INSTALLED_PHP_NAMES);
        if (string == null) {
            string = "";
        }
        String[] stringArray2 = string.length() > 0 ? string.split(SEPARATOR) : new String[]{};
        String string2 = preferences.getString(PHPDebugCorePreferenceNames.INSTALLED_PHP_LOCATIONS);
        if (string2 == null) {
            string2 = "";
        }
        String[] stringArray3 = string2.length() > 0 ? string2.split(SEPARATOR) : new String[]{};
        String string3 = preferences.getString(PHPDebugCorePreferenceNames.INSTALLED_PHP_DEBUGGERS);
        if (string3 == null) {
            string3 = "";
        }
        String[] stringArray4 = string3.length() > 0 ? string3.split(SEPARATOR) : new String[]{};
        String string4 = preferences.getString(PHPDebugCorePreferenceNames.INSTALLED_PHP_DEFAULTS);
        if (string4 == null) {
            string4 = "";
        }
        String[] stringArray5 = stringArray = string4.length() > 0 ? string3.split(SEPARATOR) : new String[]{};
        assert (stringArray2.length == stringArray3.length);
        int n = 0;
        while (n < stringArray3.length) {
            PHPexeItem pHPexeItem = new PHPexeItem(stringArray2[n], stringArray3[n], stringArray4[n]);
            if (pHPexeItem.getPhpEXE() != null) {
                this.addItem(pHPexeItem);
            }
            if (Boolean.parseBoolean(stringArray[n])) {
                this.setDefaultItem(pHPexeItem);
            }
            ++n;
        }
    }

    private void loadExtensions() {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor(PHPDebugPlugin.getID(), "phpExe");
        boolean bl = System.getProperty("os.name").toLowerCase().startsWith("windows");
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            if ("phpExe".equals(iConfigurationElement.getName())) {
                String string = iConfigurationElement.getAttribute(NAME_ATTRIBUTE);
                String string2 = iConfigurationElement.getAttribute(LOCATION_ATTRIBUTE);
                String string3 = iConfigurationElement.getAttribute(VERSION_ATTRIBUTE);
                String string4 = iConfigurationElement.getAttribute(DEBUGGER_ID_ATTRIBUTE);
                if (string4 == null || string4.equals("")) {
                    string4 = "org.eclipse.php.debug.core.zendDebugger";
                }
                boolean bl2 = "true".equalsIgnoreCase(iConfigurationElement.getAttribute(DEFAULT_ATTRIBUTE));
                if (bl) {
                    string2 = String.valueOf(string2) + ".exe";
                }
                String string5 = iConfigurationElement.getDeclaringExtension().getNamespaceIdentifier();
                URL uRL = FileLocator.find((Bundle)Platform.getBundle((String)string5), (IPath)new Path(string2), new HashMap());
                boolean bl3 = false;
                if (uRL != null) {
                    try {
                        uRL = FileLocator.resolve((URL)uRL);
                        String string6 = uRL.getFile();
                        File file = new File(string6);
                        if (file.exists()) {
                            PHPexeItem pHPexeItem = new PHPexeItem(string, file, string4, false);
                            pHPexeItem.setVersion(string3);
                            this.addItem(pHPexeItem);
                            if (bl2) {
                                this.setDefaultItem(pHPexeItem);
                            }
                            bl3 = true;
                            if (!bl) {
                                UnixChmodUtil.chmod((String)string6, (int)493);
                            }
                        }
                    }
                    catch (IOException iOException) {}
                }
                if (!bl3) {
                    PHPDebugPlugin.getDefault().getLog().log((IStatus)new Status(1, PHPDebugPlugin.getID(), 1001, "PHP executable " + string2 + " not found neither in plugin " + string5 + " nor in fragments attached to it", null));
                }
            }
            ++n;
        }
    }

    public void removeItem(PHPexeItem pHPexeItem) {
        String string = pHPexeItem.getDebuggerID();
        HashMap<String, PHPexeItem> hashMap = this.items.get(string);
        PHPexeItem pHPexeItem2 = null;
        if (hashMap != null) {
            pHPexeItem2 = hashMap.remove(pHPexeItem.getName());
        }
        if (pHPexeItem2 != null && pHPexeItem2.isDefault()) {
            this.defaultItems.remove(string);
            Iterator<PHPexeItem> iterator = hashMap.values().iterator();
            if (iterator.hasNext()) {
                this.setDefaultItem(iterator.next());
            }
        }
    }

    public void setDefaultItem(PHPexeItem pHPexeItem) {
        String string = pHPexeItem.getDebuggerID();
        PHPexeItem pHPexeItem2 = this.defaultItems.get(string);
        if (pHPexeItem2 == pHPexeItem) {
            return;
        }
        if (pHPexeItem2 != null) {
            pHPexeItem2.setDefault(false);
        }
        pHPexeItem.setDefault(true);
        this.defaultItems.put(string, pHPexeItem);
    }

    public void setDefaultItem(String string, String string2) {
        PHPexeItem pHPexeItem = this.getItem(string, string2);
        if (pHPexeItem != null) {
            this.setDefaultItem(pHPexeItem);
        }
    }

    public void save() {
        Preferences preferences = PHPProjectPreferences.getModelPreferences();
        PHPexeItem[] pHPexeItemArray = this.getEditableItems();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        StringBuffer stringBuffer4 = new StringBuffer();
        int n = 0;
        while (n < pHPexeItemArray.length) {
            PHPexeItem pHPexeItem = pHPexeItemArray[n];
            if (n > 0) {
                stringBuffer.append(SEPARATOR);
                stringBuffer2.append(SEPARATOR);
                stringBuffer3.append(SEPARATOR);
                stringBuffer4.append(SEPARATOR);
            }
            stringBuffer.append(pHPexeItem.getLocation().toString());
            stringBuffer2.append(pHPexeItem.getName());
            stringBuffer3.append(pHPexeItem.getDebuggerID());
            stringBuffer4.append(pHPexeItem.isDefault());
            ++n;
        }
        preferences.setValue(PHPDebugCorePreferenceNames.INSTALLED_PHP_NAMES, stringBuffer2.toString());
        preferences.setValue(PHPDebugCorePreferenceNames.INSTALLED_PHP_LOCATIONS, stringBuffer.toString());
        preferences.setValue(PHPDebugCorePreferenceNames.INSTALLED_PHP_DEBUGGERS, stringBuffer3.toString());
        preferences.setValue(PHPDebugCorePreferenceNames.INSTALLED_PHP_DEFAULTS, stringBuffer4.toString());
        PHPDebugPlugin.getDefault().savePluginPreferences();
    }
}

