/*
 * Decompiled with CFR 0.152.
 */
package org.ini4j;

import java.beans.Introspector;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.util.TimeZone;

abstract class AbstractBeanInvocationHandler
implements InvocationHandler {
    private static final String ADD_PREFIX = "add";
    private static final int ADD_PREFIX_LEN = "add".length();
    private static final String HAS_PREFIX = "has";
    private static final int HAS_PREFIX_LEN = "has".length();
    private static final String PARSE_METHOD = "valueOf";
    private static final String PROPERTY_CHANGE_LISTENER = "PropertyChangeListener";
    private static final String READ_BOOLEAN_PREFIX = "is";
    private static final int READ_BOOLEAN_PREFIX_LEN = "is".length();
    private static final String READ_PREFIX = "get";
    private static final int READ_PREFIX_LEN = "get".length();
    private static final String REMOVE_PREFIX = "remove";
    private static final int REMOVE_PREFIX_LEN = "remove".length();
    private static final String VETOABLE_CHANGE_LISTENER = "VetoableChangeListener";
    private static final String WRITE_PREFIX = "set";
    private static final int WRITE_PREFIX_LEN = "set".length();
    private PropertyChangeSupport _pcSupport;
    private Object _proxy;
    private VetoableChangeSupport _vcSupport;

    protected static Object parseSpecialValue(String string, Class clazz) throws IllegalArgumentException {
        Object object;
        try {
            if (clazz == File.class) {
                object = new File(string);
            } else if (clazz == URL.class) {
                object = new URL(string);
            } else if (clazz == URI.class) {
                object = new URI(string);
            } else if (clazz == Class.class) {
                object = Class.forName(string);
            } else if (clazz == TimeZone.class) {
                object = TimeZone.getTimeZone(string);
            } else {
                Method method = clazz.getMethod(PARSE_METHOD, String.class);
                object = method.invoke(null, string);
            }
        }
        catch (Exception exception) {
            throw (IllegalArgumentException)new IllegalArgumentException().initCause(exception);
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static Object parseValue(String string, Class clazz) throws IllegalArgumentException {
        if (clazz == null) {
            throw new IllegalArgumentException("null argument");
        }
        Object object = null;
        if (string == null) {
            return AbstractBeanInvocationHandler.zero(clazz);
        }
        if (clazz.isPrimitive()) {
            try {
                if (clazz == Boolean.TYPE) {
                    return Boolean.valueOf(string);
                }
                if (clazz == Byte.TYPE) {
                    return Byte.valueOf(string);
                }
                if (clazz == Character.TYPE) {
                    return new Character(string.charAt(0));
                }
                if (clazz == Double.TYPE) {
                    return Double.valueOf(string);
                }
                if (clazz == Float.TYPE) {
                    return Float.valueOf(string);
                }
                if (clazz == Integer.TYPE) {
                    return Integer.valueOf(string);
                }
                if (clazz == Long.TYPE) {
                    return Long.valueOf(string);
                }
                if (clazz != Short.TYPE) return object;
                return Short.valueOf(string);
            }
            catch (Exception exception) {
                throw (IllegalArgumentException)new IllegalArgumentException().initCause(exception);
            }
        }
        if (clazz == String.class) {
            return string;
        }
        if (clazz != Character.class) return AbstractBeanInvocationHandler.parseSpecialValue(string, clazz);
        return new Character(string.charAt(0));
    }

    protected static Object zero(Class clazz) {
        Comparable<Boolean> comparable = null;
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                comparable = Boolean.FALSE;
            } else if (clazz == Byte.TYPE) {
                comparable = new Byte(0);
            } else if (clazz == Character.TYPE) {
                comparable = new Character('\u0000');
            } else if (clazz == Double.TYPE) {
                comparable = new Double(0.0);
            } else if (clazz == Float.TYPE) {
                comparable = new Float(0.0f);
            } else if (clazz == Integer.TYPE) {
                comparable = new Integer(0);
            } else if (clazz == Long.TYPE) {
                comparable = new Long(0L);
            } else if (clazz == Short.TYPE) {
                comparable = new Short(0);
            }
        }
        return comparable;
    }

    protected AbstractBeanInvocationHandler() {
    }

    protected synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (this._pcSupport == null) {
            this._pcSupport = new PropertyChangeSupport(this._proxy);
        }
        this._pcSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    protected synchronized void addVetoableChangeListener(String string, VetoableChangeListener vetoableChangeListener) {
        if (this._vcSupport == null) {
            this._vcSupport = new VetoableChangeSupport(this._proxy);
        }
        this._vcSupport.addVetoableChangeListener(string, vetoableChangeListener);
    }

    protected synchronized void firePropertyChange(String string, Object object, Object object2) {
        if (this._pcSupport != null) {
            this._pcSupport.firePropertyChange(string, object, object2);
        }
    }

    protected synchronized void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        if (this._vcSupport != null) {
            this._vcSupport.fireVetoableChange(string, object, object2);
        }
    }

    protected synchronized Object getProperty(String string, Class clazz) {
        Object object;
        try {
            object = this.getPropertySpi(string, clazz);
            if (object == null) {
                object = AbstractBeanInvocationHandler.zero(clazz);
            } else if (object instanceof String && !clazz.equals(String.class)) {
                object = AbstractBeanInvocationHandler.parseValue((String)object, clazz);
            }
        }
        catch (Exception exception) {
            object = AbstractBeanInvocationHandler.zero(clazz);
        }
        return object;
    }

    protected abstract Object getPropertySpi(String var1, Class var2);

    protected synchronized Object getProxy() {
        return this._proxy;
    }

    protected synchronized boolean hasProperty(String string) {
        boolean bl;
        try {
            bl = this.hasPropertySpi(string);
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    protected abstract boolean hasPropertySpi(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object object, Method method, Object[] objectArray) throws PropertyVetoException {
        Object object2 = null;
        String string = method.getName();
        Object object3 = this;
        synchronized (object3) {
            if (this._proxy == null) {
                this._proxy = object;
            }
        }
        if (string.startsWith(READ_PREFIX)) {
            String string2 = Introspector.decapitalize(string.substring(READ_PREFIX_LEN));
            object2 = this.getProperty(string2, method.getReturnType());
        } else if (string.startsWith(READ_BOOLEAN_PREFIX)) {
            String string3 = Introspector.decapitalize(string.substring(READ_BOOLEAN_PREFIX_LEN));
            object2 = this.getProperty(string3, method.getReturnType());
        } else if (string.startsWith(WRITE_PREFIX)) {
            String string4 = Introspector.decapitalize(string.substring(WRITE_PREFIX_LEN));
            this.setProperty(string4, objectArray[0], method.getParameterTypes()[0]);
        } else if (string.startsWith(ADD_PREFIX)) {
            object3 = string.substring(ADD_PREFIX_LEN);
            if (((String)object3).equals(PROPERTY_CHANGE_LISTENER)) {
                this.addPropertyChangeListener((String)objectArray[0], (PropertyChangeListener)objectArray[1]);
            } else if (((String)object3).equals(VETOABLE_CHANGE_LISTENER)) {
                this.addVetoableChangeListener((String)objectArray[0], (VetoableChangeListener)objectArray[1]);
            }
        } else if (string.startsWith(REMOVE_PREFIX)) {
            object3 = string.substring(REMOVE_PREFIX_LEN);
            if (((String)object3).equals(PROPERTY_CHANGE_LISTENER)) {
                this.removePropertyChangeListener((String)objectArray[0], (PropertyChangeListener)objectArray[1]);
            } else if (((String)object3).equals(VETOABLE_CHANGE_LISTENER)) {
                this.removeVetoableChangeListener((String)objectArray[0], (VetoableChangeListener)objectArray[1]);
            }
        } else if (string.startsWith(HAS_PREFIX)) {
            String string5 = Introspector.decapitalize(string.substring(HAS_PREFIX_LEN));
            object2 = this.hasProperty(string5);
        }
        return object2;
    }

    protected synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (this._pcSupport != null) {
            this._pcSupport.removePropertyChangeListener(string, propertyChangeListener);
        }
    }

    protected synchronized void removeVetoableChangeListener(String string, VetoableChangeListener vetoableChangeListener) {
        if (this._vcSupport != null) {
            this._vcSupport.removeVetoableChangeListener(string, vetoableChangeListener);
        }
    }

    protected synchronized void setProperty(String string, Object object, Class clazz) throws PropertyVetoException {
        try {
            Object object2;
            boolean bl = this._pcSupport != null && this._pcSupport.hasListeners(string);
            boolean bl2 = this._vcSupport != null && this._vcSupport.hasListeners(string);
            Object object3 = object2 = bl || bl2 ? this.getProperty(string, clazz) : null;
            if (bl2) {
                this.fireVetoableChange(string, object2, object);
            }
            if (clazz.equals(String.class) && !(object instanceof String)) {
                object = object.toString();
            }
            this.setPropertySpi(string, object, clazz);
            if (bl) {
                this.firePropertyChange(string, object2, object);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            throw propertyVetoException;
        }
        catch (Exception exception) {}
    }

    protected abstract void setPropertySpi(String var1, Object var2, Class var3);
}

