/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.IRunToLineTarget;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextManager;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.internal.debug.ui.actions.XDebugRunToLineTarget;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;

public class XDebugRunToLine
implements IEditorActionDelegate,
IActionDelegate2,
IViewActionDelegate {
    private IWorkbenchPart fActivePart = null;
    private IRunToLineTarget fPartTarget = null;
    private IAction fAction = null;
    private DebugContextListener fContextListener = new DebugContextListener();
    private ISuspendResume fTargetElement = null;

    public void dispose() {
        DebugUITools.getDebugContextManager().getContextService(this.fActivePart.getSite().getWorkbenchWindow()).removeDebugContextListener((IDebugContextListener)this.fContextListener);
        this.fActivePart = null;
        this.fPartTarget = null;
    }

    public void run(IAction iAction) {
        if (this.fPartTarget != null && this.fTargetElement != null) {
            try {
                this.fPartTarget.runToLine(this.fActivePart, this.fActivePart.getSite().getSelectionProvider().getSelection(), this.fTargetElement);
            }
            catch (CoreException coreException) {
                DebugUIPlugin.errorDialog((Shell)this.fActivePart.getSite().getWorkbenchWindow().getShell(), (String)ActionMessages.RunToLineAction_0, (String)ActionMessages.RunToLineAction_1, (IStatus)coreException.getStatus());
            }
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        this.fAction = iAction;
        this.update();
    }

    public void update() {
        if (this.fAction == null) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                ISelectionProvider iSelectionProvider;
                IWorkbenchPartSite iWorkbenchPartSite;
                boolean bl = false;
                if (XDebugRunToLine.this.fPartTarget != null && XDebugRunToLine.this.fTargetElement != null && (iWorkbenchPartSite = XDebugRunToLine.this.fActivePart.getSite()) != null && (iSelectionProvider = iWorkbenchPartSite.getSelectionProvider()) != null) {
                    ISelection iSelection = iSelectionProvider.getSelection();
                    bl = XDebugRunToLine.this.fTargetElement.isSuspended() && XDebugRunToLine.this.fPartTarget.canRunToLine(XDebugRunToLine.this.fActivePart, iSelection, XDebugRunToLine.this.fTargetElement);
                }
                XDebugRunToLine.this.fAction.setEnabled(bl);
            }
        };
        DebugUIPlugin.getStandardDisplay().asyncExec(runnable);
    }

    public void init(IAction iAction) {
        this.fAction = iAction;
        if (iAction != null) {
            iAction.setText(ActionMessages.RunToLineActionDelegate_4);
            iAction.setImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_LCL_RUN_TO_LINE"));
            iAction.setDisabledImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_DLCL_RUN_TO_LINE"));
        }
    }

    public void runWithEvent(IAction iAction, Event event) {
        this.run(iAction);
    }

    public void setActiveEditor(IAction iAction, IEditorPart iEditorPart) {
        this.init(iAction);
        this.bindTo((IWorkbenchPart)iEditorPart);
    }

    public void init(IViewPart iViewPart) {
        this.bindTo((IWorkbenchPart)iViewPart);
    }

    private void bindTo(IWorkbenchPart iWorkbenchPart) {
        IDebugContextManager iDebugContextManager = DebugUITools.getDebugContextManager();
        if (this.fActivePart != null && !this.fActivePart.equals(iWorkbenchPart)) {
            iDebugContextManager.getContextService(this.fActivePart.getSite().getWorkbenchWindow()).removeDebugContextListener((IDebugContextListener)this.fContextListener);
        }
        this.fPartTarget = null;
        this.fActivePart = iWorkbenchPart;
        if (iWorkbenchPart != null) {
            ISelection iSelection;
            IWorkbenchWindow iWorkbenchWindow = iWorkbenchPart.getSite().getWorkbenchWindow();
            IDebugContextService iDebugContextService = iDebugContextManager.getContextService(iWorkbenchWindow);
            iDebugContextService.addDebugContextListener((IDebugContextListener)this.fContextListener);
            if (iWorkbenchPart instanceof PHPStructuredEditor) {
                this.fPartTarget = new XDebugRunToLineTarget();
            } else {
                this.fPartTarget = (IRunToLineTarget)iWorkbenchPart.getAdapter(IRunToLineTarget.class);
                if (this.fPartTarget == null && (iSelection = Platform.getAdapterManager()).hasAdapter((Object)iWorkbenchPart, IRunToLineTarget.class.getName())) {
                    this.fPartTarget = (IRunToLineTarget)iSelection.loadAdapter((Object)iWorkbenchPart, IRunToLineTarget.class.getName());
                }
            }
            iSelection = iDebugContextService.getActiveContext();
            this.fContextListener.contextActivated(iSelection);
        }
        this.update();
    }

    class DebugContextListener
    implements IDebugContextListener {
        DebugContextListener() {
        }

        protected void contextActivated(ISelection iSelection) {
            Object object;
            IStructuredSelection iStructuredSelection;
            XDebugRunToLine.this.fTargetElement = null;
            if (iSelection instanceof IStructuredSelection && (iStructuredSelection = (IStructuredSelection)iSelection).size() == 1 && (object = iStructuredSelection.getFirstElement()) instanceof ISuspendResume) {
                XDebugRunToLine.this.fTargetElement = (ISuspendResume)object;
            }
            XDebugRunToLine.this.update();
        }

        public void debugContextChanged(DebugContextEvent debugContextEvent) {
            this.contextActivated(debugContextEvent.getContext());
        }
    }
}

