/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp.model;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IStep;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.php.internal.debug.core.xdebug.XDebugPreferenceInit;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpBreakpoint;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpBreakpointFacade;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpLogger;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpPreferences;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.extensionpoints.FilenameMapperRegistry;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.extensionpoints.IFileMapper;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpElement;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpStackFrame;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpThread;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpVariable;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.TimedEvent;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.Base64;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.DBGpResponse;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.DBGpUtils;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.session.DBGpSession;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.session.DBGpSessionHandler;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.session.DBGpSessionListener;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.browser.IWebBrowser;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DBGpTarget
extends DBGpElement
implements IDebugTarget,
IStep,
IBreakpointManagerListener,
DBGpSessionListener {
    private String sessionID;
    private String ideKey;
    private boolean webLaunch = false;
    private IProcess process;
    private IWebBrowser browser;
    private String stopDebugURL;
    private volatile int targetState;
    private static final int STATE_CREATE = 0;
    private static final int STATE_INIT_SESSION_WAIT = 1;
    private static final int STATE_STARTED_SUSPENDED = 2;
    private static final int STATE_STARTED_RUNNING = 3;
    private static final int STATE_STARTED_SESSION_WAIT = 4;
    private static final int STATE_TERMINATING = 5;
    private static final int STATE_TERMINATED = 6;
    private static final int STATE_DISCONNECTED = 7;
    private String progName;
    private ILaunch launch;
    private DBGpThread langThread;
    private IThread[] allThreads;
    private boolean refreshStackFrames;
    private int currentStackLevel;
    private IStackFrame[] stackFrames;
    private DBGpBreakpointFacade bpFacade;
    private IVariable[] superGlobalVars;
    private Vector DBGpCmdQueue = new Vector();
    private volatile DBGpSession session;
    private DBGpPreferences sessionPreferences;
    private Object sessionMutex = new Object();
    private TimedEvent te = new TimedEvent();
    private boolean stopAtStart;
    private boolean asyncSupported;
    private boolean stepping;
    private int maxChildren = 0;

    private DBGpTarget() {
        super(null);
        this.setState(0);
        this.ideKey = DBGpSessionHandler.getInstance().getIDEKey();
        this.allThreads = new IThread[0];
        this.fireCreationEvent();
    }

    public DBGpTarget(ILaunch iLaunch, IProcess iProcess, String string, String string2, String string3, boolean bl) throws CoreException {
        this();
        this.stopAtStart = bl;
        this.launch = iLaunch;
        this.progName = string;
        this.ideKey = string2;
        this.webLaunch = false;
        this.sessionID = string3;
        this.process = null;
        this.stopDebugURL = null;
        this.browser = null;
    }

    public DBGpTarget(ILaunch iLaunch, String string, String string2, String string3, String string4, boolean bl, IWebBrowser iWebBrowser) {
        this();
        this.stopAtStart = bl;
        this.launch = iLaunch;
        this.progName = string;
        this.ideKey = string3;
        this.webLaunch = true;
        this.sessionID = null;
        this.stopDebugURL = string2;
        this.browser = iWebBrowser;
        this.process = null;
    }

    public void waitForInitialSession(DBGpBreakpointFacade dBGpBreakpointFacade, DBGpPreferences dBGpPreferences, IProgressMonitor iProgressMonitor) {
        this.bpFacade = dBGpBreakpointFacade;
        this.sessionPreferences = dBGpPreferences;
        this.setState(1);
        try {
            while (!(this.session != null || this.launch.isTerminated() || this.isTerminating() || iProgressMonitor.isCanceled())) {
                this.te.waitForEvent(XDebugPreferenceInit.getTimeoutDefault());
            }
            if (this.session != null && this.session.isActive()) {
                if (!(this.isTerminating() || this.launch.isTerminated() || iProgressMonitor.isCanceled())) {
                    this.langThread = new DBGpThread(this);
                    this.allThreads = new IThread[]{this.langThread};
                    this.langThread.fireCreationEvent();
                    DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointListener)this);
                    this.initiateSession();
                } else {
                    this.session.endSession();
                    this.terminateDebugTarget(true);
                }
            } else {
                this.terminateDebugTarget(true);
            }
        }
        catch (Exception exception) {
            this.terminateDebugTarget(true);
        }
    }

    private void initiateSession() {
        if (this.targetState != 1 && this.targetState != 4) {
            DBGpLogger.logWarning("initiateSession in Wrong State: " + this.targetState, this, null);
        }
        this.refreshStackFrames = true;
        this.superGlobalVars = null;
        this.session.startSession();
        this.setState(2);
        try {
            this.loadPredefinedBreakpoints();
            this.negotiateDBGpFeatures();
            if (!this.stopAtStart) {
                if (this.session != null) {
                    this.session.sendAsyncCmd("run");
                    this.setState(3);
                }
            } else {
                this.suspended(16);
                this.stepInto();
            }
        }
        catch (DebugException debugException) {}
    }

    public IProcess getProcess() {
        return this.process;
    }

    public void setProcess(IProcess iProcess) {
        this.process = iProcess;
    }

    public IThread[] getThreads() throws DebugException {
        return this.allThreads;
    }

    public boolean hasThreads() throws DebugException {
        boolean bl = this.allThreads.length > 0;
        return bl;
    }

    public String getName() throws DebugException {
        if (this.progName == null) {
            this.progName = this.process == null ? "Remote Launch" : "Unknown PHP Program";
        }
        return this.progName;
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public boolean canTerminate() {
        boolean bl;
        boolean bl2 = bl = 6 != this.targetState && this.targetState != 0 && 7 != this.targetState;
        if (this.process != null) {
            bl = bl && this.process.canTerminate();
        }
        return bl;
    }

    public boolean isTerminated() {
        boolean bl;
        boolean bl2 = bl = 6 == this.targetState;
        if (this.process != null) {
            return this.process.isTerminated();
        }
        return bl;
    }

    public boolean isTerminating() {
        boolean bl = this.targetState == 6 || this.targetState == 5;
        return bl;
    }

    public boolean hasStarted() {
        boolean bl = 3 == this.targetState || 4 == this.targetState || 2 == this.targetState;
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() throws DebugException {
        if (this.isTerminating()) {
            if (this.session == null && 5 == this.targetState) {
                this.terminateDebugTarget(true);
            }
            return;
        }
        DBGpSessionHandler.getInstance().removeSessionListener(this);
        if (2 == this.targetState) {
            Object object = this.sessionMutex;
            synchronized (object) {
                if (this.session != null) {
                    this.setState(5);
                    this.session.sendAsyncCmd("stop");
                } else {
                    this.terminateDebugTarget(true);
                }
            }
        } else {
            this.terminateDebugTarget(true);
            if (this.isWebLaunch()) {
                this.sendStopDebugURL();
            }
        }
    }

    private void sendStopDebugURL() {
        if (this.stopDebugURL == null) {
            return;
        }
        try {
            if (this.browser != null) {
                DBGpLogger.debug("browser is not null, sending " + this.stopDebugURL);
                this.browser.openURL(new URL(this.stopDebugURL));
            } else {
                DBGpUtils.openInternalBrowserView(this.stopDebugURL);
            }
        }
        catch (PartInitException partInitException) {
            DBGpLogger.logException("Failed to send stop URL: " + this.stopDebugURL, this, partInitException);
        }
        catch (MalformedURLException malformedURLException) {
            DBGpLogger.logException(null, this, malformedURLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionEnded() {
        Object object = this.sessionMutex;
        synchronized (object) {
            this.session = null;
        }
        if (5 == this.targetState) {
            if (this.isWebLaunch()) {
                this.sendStopDebugURL();
            }
            this.terminateDebugTarget(true);
        } else if (this.isWebLaunch()) {
            this.setState(4);
            this.stepping = false;
            this.langThread.setBreakpoints(null);
        } else {
            this.terminateDebugTarget(true);
        }
    }

    public void terminateDebugTarget(boolean bl) {
        if (6 != this.targetState) {
            DBGpSessionHandler.getInstance().removeSessionListener(this);
            DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
            if (bl && 3 == this.targetState) {
                this.setState(5);
                if (this.process != null) {
                    try {
                        this.process.terminate();
                    }
                    catch (DebugException debugException) {}
                } else if (this.session != null) {
                    this.session.endSession();
                }
            }
            this.setState(6);
            if (this.session != null) {
                this.session.endSession();
            }
            if (this.langThread != null) {
                this.langThread.fireTerminateEvent();
            }
            this.fireTerminateEvent();
        }
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long l, long l2) throws DebugException {
        return null;
    }

    public boolean canResume() {
        return !this.isTerminated() && this.isSuspended();
    }

    public boolean canSuspend() {
        return this.asyncSupported;
    }

    public boolean isSuspended() {
        boolean bl = 2 == this.targetState;
        return bl;
    }

    public boolean canStepInto() {
        return this.isSuspended();
    }

    public boolean canStepOver() {
        return this.isSuspended();
    }

    public boolean canStepReturn() {
        try {
            if (this.isSuspended() && this.getStackFrames().length > 1) {
                return true;
            }
        }
        catch (DebugException debugException) {}
        return false;
    }

    public boolean isStepping() {
        return this.stepping;
    }

    public void stepInto() throws DebugException {
        this.stepping = true;
        this.resumed(1);
        this.session.sendAsyncCmd("step_into");
    }

    public void stepOver() throws DebugException {
        this.stepping = true;
        this.resumed(2);
        this.session.sendAsyncCmd("step_over");
    }

    public void stepReturn() throws DebugException {
        this.stepping = true;
        this.resumed(4);
        this.session.sendAsyncCmd("step_out");
    }

    public void resume() throws DebugException {
        this.stepping = false;
        this.resumed(1);
        if (this.session != null) {
            this.session.sendAsyncCmd("run");
        }
    }

    public void suspend() throws DebugException {
        this.session.sendAsyncCmd("break");
    }

    public boolean canDisconnect() {
        boolean bl = 3 == this.targetState || 2 == this.targetState;
        return bl;
    }

    public void disconnect() throws DebugException {
        if (this.isTerminating()) {
            return;
        }
        if (3 == this.targetState || 2 == this.targetState) {
            this.setState(7);
            if (this.session != null) {
                if (this.process != null) {
                    this.session.sendAsyncCmd("detach");
                    this.terminateDebugTarget(false);
                } else {
                    this.session.sendSyncCmd("stop");
                    this.stepping = false;
                    this.langThread.setBreakpoints(null);
                    this.setState(4);
                    this.resumed(1);
                }
            }
        }
    }

    public boolean isDisconnected() {
        return 7 == this.targetState || 6 == this.targetState;
    }

    private void resumed(int n) {
        this.setState(3);
        this.fireResumeEvent(n);
        this.langThread.fireResumeEvent(n);
    }

    public void suspended(int n) {
        this.setState(2);
        this.processQueuedBpCmds();
        this.refreshStackFrames = true;
        this.fireSuspendEvent(n);
        this.langThread.fireSuspendEvent(n);
    }

    private void negotiateDBGpFeatures() {
        String string;
        Node node;
        DBGpResponse dBGpResponse = this.session.sendSyncCmd("feature_set", "-n show_hidden -v 1");
        DBGpUtils.isGoodDBGpResponse(this, dBGpResponse);
        dBGpResponse = this.session.sendSyncCmd("feature_set", "-n max_depth -v " + this.getMaxDepth());
        DBGpUtils.isGoodDBGpResponse(this, dBGpResponse);
        dBGpResponse = this.session.sendSyncCmd("feature_get", "-n max_children");
        if (DBGpUtils.isGoodDBGpResponse(this, dBGpResponse) && (node = dBGpResponse.getParentNode().getFirstChild()) != null) {
            string = node.getNodeValue();
            try {
                this.maxChildren = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.maxChildren = -1;
            }
        }
        if (DBGpUtils.isGoodDBGpResponse(this, dBGpResponse = this.session.sendSyncCmd("feature_get", "-n encoding")) && (node = dBGpResponse.getParentNode().getFirstChild()) != null) {
            string = node.getNodeValue();
            try {
                "abcdefg".getBytes(string);
                this.session.setSessionEncoding(string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                DBGpLogger.logWarning("encoding from debug engine invalid", this, unsupportedEncodingException);
            }
        }
        this.asyncSupported = false;
        dBGpResponse = this.session.sendSyncCmd("feature_get", "-n supports_async");
        if (DBGpUtils.isGoodDBGpResponse(this, dBGpResponse) && (string = DBGpResponse.getAttribute(node = dBGpResponse.getParentNode().getFirstChild(), "supported")) != null && string.equals("1")) {
            this.asyncSupported = true;
        }
    }

    protected synchronized IStackFrame[] getStackFrames() throws DebugException {
        if (this.refreshStackFrames) {
            this.refreshStackFrames = false;
            DBGpResponse dBGpResponse = this.session.sendSyncCmd("stack_get");
            if (DBGpUtils.isGoodDBGpResponse(this, dBGpResponse)) {
                Node node = dBGpResponse.getParentNode();
                NodeList nodeList = node.getChildNodes();
                this.stackFrames = new IStackFrame[nodeList.getLength()];
                int n = 0;
                while (n < nodeList.getLength()) {
                    Node node2 = nodeList.item(n);
                    this.stackFrames[n] = new DBGpStackFrame(this.langThread, node2);
                    ++n;
                }
                this.currentStackLevel = nodeList.getLength() - 1;
            } else {
                this.currentStackLevel = 0;
                this.stackFrames = new IStackFrame[0];
            }
        }
        return this.stackFrames;
    }

    private IVariable[] getContextLocalVars(String string) {
        DBGpResponse dBGpResponse = this.session.sendSyncCmd("context_get", "-d " + string);
        return this.parseVarResp(dBGpResponse, string);
    }

    private IVariable[] getSuperGlobalVars() {
        if (this.superGlobalVars == null) {
            DBGpResponse dBGpResponse = this.session.sendSyncCmd("context_get", "-c 1");
            this.superGlobalVars = this.parseVarResp(dBGpResponse, "-1");
        }
        return this.superGlobalVars;
    }

    public IVariable[] getAllVars(String string) {
        boolean bl = this.showGLobals();
        IVariable[] iVariableArray = null;
        iVariableArray = bl ? this.getSuperGlobalVars() : new IVariable[]{};
        IVariable[] iVariableArray2 = this.getContextLocalVars(string);
        int n = iVariableArray.length + iVariableArray2.length;
        IVariable[] iVariableArray3 = new IVariable[n];
        if (iVariableArray.length > 0) {
            System.arraycopy(iVariableArray, 0, iVariableArray3, 0, iVariableArray.length);
        }
        if (iVariableArray2.length > 0) {
            System.arraycopy(iVariableArray2, 0, iVariableArray3, iVariableArray.length, iVariableArray2.length);
        }
        return iVariableArray3;
    }

    private IVariable[] parseVarResp(DBGpResponse dBGpResponse, String string) {
        IVariable[] iVariableArray = new IVariable[]{};
        if (dBGpResponse.getErrorCode() == 0) {
            Node node = dBGpResponse.getParentNode();
            NodeList nodeList = node.getChildNodes();
            iVariableArray = new DBGpVariable[nodeList.getLength()];
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node2 = nodeList.item(n);
                iVariableArray[n] = new DBGpVariable((DBGpTarget)this.getDebugTarget(), node2, string);
                ++n;
            }
        }
        return iVariableArray;
    }

    public boolean setProperty(DBGpVariable dBGpVariable, String string) {
        DBGpResponse dBGpResponse;
        String string2 = new String(Base64.encode(string.getBytes()));
        String string3 = dBGpVariable.getFullName();
        String string4 = dBGpVariable.getStackLevel();
        String string5 = "-n " + string3 + " -d " + string4 + " -l " + string2.length() + " -- " + string2;
        try {
            if (dBGpVariable.getReferenceTypeName().equals("string")) {
                string5 = "-t string " + string5;
            }
        }
        catch (DebugException debugException) {}
        return (dBGpResponse = this.session.sendSyncCmd("property_set", string5)).getTopAttribute("success").equals("1");
    }

    public Node getProperty(String string, String string2, int n) {
        String string3 = "-n " + string + " -d " + string2 + " -p " + n;
        if (string2.equals("-1")) {
            string3 = "-n " + string + " -d " + this.getCurrentStackLevel() + " -p " + n;
        }
        DBGpResponse dBGpResponse = this.session.sendSyncCmd("property_get", string3);
        return dBGpResponse.getParentNode().getFirstChild();
    }

    public Node eval(String string) {
        String string2 = new String(Base64.encode(string.getBytes()));
        String string3 = "-- " + string2;
        DBGpResponse dBGpResponse = this.session.sendSyncCmd("eval", string3);
        return dBGpResponse.getParentNode().getFirstChild();
    }

    private synchronized void setState(int n) {
        if (DBGpLogger.debugState()) {
            String string = "";
            switch (n) {
                case 0: {
                    string = "STATE_CREATE";
                    break;
                }
                case 7: {
                    string = "STATE_DISCONNECTED";
                    break;
                }
                case 1: {
                    string = "INIT_SESSION_WAIT";
                    break;
                }
                case 3: {
                    string = "STATE_STARTED_RUNNING";
                    break;
                }
                case 4: {
                    string = "STATE_STARTED_SESSION_WAIT";
                    break;
                }
                case 2: {
                    string = "STATE_STARTED_SUSPENDED";
                    break;
                }
                case 6: {
                    string = "STATE_TERMINATED";
                    break;
                }
                case 5: {
                    string = "STATE_TERMINATING";
                }
            }
            DBGpLogger.debug("State Change: " + string);
        }
        this.targetState = n;
    }

    public int getCurrentStackLevel() {
        return this.currentStackLevel;
    }

    public int getMaxChildren() {
        return this.maxChildren;
    }

    public String mapInboundFileIfRequired(String string) {
        IFileMapper iFileMapper;
        String string2 = string;
        if (this.webLaunch && (iFileMapper = FilenameMapperRegistry.getRegistry().getActiveMapper()) != null) {
            try {
                string2 = iFileMapper.mapExternalFileToWorkspace(string, this.launch.getLaunchConfiguration());
            }
            catch (Exception exception) {}
        }
        return string2;
    }

    public boolean supportsBreakpoint(IBreakpoint iBreakpoint) {
        return this.bpFacade.supportsBreakpoint(iBreakpoint);
    }

    public void breakpointAdded(IBreakpoint iBreakpoint) {
        if (!DebugPlugin.getDefault().getBreakpointManager().isEnabled()) {
            return;
        }
        if (this.supportsBreakpoint(iBreakpoint)) {
            try {
                if (iBreakpoint.isEnabled()) {
                    DBGpBreakpoint dBGpBreakpoint = this.bpFacade.createDBGpBreakpoint(iBreakpoint);
                    if (this.asyncSupported || this.isSuspended()) {
                        if (DBGpLogger.debugBP()) {
                            DBGpLogger.debug("Breakpoint Add requested immediately");
                        }
                        this.sendBreakpointAddCmd(dBGpBreakpoint, false);
                    } else {
                        if (DBGpLogger.debugBP()) {
                            DBGpLogger.debug("Breakpoint Add deferred until suspended");
                        }
                        DBGpBreakpointCmd dBGpBreakpointCmd = new DBGpBreakpointCmd("breakpoint_set", dBGpBreakpoint);
                        this.queueBpCmd(dBGpBreakpointCmd);
                    }
                }
            }
            catch (CoreException coreException) {
                DBGpLogger.logException("Exception adding breakpoint", this, coreException);
            }
        }
    }

    private void sendBreakpointAddCmd(DBGpBreakpoint dBGpBreakpoint, boolean bl) {
        Object object;
        Object object2;
        dBGpBreakpoint.resetConditionChanged();
        String string = dBGpBreakpoint.getFileName();
        int n = dBGpBreakpoint.getLineNumber();
        String string2 = null;
        if (DBGpLogger.debugBP()) {
            string2 = "adding breakpoint to file:" + string + ", at Line Number: " + n;
        }
        DBGpBreakpointCondition dBGpBreakpointCondition = new DBGpBreakpointCondition(dBGpBreakpoint);
        if (this.webLaunch && (object2 = FilenameMapperRegistry.getRegistry().getActiveMapper()) != null) {
            try {
                object = object2.mapWorkspaceFileToExternal(dBGpBreakpoint.getIFile(), this.launch.getLaunchConfiguration());
                if (object != null) {
                    string = object;
                }
            }
            catch (Exception exception) {}
        }
        object2 = "-t line -f " + DBGpUtils.getFileURIString(string) + " -n " + n;
        if (dBGpBreakpointCondition.getType() == 2) {
            if (string2 != null) {
                string2 = String.valueOf(string2) + " with expression:" + dBGpBreakpointCondition.getExpression();
            }
            object2 = String.valueOf(object2) + " -- " + new String(Base64.encode(dBGpBreakpointCondition.getExpression().getBytes()));
        } else if (dBGpBreakpointCondition.getType() == 1) {
            if (string2 != null) {
                string2 = String.valueOf(string2) + " with hit :" + dBGpBreakpointCondition.getHitCondition() + dBGpBreakpointCondition.getHitValue();
            }
            object2 = String.valueOf(object2) + " -h " + dBGpBreakpointCondition.getHitValue() + " -o " + dBGpBreakpointCondition.hitCondition;
        }
        if (string2 != null) {
            DBGpLogger.debug(string2);
        }
        if (DBGpUtils.isGoodDBGpResponse(this, (DBGpResponse)(object = bl ? this.session.sendSyncCmdOnResponseThread("breakpoint_set", (String)object2) : this.session.sendSyncCmd("breakpoint_set", (String)object2)))) {
            String string3 = ((DBGpResponse)object).getTopAttribute("id");
            dBGpBreakpoint.setID(Integer.parseInt(string3));
            if (DBGpLogger.debugBP()) {
                DBGpLogger.debug("Breakpoint installed with id: " + string3);
            }
        }
    }

    public void breakpointRemoved(IBreakpoint iBreakpoint, IMarkerDelta iMarkerDelta) {
        if (this.supportsBreakpoint(iBreakpoint)) {
            DBGpBreakpoint dBGpBreakpoint = this.bpFacade.createDBGpBreakpoint(iBreakpoint);
            if (this.asyncSupported || this.isSuspended()) {
                if (DBGpLogger.debugBP()) {
                    DBGpLogger.debug("Immediately removing of breakpoint with ID: " + dBGpBreakpoint.getID());
                }
                this.sendBreakpointRemoveCmd(dBGpBreakpoint, false);
            } else {
                if (DBGpLogger.debugBP()) {
                    DBGpLogger.debug("Deferring Removing of breakpoint with ID: " + dBGpBreakpoint.getID());
                }
                DBGpBreakpointCmd dBGpBreakpointCmd = new DBGpBreakpointCmd("breakpoint_remove", dBGpBreakpoint);
                this.queueBpCmd(dBGpBreakpointCmd);
            }
        }
    }

    private void sendBreakpointRemoveCmd(DBGpBreakpoint dBGpBreakpoint, boolean bl) {
        String string = "-d " + dBGpBreakpoint.getID();
        if (DBGpLogger.debugBP()) {
            DBGpLogger.debug("Removing breakpoint with ID: " + dBGpBreakpoint.getID());
        }
        DBGpResponse dBGpResponse = bl ? this.session.sendSyncCmdOnResponseThread("breakpoint_remove", string) : this.session.sendSyncCmd("breakpoint_remove", string);
        DBGpUtils.isGoodDBGpResponse(this, dBGpResponse);
    }

    public void breakpointChanged(IBreakpoint iBreakpoint, IMarkerDelta iMarkerDelta) {
        IBreakpointManager iBreakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        if (!iBreakpointManager.isEnabled()) {
            return;
        }
        int n = iMarkerDelta.getAttribute("lineNumber", 0);
        IMarker iMarker = iBreakpoint.getMarker();
        int n2 = iMarker.getAttribute("lineNumber", 0);
        if (this.supportsBreakpoint(iBreakpoint)) {
            try {
                DBGpBreakpoint dBGpBreakpoint = this.bpFacade.createDBGpBreakpoint(iBreakpoint);
                if (dBGpBreakpoint.hasConditionChanged()) {
                    if (DBGpLogger.debugBP()) {
                        DBGpLogger.debug("condition changed for breakpoint with ID: " + dBGpBreakpoint.getID());
                    }
                    dBGpBreakpoint.resetConditionChanged();
                    if (iBreakpoint.isEnabled()) {
                        this.breakpointRemoved(iBreakpoint, null);
                    } else {
                        return;
                    }
                }
                if (n2 != n) {
                    if (DBGpLogger.debugBP()) {
                        DBGpLogger.debug("line number changed for breakpoint with ID: " + dBGpBreakpoint.getID());
                    }
                    if (iBreakpoint.isEnabled()) {
                        this.breakpointRemoved(iBreakpoint, null);
                    } else {
                        return;
                    }
                }
                if (iBreakpoint.isEnabled()) {
                    this.breakpointAdded(iBreakpoint);
                } else {
                    this.breakpointRemoved(iBreakpoint, null);
                }
            }
            catch (CoreException coreException) {
                DBGpLogger.logException("Exception Changing Breakpoint", this, coreException);
            }
        }
    }

    public void breakpointHit(String string, int n) {
        IBreakpoint iBreakpoint = this.findBreakpointHit(string, n);
        if (iBreakpoint != null) {
            this.langThread.setBreakpoints(new IBreakpoint[]{iBreakpoint});
        } else {
            this.langThread.setBreakpoints(new IBreakpoint[0]);
        }
        this.suspended(16);
    }

    private IBreakpoint findBreakpointHit(String string, int n) {
        return this.bpFacade.findBreakpointHit(string, n);
    }

    private void loadPredefinedBreakpoints() {
        IBreakpointManager iBreakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        if (!iBreakpointManager.isEnabled()) {
            return;
        }
        IBreakpoint[] iBreakpointArray = iBreakpointManager.getBreakpoints(this.bpFacade.getBreakpointModelID());
        int n = 0;
        while (n < iBreakpointArray.length) {
            this.breakpointAdded(iBreakpointArray[n]);
            ++n;
        }
    }

    public void runToLine(IFile iFile, int n) {
        if (DBGpLogger.debugBP()) {
            DBGpLogger.debug("runtoline: " + iFile + " " + n);
        }
        if (this.isSuspended()) {
            try {
                IBreakpoint iBreakpoint = this.bpFacade.createRunToLineBreakpoint(iFile, n);
                IBreakpointManager iBreakpointManager = DebugPlugin.getDefault().getBreakpointManager();
                iBreakpointManager.addBreakpoint(iBreakpoint);
                this.resume();
            }
            catch (DebugException debugException) {
                DBGpLogger.logException("Unexpected DebugException", this, debugException);
            }
            catch (CoreException coreException) {
                DBGpLogger.logException("Unexpected CoreException", this, coreException);
            }
        }
    }

    public void breakpointManagerEnablementChanged(boolean bl) {
        IBreakpoint[] iBreakpointArray = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(this.bpFacade.getBreakpointModelID());
        int n = 0;
        while (n < iBreakpointArray.length) {
            if (this.supportsBreakpoint(iBreakpointArray[n])) {
                if (bl) {
                    this.breakpointAdded(iBreakpointArray[n]);
                } else {
                    this.breakpointRemoved(iBreakpointArray[n], null);
                }
            }
            ++n;
        }
    }

    private void queueBpCmd(DBGpBreakpointCmd dBGpBreakpointCmd) {
        if (dBGpBreakpointCmd.getCmd().equals("breakpoint_remove")) {
            boolean bl = false;
            if (this.DBGpCmdQueue.size() > 0) {
                int n = this.DBGpCmdQueue.size() - 1;
                while (n >= 0 && !bl) {
                    DBGpBreakpointCmd dBGpBreakpointCmd2 = (DBGpBreakpointCmd)this.DBGpCmdQueue.get(n);
                    if (dBGpBreakpointCmd2.getCmd().equals("breakpoint_set") && dBGpBreakpointCmd.getBp().getFileName().equals(dBGpBreakpointCmd2.getBp().getFileName()) && dBGpBreakpointCmd.getBp().getLineNumber() == dBGpBreakpointCmd2.getBp().getLineNumber()) {
                        bl = true;
                        this.DBGpCmdQueue.remove(n);
                        if (DBGpLogger.debugBP()) {
                            DBGpLogger.debug("removed a breakpoint command: " + dBGpBreakpointCmd2);
                        }
                    }
                    --n;
                }
            }
            if (!bl) {
                this.DBGpCmdQueue.add(dBGpBreakpointCmd);
            }
        } else {
            this.DBGpCmdQueue.add(dBGpBreakpointCmd);
        }
    }

    private void processQueuedBpCmds() {
        if (DBGpLogger.debugBP()) {
            DBGpLogger.debug("processing deferred BP cmds");
        }
        int n = 0;
        while (n < this.DBGpCmdQueue.size()) {
            DBGpBreakpointCmd dBGpBreakpointCmd = (DBGpBreakpointCmd)this.DBGpCmdQueue.get(n);
            if (dBGpBreakpointCmd.getCmd().equals("breakpoint_set")) {
                this.sendBreakpointAddCmd(dBGpBreakpointCmd.getBp(), true);
            } else if (dBGpBreakpointCmd.getCmd().equals("breakpoint_remove")) {
                this.sendBreakpointRemoveCmd(dBGpBreakpointCmd.getBp(), true);
            }
            ++n;
        }
        this.DBGpCmdQueue.clear();
    }

    public boolean SessionCreated(DBGpSession dBGpSession) {
        boolean bl = false;
        bl = DBGpSessionHandler.getInstance().isCorrectSession(dBGpSession, this);
        if (bl) {
            if (this.session == null && !this.isTerminating()) {
                dBGpSession.setDebugTarget(this);
                this.session = dBGpSession;
                if (1 == this.targetState || this.targetState == 0) {
                    this.te.signalEvent();
                } else {
                    this.initiateSession();
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    public String getIdeKey() {
        return this.ideKey;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public boolean isWebLaunch() {
        return this.webLaunch;
    }

    private int getMaxDepth() {
        if (this.sessionPreferences != null) {
            return this.sessionPreferences.getInt("MaxDepth", 3);
        }
        return 3;
    }

    private boolean showGLobals() {
        if (this.sessionPreferences != null) {
            return this.sessionPreferences.getBoolean("ShowGlobals", true);
        }
        return true;
    }

    private static class DBGpBreakpointCmd {
        private String cmd;
        private DBGpBreakpoint bp;

        public DBGpBreakpointCmd(String string, DBGpBreakpoint dBGpBreakpoint) {
            this.cmd = string;
            this.bp = dBGpBreakpoint;
        }

        public String getCmd() {
            return this.cmd;
        }

        public DBGpBreakpoint getBp() {
            return this.bp;
        }
    }

    private static class DBGpBreakpointCondition {
        private String hitCondition;
        private String hitValue;
        private String expression;
        private int type = 0;
        public static final int NONE = 0;
        public static final int HIT = 1;
        public static final int EXPR = 2;
        public static final int INVALID = 3;

        public DBGpBreakpointCondition(DBGpBreakpoint dBGpBreakpoint) {
            if (dBGpBreakpoint.isConditional() && dBGpBreakpoint.isConditionEnabled()) {
                String string = dBGpBreakpoint.getExpression().trim();
                if (string.endsWith(")") && (string.startsWith("hit(") || string.startsWith("HIT("))) {
                    if (string.length() > 5) {
                        this.type = 1;
                        String string2 = string.substring(4, string.length() - 1).trim();
                        if (string2.startsWith("%")) {
                            this.hitCondition = "%";
                            this.hitValue = string2.substring(1).trim();
                        } else {
                            this.hitCondition = string2.substring(0, 2);
                            if (this.hitCondition.equals("==") || this.hitCondition.equals(">=")) {
                                this.hitValue = string2.substring(2).trim();
                            } else {
                                this.type = 3;
                            }
                        }
                        if (this.type != 3) {
                            try {
                                Integer.parseInt(this.hitValue);
                            }
                            catch (NumberFormatException numberFormatException) {
                                this.type = 3;
                            }
                        }
                    } else {
                        this.type = 3;
                    }
                } else if (string.length() == 0) {
                    this.type = 0;
                    this.expression = string;
                } else {
                    this.type = 2;
                    this.expression = string;
                }
            }
        }

        public String getExpression() {
            return this.expression;
        }

        public String getHitCondition() {
            return this.hitCondition;
        }

        public String getHitValue() {
            return this.hitValue;
        }

        public int getType() {
            return this.type;
        }
    }
}

