/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.tablewizard.ui.wizardpages.pk;

import java.util.Collection;
import java.util.List;
import org.eclipse.datatools.modelbase.sql.constraints.PrimaryKey;
import org.eclipse.datatools.modelbase.sql.constraints.SQLConstraintsFactory;
import org.eclipse.datatools.modelbase.sql.tables.PersistentTable;
import org.eclipse.datatools.sqltools.tablewizard.ui.utils.EObjectListPropertyContentProvider;
import org.eclipse.datatools.sqltools.tablewizard.ui.utils.ResourceLoader;
import org.eclipse.datatools.sqltools.tablewizard.ui.utils.TableColumnsPropertyLabelProvider;
import org.eclipse.datatools.sqltools.tablewizard.ui.wizardpages.pk.GenericPrimaryKeyComposite;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class GenericPrimaryKeyPage
extends WizardPage {
    private static final String PRIMARY_KEY_DEFAULT_NAME = "primary_key.default.name";
    private static final String PRIMARY_KEY_PAGE_TITLE_LABEL = "primary_key.page.title.label";
    private static final String PRIMARY_KEY_PAGE_DESCRIPTION_LABEL = "primary_key.page.description.label";
    private final PersistentTable table;
    private PrimaryKey primaryKey;

    public GenericPrimaryKeyPage(String pageName, PersistentTable table) {
        super(pageName);
        this.table = table;
        this.primaryKey = table.getPrimaryKey();
        if (this.primaryKey == null) {
            this.primaryKey = SQLConstraintsFactory.eINSTANCE.createPrimaryKey();
            this.primaryKey.setName(ResourceLoader.queryString(PRIMARY_KEY_DEFAULT_NAME));
        }
    }

    public void createControl(Composite parent) {
        this.setTitle(ResourceLoader.queryString(PRIMARY_KEY_PAGE_TITLE_LABEL));
        this.setDescription(ResourceLoader.queryString(PRIMARY_KEY_PAGE_DESCRIPTION_LABEL));
        GenericPrimaryKeyComposite composite = new GenericPrimaryKeyComposite(parent, 0);
        this.setControl((Control)composite);
        this.bindPrimaryKeyName(composite);
        this.bindMemberList(composite);
    }

    private void bindPrimaryKeyName(GenericPrimaryKeyComposite composite) {
        composite.getPrimaryKeynNameText().setText(this.primaryKey.getName());
        composite.getPrimaryKeynNameText().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GenericPrimaryKeyPage.this.primaryKey.setName((String)e.data);
            }
        });
    }

    private void bindMemberList(GenericPrimaryKeyComposite composite) {
        composite.getPrimaryKeyMemberListViewer().setContentProvider((IContentProvider)new EObjectListPropertyContentProvider(7));
        int[] observeChildrenIDs = new int[]{1, 7};
        composite.getPrimaryKeyMemberListViewer().setLabelProvider((IBaseLabelProvider)new TableColumnsPropertyLabelProvider((EObject)this.table, 7, observeChildrenIDs));
        composite.getPrimaryKeyMemberListViewer().setInput((Object)this.table);
        composite.getPrimaryKeyMemberListViewer().addSelectionChangedListener((ISelectionChangedListener)new PrimaryKeyListViewerChangeLitener());
    }

    private class PrimaryKeyListViewerChangeLitener
    implements ISelectionChangedListener {
        private PrimaryKeyListViewerChangeLitener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection = event.getSelection();
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection ss = (IStructuredSelection)selection;
                List columns = ss.toList();
                GenericPrimaryKeyPage.this.primaryKey.getMembers().clear();
                if (columns.size() > 0) {
                    GenericPrimaryKeyPage.this.table.getConstraints().add((Object)GenericPrimaryKeyPage.this.primaryKey);
                    GenericPrimaryKeyPage.this.primaryKey.getMembers().addAll((Collection)columns);
                } else {
                    GenericPrimaryKeyPage.this.table.getConstraints().remove((Object)GenericPrimaryKeyPage.this.primaryKey);
                }
            }
        }
    }
}

