/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jdtutility;

import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.internal.codeassist.ISelectionRequestor;
import org.eclipse.jdt.internal.codeassist.SelectionEngine;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.jpt.core.internal.JptCorePlugin;

public class JDTTools {
    public static IImportDeclaration addImport(org.eclipse.jdt.core.ICompilationUnit compilationUnit, String importElement) {
        return JDTTools.addImport(compilationUnit, importElement, 0);
    }

    public static IImportDeclaration addStaticImport(org.eclipse.jdt.core.ICompilationUnit compilationUnit, String importElement) {
        return JDTTools.addImport(compilationUnit, importElement, 8);
    }

    public static IImportDeclaration addImport(org.eclipse.jdt.core.ICompilationUnit compilationUnit, String importElement, int flags) {
        try {
            return compilationUnit.createImport(importElement, null, flags, null);
        }
        catch (JavaModelException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static org.eclipse.jdt.core.dom.CompilationUnit createASTRoot(IMember member) {
        return member.isBinary() ? JDTTools.createASTRoot(member.getClassFile()) : JDTTools.createASTRoot(member.getCompilationUnit());
    }

    public static org.eclipse.jdt.core.dom.CompilationUnit createASTRoot(IClassFile classFile) {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(classFile);
        return (org.eclipse.jdt.core.dom.CompilationUnit)parser.createAST(null);
    }

    public static org.eclipse.jdt.core.dom.CompilationUnit createASTRoot(org.eclipse.jdt.core.ICompilationUnit compilationUnit) {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(compilationUnit);
        return (org.eclipse.jdt.core.dom.CompilationUnit)parser.createAST(null);
    }

    public static IType findType(String packageName, String qualifiedTypeName, IJavaProject javaProject) {
        try {
            if (javaProject != null) {
                return javaProject.findType(packageName, qualifiedTypeName.replace('$', '.'));
            }
        }
        catch (JavaModelException jme) {
            JptCorePlugin.log(jme);
        }
        return null;
    }

    public static String resolveSignature(String signature, IType type) {
        String elementSignature = Signature.getElementType((String)signature);
        if (JDTTools.signatureIsPrimitive(elementSignature)) {
            return Signature.toString((String)signature);
        }
        String elementTypeName = Signature.toString((String)elementSignature);
        if ((elementTypeName = JDTTools.resolve(elementTypeName, type)) == null) {
            return null;
        }
        int arrayCount = Signature.getArrayCount((String)signature);
        if (arrayCount == 0) {
            return elementTypeName;
        }
        StringBuffer sb = new StringBuffer(elementTypeName.length() + 2 * arrayCount);
        sb.append(elementTypeName);
        int i = arrayCount;
        while (i-- > 0) {
            sb.append('[').append(']');
        }
        return sb.toString();
    }

    public static String resolve(String typeName, IType type) {
        try {
            return JDTTools.resolve_(typeName, type);
        }
        catch (JavaModelException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static String resolve_(String typeName, IType type) throws JavaModelException {
        String[][] resolvedTypes = type.resolveType(typeName);
        if (resolvedTypes == null) {
            return null;
        }
        if (resolvedTypes.length > 1) {
            return null;
        }
        return String.valueOf(resolvedTypes[0][0]) + "." + resolvedTypes[0][1];
    }

    public static boolean signatureIsPrimitive(String signature) {
        return Signature.getTypeSignatureKind((String)signature) == 2;
    }

    public static String resolveEnum(org.eclipse.jdt.core.ICompilationUnit sourceUnit, Expression enumExpression) {
        return JDTTools.resolveEnum(sourceUnit, enumExpression.getStartPosition(), enumExpression.getStartPosition() + enumExpression.getLength() - 1);
    }

    public static String resolveEnum(org.eclipse.jdt.core.ICompilationUnit sourceUnit, int enumSourceStart, int enumSourceEnd) {
        try {
            return JDTTools.resolveEnum_(sourceUnit, enumSourceStart, enumSourceEnd);
        }
        catch (JavaModelException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static String resolveEnum_(org.eclipse.jdt.core.ICompilationUnit sourceUnit, int enumSourceStart, int enumSourceEnd) throws JavaModelException {
        String[][] resolvedEnums = JDTTools.resolveField_((CompilationUnit)sourceUnit, enumSourceStart, enumSourceEnd);
        if (resolvedEnums == null) {
            return null;
        }
        if (resolvedEnums.length > 1) {
            return null;
        }
        return String.valueOf(resolvedEnums[0][0]) + "." + resolvedEnums[0][1] + "." + resolvedEnums[0][2];
    }

    private static String[][] resolveField_(CompilationUnit sourceUnit, int selectionSourceStart, int selectionSourceEnd) throws JavaModelException {
        class TypeResolveRequestor
        implements ISelectionRequestor {
            String[][] answers = null;

            TypeResolveRequestor() {
            }

            public void acceptType(char[] packageName, char[] tName, int modifiers, boolean isDeclaration, char[] uniqueKey, int start, int end) {
            }

            public void acceptError(CategorizedProblem error) {
            }

            public void acceptField(char[] declaringTypePackageName, char[] declaringTypeName, char[] fieldName, boolean isDeclaration, char[] uniqueKey, int start, int end) {
                String[] answer = new String[]{new String(declaringTypePackageName), new String(declaringTypeName), new String(fieldName)};
                if (this.answers == null) {
                    this.answers = new String[][]{answer};
                } else {
                    int len = this.answers.length;
                    this.answers = new String[len + 1][];
                    System.arraycopy(this.answers, 0, this.answers, 0, len);
                    this.answers[len] = answer;
                }
            }

            public void acceptMethod(char[] declaringTypePackageName, char[] declaringTypeName, String enclosingDeclaringTypeSignature, char[] selector, char[][] parameterPackageNames, char[][] parameterTypeNames, String[] parameterSignatures, char[][] typeParameterNames, char[][][] typeParameterBoundNames, boolean isConstructor, boolean isDeclaration, char[] uniqueKey, int start, int end) {
            }

            public void acceptPackage(char[] packageName) {
            }

            public void acceptTypeParameter(char[] declaringTypePackageName, char[] declaringTypeName, char[] typeParameterName, boolean isDeclaration, int start, int end) {
            }

            public void acceptMethodTypeParameter(char[] declaringTypePackageName, char[] declaringTypeName, char[] selector, int selectorStart, int selcetorEnd, char[] typeParameterName, boolean isDeclaration, int start, int end) {
            }
        }
        TypeResolveRequestor requestor = new TypeResolveRequestor();
        JavaProject project = (JavaProject)sourceUnit.getJavaProject();
        SearchableEnvironment environment = project.newSearchableNameEnvironment((WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
        SelectionEngine engine = new SelectionEngine(environment, (ISelectionRequestor)requestor, project.getOptions(true));
        engine.select((ICompilationUnit)sourceUnit, selectionSourceStart, selectionSourceEnd);
        return requestor.answers;
    }
}

