/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jdtutility;

import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jpt.core.internal.jdtutility.AbstractExpressionConverter;
import org.eclipse.jpt.core.internal.jdtutility.ExpressionConverter;
import org.eclipse.jpt.core.internal.jdtutility.StringExpressionConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringArrayExpressionConverter<E extends Expression>
extends AbstractExpressionConverter<String[], ArrayInitializer> {
    private final ExpressionConverter<String, E> elementConverter;

    public StringArrayExpressionConverter(ExpressionConverter<String, E> elementConverter) {
        this.elementConverter = elementConverter;
    }

    @Override
    protected ArrayInitializer convert_(String[] strings, AST ast) {
        ArrayInitializer arrayInitializer = ast.newArrayInitializer();
        List<Expression> expressions = this.expressions(arrayInitializer);
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            expressions.add((Expression)this.elementConverter.convert(string, ast));
            ++n2;
        }
        return arrayInitializer;
    }

    private List<Expression> expressions(ArrayInitializer arrayInitializer) {
        return arrayInitializer.expressions();
    }

    @Override
    protected String[] convert_(ArrayInitializer arrayInitializer) {
        List<E> expressions = this.downcastExpressions(arrayInitializer);
        int len = expressions.size();
        String[] strings = new String[len];
        int i = len;
        while (i-- > 0) {
            strings[i] = this.elementConverter.convert((Expression)expressions.get(i));
        }
        return strings;
    }

    private List<E> downcastExpressions(ArrayInitializer arrayInitializer) {
        return arrayInitializer.expressions();
    }

    public static StringArrayExpressionConverter<StringLiteral> forStringLiterals() {
        return new StringArrayExpressionConverter<StringLiteral>(StringExpressionConverter.instance());
    }
}

