/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.platform;

import java.util.List;
import org.eclipse.jpt.core.internal.IPersistentType;
import org.eclipse.jpt.core.internal.content.java.IJavaAttributeMapping;
import org.eclipse.jpt.core.internal.content.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.internal.platform.BaseContext;
import org.eclipse.jpt.core.internal.platform.DefaultsContext;
import org.eclipse.jpt.core.internal.platform.GeneratorRepository;
import org.eclipse.jpt.core.internal.platform.IContext;
import org.eclipse.jpt.core.internal.platform.JavaAttributeContext;
import org.eclipse.jpt.core.internal.platform.JavaTypeContext;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaPersistentAttributeContext
extends BaseContext {
    private JavaPersistentAttribute javaPersistentAttribute;
    private JavaAttributeContext javaAttributeMappingContext;
    private JavaAttributeContext defaultJavaAttributeMappingContext;

    public JavaPersistentAttributeContext(IContext parentContext, JavaPersistentAttribute javaPersistentAttribute) {
        super(parentContext);
        this.javaPersistentAttribute = javaPersistentAttribute;
        this.javaAttributeMappingContext = this.buildJavaAttributeMappingContext();
    }

    protected JavaTypeContext javaTypeContext() {
        return (JavaTypeContext)this.getParentContext();
    }

    protected JavaAttributeContext buildJavaAttributeMappingContext() {
        IJavaAttributeMapping javaAttributeMapping = this.javaPersistentAttribute.getSpecifiedMapping();
        if (javaAttributeMapping != null) {
            return (JavaAttributeContext)this.getPlatform().buildJavaAttributeContext(this, javaAttributeMapping);
        }
        return null;
    }

    @Override
    protected void initialize() {
    }

    protected void populateGeneratorRepository(GeneratorRepository generatorRepository) {
        if (this.javaAttributeMappingContext != null) {
            this.javaAttributeMappingContext.populateGeneratorRepository(generatorRepository);
        }
    }

    protected boolean embeddableOwned() {
        return this.getPersistentAttribute().typeMapping().getKey() == "embeddable";
    }

    protected boolean entityOwned() {
        return this.getPersistentAttribute().typeMapping().getKey() == "entity";
    }

    @Override
    public final void refreshDefaults(DefaultsContext defaultsContext) {
        defaultsContext = this.wrapDefaultsContext(defaultsContext);
        this.refreshDefaultsInternal(defaultsContext);
    }

    protected void refreshDefaultsInternal(DefaultsContext defaultsContext) {
        this.javaPersistentAttribute.refreshDefaults(defaultsContext);
        if (this.javaAttributeMappingContext != null) {
            this.javaAttributeMappingContext.refreshDefaults(defaultsContext);
            this.defaultJavaAttributeMappingContext = null;
        } else {
            IJavaAttributeMapping javaAttributeMapping = this.javaPersistentAttribute.getDefaultMapping();
            if (javaAttributeMapping != null) {
                this.defaultJavaAttributeMappingContext = (JavaAttributeContext)this.getPlatform().buildJavaAttributeContext(this, javaAttributeMapping);
                this.defaultJavaAttributeMappingContext.refreshDefaults(defaultsContext);
            }
        }
    }

    protected JavaPersistentAttribute getPersistentAttribute() {
        return this.javaPersistentAttribute;
    }

    public final DefaultsContext wrapDefaultsContext(final DefaultsContext defaultsContext) {
        return new DefaultsContext(){

            public Object getDefault(String key) {
                return JavaPersistentAttributeContext.this.getDefault(key, defaultsContext);
            }

            public IPersistentType persistentType(String fullyQualifiedTypeName) {
                return defaultsContext.persistentType(fullyQualifiedTypeName);
            }
        };
    }

    protected Object getDefault(String key, DefaultsContext defaultsContext) {
        if (key.equals("column.name")) {
            return this.getPersistentAttribute().getName();
        }
        return defaultsContext.getDefault(key);
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        super.addToMessages(messages);
        if (this.javaAttributeMappingContext != null) {
            this.javaAttributeMappingContext.addToMessages(messages);
        } else if (this.defaultJavaAttributeMappingContext != null) {
            this.defaultJavaAttributeMappingContext.addToMessages(messages);
        }
    }
}

