/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.platform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jpt.core.internal.content.orm.XmlSingleRelationshipMapping;
import org.eclipse.jpt.core.internal.content.orm.XmlTypeMapping;
import org.eclipse.jpt.core.internal.mappings.IJoinColumn;
import org.eclipse.jpt.core.internal.platform.DefaultsContext;
import org.eclipse.jpt.core.internal.platform.IContext;
import org.eclipse.jpt.core.internal.platform.JoinColumnContext;
import org.eclipse.jpt.core.internal.platform.XmlRelationshipMappingContext;
import org.eclipse.jpt.core.internal.validation.JpaValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XmlSingleRelationshipMappingContext
extends XmlRelationshipMappingContext {
    private Collection<JoinColumnContext> joinColumnContexts = this.buildJoinColumnContexts();

    protected XmlSingleRelationshipMappingContext(IContext parentContext, XmlSingleRelationshipMapping mapping) {
        super(parentContext, mapping);
    }

    protected Collection<JoinColumnContext> buildJoinColumnContexts() {
        ArrayList<JoinColumnContext> contexts = new ArrayList<JoinColumnContext>();
        Iterator i = this.singleRelationshipMapping().getJoinColumns().iterator();
        while (i.hasNext()) {
            contexts.add(new JoinColumnContext((IContext)this, (IJoinColumn)i.next()));
        }
        return contexts;
    }

    protected XmlSingleRelationshipMapping singleRelationshipMapping() {
        return (XmlSingleRelationshipMapping)this.relationshipMapping();
    }

    @Override
    public void refreshDefaults(DefaultsContext defaultsContext) {
        super.refreshDefaults(defaultsContext);
        for (JoinColumnContext context : this.joinColumnContexts) {
            context.refreshDefaults(defaultsContext);
        }
    }

    @Override
    protected Object getDefault(String key, DefaultsContext defaultsContext) {
        if (key.equals("joinColumn.table")) {
            return this.singleRelationshipMapping().typeMapping().getTableName();
        }
        return super.getDefault(key, defaultsContext);
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        super.addToMessages(messages);
        if (this.entityOwned() && this.isOwningSide()) {
            this.addJoinColumnMessages(messages);
        }
    }

    protected abstract boolean isOwningSide();

    protected void addJoinColumnMessages(List<IMessage> messages) {
        XmlSingleRelationshipMapping mapping = this.singleRelationshipMapping();
        XmlTypeMapping typeMapping = mapping.typeMapping();
        for (IJoinColumn joinColumn : mapping.getJoinColumns()) {
            String table = joinColumn.getTable();
            boolean doContinue = joinColumn.isConnected();
            if (doContinue && typeMapping.tableNameIsInvalid(table)) {
                if (mapping.isVirtual()) {
                    messages.add(JpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_JOIN_COLUMN_UNRESOLVED_TABLE", new String[]{mapping.getPersistentAttribute().getName(), table, joinColumn.getName()}, joinColumn, joinColumn.tableTextRange()));
                } else {
                    messages.add(JpaValidationMessages.buildMessage(1, "JOIN_COLUMN_UNRESOLVED_TABLE", new String[]{table, joinColumn.getName()}, joinColumn, joinColumn.tableTextRange()));
                }
                doContinue = false;
            }
            if (doContinue && !joinColumn.isResolved()) {
                if (mapping.isVirtual()) {
                    messages.add(JpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_JOIN_COLUMN_UNRESOLVED_NAME", new String[]{mapping.getPersistentAttribute().getName(), joinColumn.getName()}, joinColumn, joinColumn.nameTextRange()));
                } else {
                    messages.add(JpaValidationMessages.buildMessage(1, "JOIN_COLUMN_UNRESOLVED_NAME", new String[]{joinColumn.getName()}, joinColumn, joinColumn.nameTextRange()));
                }
            }
            if (!doContinue || joinColumn.isReferencedColumnResolved()) continue;
            if (mapping.isVirtual()) {
                messages.add(JpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_JOIN_COLUMN_REFERENCED_COLUMN_UNRESOLVED_NAME", new String[]{mapping.getPersistentAttribute().getName(), joinColumn.getReferencedColumnName(), joinColumn.getName()}, joinColumn, joinColumn.referencedColumnNameTextRange()));
                continue;
            }
            messages.add(JpaValidationMessages.buildMessage(1, "JOIN_COLUMN_REFERENCED_COLUMN_UNRESOLVED_NAME", new String[]{joinColumn.getReferencedColumnName(), joinColumn.getName()}, joinColumn, joinColumn.referencedColumnNameTextRange()));
        }
    }
}

