/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.util;

import java.util.HashMap;
import org.eclipse.datatools.enablement.oda.xml.util.RelationInformation;
import org.eclipse.datatools.enablement.oda.xml.util.SaxParserUtil;
import org.eclipse.datatools.enablement.oda.xml.util.ThreshHoldInfo;

class NestedColumnUtil {
    private HashMap nestedXMLColumns;
    private RelationInformation relationInfo;
    private String tableName;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.datatools.enablement.oda.xml.util.NestedColumnUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    NestedColumnUtil(RelationInformation relationInfo, String tableName, boolean isSimple) {
        this.relationInfo = relationInfo;
        this.tableName = tableName == null ? "" : tableName.trim();
        String[] namesOfNestedColumns = isSimple ? relationInfo.getTableSimpleNestedXMLColumnNames(this.tableName) : relationInfo.getTableComplexNestedXMLColumnNames(this.tableName);
        this.nestedXMLColumns = new HashMap();
        int i = 0;
        while (i < namesOfNestedColumns.length) {
            int backRefNumber = relationInfo.getTableNestedColumnBackRefNumber(tableName, namesOfNestedColumns[i]);
            int forwardRefNumber = relationInfo.getTableColumnForwardRefNumber(tableName, namesOfNestedColumns[i]);
            this.nestedXMLColumns.put(namesOfNestedColumns[i], new ThreshHoldInfo(backRefNumber, forwardRefNumber, isSimple));
            ++i;
        }
    }

    String getNestedColumnValue(String columnName, String currentRootPath) {
        ThreshHoldInfo thInfo = (ThreshHoldInfo)this.nestedXMLColumns.get(columnName);
        if (!$assertionsDisabled && columnName == null) {
            throw new AssertionError();
        }
        return thInfo.getValue(currentRootPath);
    }

    void update(String columnName, String path, String value) {
        String columnPath = this.relationInfo.getTableColumnPath(this.tableName, columnName);
        if (SaxParserUtil.isSamePath(columnPath, path)) {
            ((ThreshHoldInfo)this.nestedXMLColumns.get(columnName)).addInfo(path, value);
        }
    }
}

